/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.ContainedPublicKeyParser;
import com.hastobe.transparenzsoftware.verification.DecodingException;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.TransactionValidationException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationException;
import com.hastobe.transparenzsoftware.verification.VerificationParser;
import com.hastobe.transparenzsoftware.verification.VerificationParserFactory;
import com.hastobe.transparenzsoftware.verification.VerificationTypeNotImplementedException;
import com.hastobe.transparenzsoftware.verification.input.InvalidInputException;
import com.hastobe.transparenzsoftware.verification.result.Error;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.Value;
import com.hastobe.transparenzsoftware.verification.xml.Values;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Verifier {
    private static final Logger LOGGER = LogManager.getLogger(Verifier.class);
    private final VerificationParserFactory factory;

    public Verifier(VerificationParserFactory factory) {
        this.factory = factory;
    }

    public List<VerificationResult> verifyValues(Values values) {
        ArrayList<VerificationResult> resultList = new ArrayList<VerificationResult>();
        for (Value value : values.getValues()) {
            resultList.add(this.verify(value));
        }
        return resultList;
    }

    public VerificationResult verify(Value value) {
        VerificationResult result = null;
        try {
            value.validate(false);
            String publicKey = value.getPublicKey() != null ? value.getPublicKey().getValue() : null;
            result = this.verify(value.getSignedData().getValue(), publicKey);
        }
        catch (InvalidInputException e) {
            Error error = new Error(Error.Type.INPUT, e.getMessage(), e.getLocalizedMessageKey());
            result = new VerificationResult(error);
        }
        catch (VerificationTypeNotImplementedException e) {
            Error error = new Error(null, "Format not found", "error.format.unknown");
            result = new VerificationResult(error);
        }
        return result;
    }

    public VerificationResult verify(String data, String publicKey) throws VerificationTypeNotImplementedException {
        List<VerificationParser> possibleParser = this.factory.getParserWithData(data);
        ArrayList<String> parserNames = new ArrayList<String>();
        for (VerificationParser parser : possibleParser) {
            parserNames.add(parser.getVerificationType().name());
        }
        LOGGER.info(String.format("%s parser found to try formats: %s", possibleParser.size(), String.join((CharSequence)",", parserNames)));
        return this.verify(possibleParser, data, publicKey);
    }

    public VerificationResult verify(VerificationParser parser, String data, String publicKey) {
        return this.verify(Collections.singletonList(parser), data, publicKey);
    }

    public VerificationResult verifyTransaction(VerificationParser parser, List<Value> transactionValues, String publicKey) throws TransactionValidationException {
        int startCount = 0;
        int stopCount = 0;
        Value startValue = null;
        Value stopValue = null;
        BigInteger transactionId = null;
        for (Value value : transactionValues) {
            if (value.getContext() != null && value.getContext().trim().equals("Transaction.Begin")) {
                ++startCount;
                startValue = value;
            }
            if (value.getContext() != null && value.getContext().trim().equals("Transaction.End")) {
                ++stopCount;
                stopValue = value;
            }
            transactionId = value.getTransactionId();
        }
        if (startCount == 0) {
            throw new TransactionValidationException("No start value for transaction found", "error.values.no.start");
        }
        if (stopCount == 0) {
            throw new TransactionValidationException("No stop value for transaction found", "error.values.no.stop");
        }
        if (startCount > 1) {
            throw new TransactionValidationException("Too many start values for transaction found", "error.values.toomany.start");
        }
        if (stopCount > 1) {
            throw new TransactionValidationException("Too many stop values for transaction found", "error.values.toomany.stop");
        }
        VerificationResult verificationResultStart = this.verify(parser, startValue.getSignedData().getValue(), publicKey);
        VerificationResult verificationResultStop = this.verify(parser, stopValue.getSignedData().getValue(), publicKey);
        if (verificationResultStart == null || verificationResultStop == null) {
            throw new TransactionValidationException("Unknown error on verification results", "app.view.error.generic");
        }
        LOGGER.debug("Verify transaction " + startValue.getTransactionId() + " now with");
        LOGGER.debug("Result 1: " + verificationResultStart.isVerified());
        LOGGER.debug("Result 2: " + verificationResultStop.isVerified());
        VerificationResult result = null;
        try {
            result = VerificationResult.mergeVerificationData(verificationResultStart, verificationResultStop, transactionId);
        }
        catch (ValidationException e) {
            throw new TransactionValidationException(e.getMessage(), e.getLocalizedMessageKey(), e);
        }
        if (result.isVerified()) {
            try {
                Meter.validateListStartStop(verificationResultStart.getMeters(), verificationResultStop.getMeters());
            }
            catch (ValidationException e) {
                throw new TransactionValidationException(e.getMessage(), e.getLocalizedMessageKey(), e);
            }
        }
        return result;
    }

    public VerificationResult verify(List<VerificationParser> parsers, String data, String publicKey) {
        VerificationResult result = null;
        Error lastError = null;
        if (parsers.isEmpty()) {
            lastError = new Error(Error.Type.INPUT, "Could not find a parser for this format.", "error.parse.payload");
            return new VerificationResult(lastError);
        }
        Error error = null;
        for (VerificationParser parser : parsers) {
            ArrayList<String> publicKeysToUse = new ArrayList<String>();
            if (publicKey != null) {
                publicKeysToUse.add(publicKey);
            }
            try {
                String embeddedPublicKey = this.checkForEmbeddedPublicKey(parser, publicKey, data);
                if (publicKey == null && embeddedPublicKey != null) {
                    publicKeysToUse.add(embeddedPublicKey);
                }
            }
            catch (InvalidInputException e) {
                if (publicKey != null) {
                    error = new Error(Error.Type.VERIFICATION, "Public key does not match with public key in data", "app.view.error.publickeynotmatchdata");
                }
                try {
                    String embeddedPublicKey = this.checkForEmbeddedPublicKey(parser, null, data);
                    if (embeddedPublicKey != null) {
                        publicKeysToUse.add(embeddedPublicKey);
                    }
                }
                catch (InvalidInputException embeddedPublicKey) {
                    // empty catch block
                }
            }
            if (publicKeysToUse.isEmpty()) {
                return new VerificationResult(new Error(Error.Type.INPUT, "Could not find a public key to use", "error.no.publickeysfoundduringverify"));
            }
            for (String keyToTry : publicKeysToUse) {
                try {
                    result = this.tryParser(parser, keyToTry, data);
                    if (result == null || !result.isVerified()) continue;
                    break;
                }
                catch (VerificationException e) {
                    lastError = e.getError();
                }
            }
            if (result == null || !result.isVerified()) continue;
            break;
        }
        if (result == null) {
            result = new VerificationResult(lastError);
        }
        if (error != null) {
            result.addError(error);
        }
        return result;
    }

    public VerificationResult tryParser(VerificationParser parser, String publicKeyToUse, String data) throws VerificationException {
        if (publicKeyToUse == null || publicKeyToUse.trim().isEmpty()) {
            Error error = new Error(Error.Type.VALIDATION, "Could not find a parser for this public key.", "error.values.publickey.cannot.encode");
            throw new VerificationException(error);
        }
        List<EncodingType> keyTypes = EncodingType.guessType(publicKeyToUse);
        if (keyTypes.isEmpty()) {
            Error error = new Error(Error.Type.INPUT, "no encoding found for key", "error.values.publickey.cannot.encode");
            throw new VerificationException(error);
        }
        VerificationResult result = null;
        Error lastError = null;
        for (EncodingType encodingType : keyTypes) {
            try {
                VerificationResult newResult = parser.parseAndVerify(data, EncodingType.decode(encodingType, publicKeyToUse));
                if (newResult != null && newResult.isVerified()) {
                    result = newResult;
                    break;
                }
                if (result != null && result.containsErrorOfType(Error.Type.VERIFICATION)) continue;
                result = newResult;
            }
            catch (DecodingException e) {
                if (lastError != null) continue;
                lastError = new Error(Error.Type.INPUT, "Could not decode public key", "error.values.publickey.cannot.encode");
            }
        }
        return result;
    }

    public String checkForEmbeddedPublicKey(VerificationParser parser, String decodedPublicKey, String payloadData) throws InvalidInputException {
        if (parser instanceof ContainedPublicKeyParser) {
            String containedPublicKey = ((ContainedPublicKeyParser)((Object)parser)).parsePublicKey(payloadData);
            if (decodedPublicKey == null) {
                return containedPublicKey;
            }
            if (!Utils.compareEncodedStrings(decodedPublicKey, containedPublicKey)) {
                throw new InvalidInputException("Public key of does not match with public key in data", "app.view.error.publickeynotmatchdata");
            }
        }
        return decodedPublicKey;
    }
}

