/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.alfen;

import com.hastobe.transparenzsoftware.verification.DecodingException;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenSignature;

public class AlfenReader {
    public AlfenSignature parseString(String data) throws ValidationException {
        Split split = new Split(data);
        try {
            byte[] dataSet = EncodingType.base32Decode(split.dataset);
            byte[] signature = EncodingType.base32Decode(split.signature);
            AlfenSignature payload = new AlfenSignature(split.identifier, split.type, split.blobVersion, split.publicKey, dataSet, signature);
            return payload;
        }
        catch (DecodingException e) {
            throw new ValidationException("Could not parse alfen string", "error.alfen.validation");
        }
    }

    private class Split {
        private static final String SEPERATOR = ";";
        private static final int POS_IDENTIFIER = 0;
        private static final int POS_TYPE = 1;
        private static final int POS_BLOB_VERSION = 2;
        private static final int POS_PUBLIC_KEY = 3;
        private static final int POS_DATASET = 4;
        private static final int POS_SIGNATURE = 5;
        private String identifier;
        private String type;
        private String blobVersion;
        private String publicKey;
        private String dataset;
        private String signature;

        private Split(String data) throws ValidationException {
            String[] splitted = data.split(SEPERATOR);
            if (splitted.length != 6) {
                throw new ValidationException("Invalid length of datablocks in dataset", "error.alfen.invaliddatablocklength");
            }
            this.identifier = splitted[0];
            this.type = splitted[1];
            this.blobVersion = splitted[2];
            this.publicKey = splitted[3];
            this.dataset = splitted[4];
            this.signature = splitted[5];
        }
    }
}

