/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.alfen;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationLogger;
import com.hastobe.transparenzsoftware.verification.format.sml.Verifier;
import java.math.BigInteger;
import java.security.Security;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;

public class AlfenSignatureVerifier
implements Verifier {
    private static final Logger LOGGER = LogManager.getLogger(AlfenSignatureVerifier.class);
    private static final int PLUS_SIGN = 1;
    public static final String ELLIPTIC_CURVE_ALGORITHM = "secp192r1";
    public static final int SIGNATURE_LENGTH = 48;

    public AlfenSignatureVerifier() {
        Security.addProvider(new BouncyCastleProvider());
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] signature, byte[] payloadData) throws ValidationException {
        ECPublicKeyParameters publicKeyParsed;
        ECDSASigner signer = new ECDSASigner();
        X9ECParameters ecParameters = SECNamedCurves.getByName(ELLIPTIC_CURVE_ALGORITHM);
        ECCurve curve = ecParameters.getCurve();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(curve, ecParameters.getG(), ecParameters.getN(), ecParameters.getH(), ecParameters.getSeed());
        try {
            publicKeyParsed = new ECPublicKeyParameters(curve.decodePoint(publicKey), ecDomainParameters);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid point given for public key", (Throwable)e);
            throw new ValidationException("Invalid public key point given", "error.invalid.public.key");
        }
        if (signature.length != 48) {
            throw new ValidationException("Invalid length of signature given", "error.invalid.signature.length");
        }
        BigInteger signatureR = new BigInteger(1, Utils.copyFromWithLength(signature, 0, 24));
        BigInteger signatureS = new BigInteger(1, Utils.copyFromWithLength(signature, 24, 24));
        byte[] hashedData = Utils.hashSHA256(payloadData);
        signer.init(false, publicKeyParsed);
        boolean verify = signer.verifySignature(hashedData, signatureR, signatureS);
        VerificationLogger.log("ALFEN", ELLIPTIC_CURVE_ALGORITHM, publicKey, hashedData, signature, verify);
        return verify;
    }
}

