/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.alfen;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.gui.views.helper.DetailsList;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.FormatComparisonException;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenSignature;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.OffsetDateTimeAdapter;
import com.hastobe.transparenzsoftware.verification.xml.VerifiedData;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="verifiedData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AlfenVerifiedData
extends VerifiedData {
    public static final String MESSAGE_CODE_METER_ERROR = "app.verify.alfen.status.metererroroccurred";
    private boolean meterError;
    private boolean adapterError;
    private boolean meterStartMismatch;
    private String identifier;
    private String type;
    private String blobVersion;
    private String publicKey;
    private String adapterId;
    private String adapterFirmwareVersion;
    private String adapterFirmwareChecksum;
    private String meterId;
    private String status;
    private long secondIndex;
    private OffsetDateTime timestamp;
    private String obisId;
    private String unit;
    private String scalar;
    private long value;
    private String uid;
    private long sessionId;
    private long paging;
    private String signature;
    private EncodingType encodingType;
    private List<Meter> meters;

    public AlfenVerifiedData() {
    }

    public AlfenVerifiedData(AlfenSignature signatureData, EncodingType encodingType) {
        this.identifier = signatureData.getIdentifier();
        this.type = signatureData.getType();
        this.blobVersion = signatureData.getBlobVersion();
        this.publicKey = signatureData.getPublicKey();
        this.adapterId = Utils.toFormattedHex(signatureData.getAdapterId());
        this.adapterFirmwareVersion = new String(signatureData.getAdapterFirmwareVersion());
        this.adapterFirmwareChecksum = Utils.toFormattedHex(signatureData.getAdapterFirmwareChecksum());
        this.meterId = Utils.toFormattedHex(signatureData.getMeterId());
        this.status = Utils.toFormattedHex(signatureData.getStatus());
        if (signatureData.getStatus() != null && signatureData.getStatus().length == 4) {
            this.meterError = Utils.areBitSet(signatureData.getStatus(), new int[]{1, 2});
            this.adapterError = Utils.areBitSet(signatureData.getStatus(), new int[]{16, 30, 31});
            this.meterStartMismatch = Utils.areBitSet(signatureData.getStatus(), new int[]{26});
        } else {
            this.adapterError = false;
            this.meterError = false;
        }
        this.secondIndex = signatureData.getSecondIndexAsLong();
        this.timestamp = signatureData.getTimestampAsLocalDate();
        this.obisId = Utils.toFormattedHex(signatureData.getObisId());
        this.unit = Utils.toFormattedHex(signatureData.getUnit());
        this.scalar = Utils.toFormattedHex(signatureData.getScalar());
        this.value = signatureData.getValueAsLong();
        this.uid = new String(signatureData.getUid(), StandardCharsets.UTF_8);
        this.sessionId = signatureData.getSessionIdAsLong();
        this.paging = signatureData.getPagingAsLong();
        this.signature = Utils.toFormattedHex(signatureData.getSignature());
        this.encodingType = encodingType;
        this.meters = new ArrayList<Meter>();
        double kwhMeterValue = this.value != 0L ? (double)this.value * Math.pow(10.0, signatureData.getScalar()) / 1000.0 : 0.0;
        this.meters.add(new Meter(kwhMeterValue, this.timestamp, signatureData.getScalar()));
    }

    @Override
    public List<Meter> getMeters() {
        return this.meters;
    }

    @Override
    public String getFormat() {
        return VerificationType.ALFEN.name();
    }

    @Override
    public DetailsList getAdditionalData() {
        DetailsList addData = new DetailsList();
        String publicKey = this.getPublicKey() != null ? this.getPublicKey().toLowerCase() : "";
        addData.put(Translator.get("app.verify.alfen.publicKey"), Utils.splitStringToGroups(publicKey, 4));
        addData.put(Translator.get("app.verify.alfen.adapterId"), this.getAdapterId());
        addData.put(Translator.get("app.verify.alfen.adapterFirmwareVersion"), this.getAdapterFirmwareVersion());
        addData.put(Translator.get("app.verify.alfen.adapterFirmwareChecksum"), this.getAdapterFirmwareChecksum());
        addData.put(Translator.get("app.verify.alfen.meterId"), this.getMeterId());
        addData.put(Translator.get("app.verify.alfen.status"), this.getStatus());
        if (this.getMeters().size() > 0) {
            OffsetDateTime offsetDateTime = this.getMeters().get(0).getTimestamp();
            addData.put(Translator.get("app.view.timestamp"), OffsetDateTimeAdapter.formattedDateTime(offsetDateTime));
        }
        try {
            this.calculateMeterError();
            this.calculateAdapterError();
            this.calculateMeterreadingMismatchError();
        }
        catch (RegulationLawException e) {
            addData.put(Translator.get("app.verify.alfen.statusinfo"), e.getLocalizedMessage());
        }
        addData.put(Translator.get("app.verify.alfen.secondIndex"), this.getSecondIndex());
        addData.put(Translator.get("app.verify.alfen.obisId"), this.getObisId());
        addData.put(Translator.get("app.verify.alfen.unit"), this.getUnit());
        addData.put(Translator.get("app.verify.alfen.scalar"), this.getScalar());
        addData.put(Translator.get("app.verify.alfen.UID"), this.getUid());
        addData.put(Translator.get("app.verify.alfen.sessionId"), this.getSessionId());
        addData.put(Translator.get("app.verify.alfen.paging"), this.getPaging());
        addData.put(Translator.get("app.verify.alfen.signature"), this.getSignature());
        return addData;
    }

    @Override
    public boolean lawConform(VerifiedData other) throws RegulationLawException, ValidationException {
        if (!(other instanceof AlfenVerifiedData)) {
            throw new FormatComparisonException();
        }
        AlfenVerifiedData otherData = (AlfenVerifiedData)other;
        if (this.getSessionId() != otherData.getSessionId()) {
            throw new RegulationLawException("Session id differs between values", "app.verify.law.conform.session.id.differs");
        }
        if (this.getPaging() >= otherData.getPaging()) {
            throw new RegulationLawException("Pagination is of start is higher or equal than the pagination of stop", "app.verify.law.conform.pagination.wrong");
        }
        if (this.value > otherData.value) {
            throw new RegulationLawException("Meter value of start is higher than meter value of stop", "app.verify.law.conform.meter.wrong");
        }
        return true;
    }

    public void calculateMeterError() throws RegulationLawException {
        if (this.meterError) {
            throw new RegulationLawException(String.format("Meter error occured", new Object[0]), MESSAGE_CODE_METER_ERROR);
        }
    }

    public void calculateAdapterError() throws RegulationLawException {
        if (this.adapterError) {
            throw new RegulationLawException(String.format("Adapter error occured", new Object[0]), MESSAGE_CODE_METER_ERROR);
        }
    }

    public void calculateMeterreadingMismatchError() throws RegulationLawException {
        if (this.meterStartMismatch) {
            throw new RegulationLawException(String.format("Meterreading mismatch error occured", new Object[0]), MESSAGE_CODE_METER_ERROR);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getType() {
        return this.type;
    }

    public String getBlobVersion() {
        return this.blobVersion;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getEncoding() {
        return this.encodingType.getCode();
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public String getMeterId() {
        return this.meterId;
    }

    public String getStatus() {
        return this.status;
    }

    public long getSecondIndex() {
        return this.secondIndex;
    }

    public String getObisId() {
        return this.obisId;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getScalar() {
        return this.scalar;
    }

    public String getUid() {
        return this.uid;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getPaging() {
        return this.paging;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getAdapterFirmwareVersion() {
        return this.adapterFirmwareVersion;
    }

    public String getAdapterFirmwareChecksum() {
        return this.adapterFirmwareChecksum;
    }
}

