/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.ocmf;

import com.hastobe.transparenzsoftware.verification.xml.Meter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;

public abstract class Reading {
    protected String TM;
    protected String TX;
    protected String RV;
    protected String RI;
    protected String RU;
    private String ST;

    public OffsetDateTime getTimestamp() {
        if (this.TM == null) {
            return null;
        }
        String[] splitted = this.TM.split(" ");
        if (splitted.length < 2) {
            return null;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss,SSSZ");
            return OffsetDateTime.parse(splitted[0], formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getTimeSynchronicity() {
        if (this.TM == null) {
            return null;
        }
        String[] splitted = this.TM.split(" ");
        if (splitted.length < 2) {
            return null;
        }
        return splitted[1];
    }

    public Meter.TimeSyncType getTimeSyncType() {
        String syncr = this.getTimeSynchronicity();
        Meter.TimeSyncType result = Meter.TimeSyncType.INFORMATIVE;
        if (syncr != null) {
            switch (this.getTimeSynchronicity().toUpperCase()) {
                case "I": {
                    result = Meter.TimeSyncType.INFORMATIVE;
                    break;
                }
                case "S": {
                    result = Meter.TimeSyncType.SYNCHRONIZED;
                    break;
                }
                case "R": {
                    result = Meter.TimeSyncType.REALTIME;
                    break;
                }
            }
        }
        return result;
    }

    public String getLabelForTimeFlag() {
        if (this.getTimeSynchronicity() == null) {
            return null;
        }
        String labelForFlag = "app.verify.ocmf.timesynchronicity.unknown";
        switch (this.getTimeSynchronicity()) {
            case "I": {
                labelForFlag = "app.verify.ocmf.timesynchronicity.informative";
                break;
            }
            case "S": {
                labelForFlag = "app.verify.ocmf.timesynchronicity.synchronised";
                break;
            }
            case "R": {
                labelForFlag = "app.verify.ocmf.timesynchronicity.relative";
                break;
            }
        }
        return labelForFlag;
    }

    public String getTM() {
        return this.TM;
    }

    public void setTM(String TM) {
        this.TM = TM;
    }

    public String getTX() {
        return this.TX;
    }

    public void setTX(String TX) {
        this.TX = TX;
    }

    public Double getRV() {
        if (this.RV == null) {
            return null;
        }
        return Double.parseDouble(this.RV);
    }

    public void setRV(Double RV) {
        this.RV = RV == null ? null : Double.toString(RV);
    }

    public String getRI() {
        return this.RI;
    }

    public void setRI(String RI) {
        this.RI = RI;
    }

    public String getRU() {
        return this.RU;
    }

    public void setRU(String RU) {
        this.RU = RU;
    }

    public String getST() {
        return this.ST;
    }

    public void setST(String ST) {
        this.ST = ST;
    }

    public boolean isStartTransaction() {
        return this.getTX() != null && this.getTX().trim().equals("B");
    }

    public boolean isStopTransaction() {
        List<String> stopCodes = Arrays.asList("E", "L", "R", "A", "P");
        return this.getTX() != null && stopCodes.contains(this.getTX().trim());
    }

    public Double getEI() {
        return null;
    }

    public String getEF() {
        return null;
    }

    public int getRVDigits() {
        if (this.RV == null || this.RV.length() == 0) {
            return -1;
        }
        int k = this.RV.indexOf(46);
        int l = this.RV.length();
        if (k < 0) {
            return 3;
        }
        switch (l -= k) {
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return -1;
            }
            case 6: {
                return -2;
            }
        }
        return -1;
    }
}

