/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.pcdf;

import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.format.pcdf.PcdfAttribute;
import com.hastobe.transparenzsoftware.verification.format.pcdf.PcdfChargingData;
import com.hastobe.transparenzsoftware.verification.format.pcdf.PcdfDCMeterType;
import com.hastobe.transparenzsoftware.verification.format.pcdf.PcdfIdTagType;
import com.hastobe.transparenzsoftware.verification.input.InvalidInputException;
import com.hastobe.transparenzsoftware.verification.xml.PublicKey;
import com.hastobe.transparenzsoftware.verification.xml.SignedData;
import com.hastobe.transparenzsoftware.verification.xml.Value;
import com.hastobe.transparenzsoftware.verification.xml.Values;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PcdfReader {
    private PcdfChargingData cd = new PcdfChargingData();
    private static HashMap<String, String> attributes;
    private ArrayList<String> missing;

    public PcdfReader() {
        attributes = new HashMap();
        attributes.put("ST", "parseSTAttrib");
        attributes.put("CT", "parseCTAttrib");
        attributes.put("CD", "parseCDAttrib");
        attributes.put("TV", "parseTVAttrib");
        attributes.put("SP", "parseSPAttrib");
        attributes.put("RV", "parseRVAttrib");
        attributes.put("SI", "parseSIAttrib");
        attributes.put("CS", "parseCSAttrib");
        attributes.put("HW", "parseHWAttrib");
        attributes.put("DT", "parseDTAttrib");
        attributes.put("PK", "parsePKAttrib");
        attributes.put("SG", "parseSGAttrib");
        attributes.put("BV", "parseBVAttrib");
        attributes.put("CSC", "parseCSCAttrib");
        this.missing = new ArrayList();
        this.missing.add("ST");
        this.missing.add("CT");
        this.missing.add("CD");
        this.missing.add("TV");
        this.missing.add("SP");
        this.missing.add("RV");
        this.missing.add("SI");
        this.missing.add("CS");
        this.missing.add("HW");
        this.missing.add("DT");
        this.missing.add("PK");
        this.missing.add("SG");
        this.missing.add("BV");
        this.missing.add("CSC");
    }

    private String parseSTAttrib(String val) throws ValidationException {
        if (val.length() != 12) {
            throw new ValidationException("Time information length is invalid", "error.pcdf.validation.time.length");
        }
        String res = this.convertTime(val);
        if (res.indexOf("TSW") == -1) {
            this.cd.setStartTime(res);
            res = "";
        }
        return res;
    }

    private String parseCTAttrib(String val) throws ValidationException {
        if (val.length() != 12) {
            throw new ValidationException("Time information length is invalid", "error.pcdf.validation.time.length");
        }
        String res = this.convertTime(val);
        if (res.indexOf("TSW") == -1) {
            this.cd.setCurrentTime(res);
            res = "";
        }
        return res;
    }

    private String parseCDAttrib(String val) throws ValidationException {
        String res = this.convertDuration(val);
        if (res.indexOf("TSW") == -1) {
            res = "";
        }
        return res;
    }

    private String parseTVAttrib(String val) throws ValidationException {
        String res = "";
        if (val.equals("0")) {
            this.cd.setValidTime(false);
        } else if (val.equals("1")) {
            this.cd.setValidTime(true);
        } else {
            throw new ValidationException("Time validity bit is invalid", "error.pcdf.validation.time.validity.invalid");
        }
        return res;
    }

    private String parseSPAttrib(String val) throws ValidationException {
        String res = "";
        if (val.equals("0")) {
            this.cd.setStopInfo(false);
            throw new ValidationException("Charge session does not include the last data", "error.pcdf.validation.stoptime.invalid");
        }
        if (!val.equals("1")) {
            throw new ValidationException("Charge session does not include the last data", "error.pcdf.validation.stoptime.invalid");
        }
        this.cd.setStopInfo(true);
        return res;
    }

    private PcdfIdTagType getTagType(int intType) {
        PcdfIdTagType idTT = PcdfIdTagType.ITT_UNKNOWN;
        if (intType == 1) {
            idTT = PcdfIdTagType.ITT_RFID;
        }
        if (intType == 2) {
            idTT = PcdfIdTagType.ITT_eMAID;
        }
        if (intType == 3) {
            idTT = PcdfIdTagType.ITT_CREDITCARD;
        }
        if (intType == 4) {
            idTT = PcdfIdTagType.ITT_REMOTE;
        }
        if (intType == 5) {
            idTT = PcdfIdTagType.ITT_NFC;
        }
        return idTT;
    }

    private String parseRVAttrib(String val) throws ValidationException {
        String res = "";
        String[] vll = val.split("\\*");
        if (vll.length != 2) {
            throw new ValidationException("Session information is invalid", "error.pcdf.validation.consumption.invalid");
        }
        String cons = vll[0];
        if (cons.length() != 8) {
            throw new ValidationException("Session information is invalid", "error.pcdf.validation.consumption.invalid");
        }
        try {
            this.cd.setConsumption(Double.parseDouble(cons));
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Session information is invalid", "error.pcdf.validation.consumption.invalid");
        }
        String unit = vll[1];
        if (!unit.equals("kWh")) {
            throw new ValidationException("Session information is invalid", "error.pcdf.validation.consumption.invalid");
        }
        return res;
    }

    private String parseSIAttrib(String val) throws ValidationException {
        String res = "";
        if (val.length() < 5 || val.length() > 75) {
            throw new ValidationException("Session information length is invalid", "error.pcdf.validation.session.length");
        }
        String[] vll = val.split("\\*");
        if (vll.length != 3) {
            throw new ValidationException("Session information is invalid", "error.pcdf.validation.session.invalid");
        }
        if (vll[0].length() < 1 || vll[0].length() > 36) {
            throw new ValidationException("Session information length is invalid", "error.pcdf.validation.session.length");
        }
        if (vll[1].length() != 1) {
            throw new ValidationException("Session information length is invalid", "error.pcdf.validation.session.length");
        }
        if (vll[2].length() < 1 || vll[2].length() > 36) {
            throw new ValidationException("Session information length is invalid", "error.pcdf.validation.session.length");
        }
        this.cd.setIdTag(vll[0]);
        this.cd.setTxId(vll[2]);
        try {
            this.cd.setIdTagType(this.getTagType(Integer.parseInt(vll[1])));
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Session information is invalid", "error.pcdf.validation.session.invalid");
        }
        return res;
    }

    private String parseCSAttrib(String val) throws ValidationException {
        String res = "";
        this.cd.setSWCRC(val);
        if (val.length() != 8) {
            throw new ValidationException("Software Checksum has wrong length", "error.pcdf.validation.software.checksum.length");
        }
        return res;
    }

    private String parseHWAttrib(String val) throws ValidationException {
        String res = "";
        this.cd.setHWSN(val);
        if (val.length() != 11) {
            throw new ValidationException("Hardware Serial has wrong length", "error.pcdf.validation.hardware.serial.length");
        }
        return res;
    }

    private PcdfDCMeterType getDCMeterType(int intType) {
        PcdfDCMeterType dcMeterType = PcdfDCMeterType.DCMT_UNKNOWN;
        if (intType == 0) {
            dcMeterType = PcdfDCMeterType.DCMT_PES_DCMETER_EU;
        }
        return dcMeterType;
    }

    private String parseDTAttrib(String val) throws ValidationException {
        String res = "";
        try {
            this.cd.setDcMT(this.getDCMeterType(Integer.parseInt(val)));
        }
        catch (NumberFormatException e) {
            throw new ValidationException("DCMeter Type information is invalid", "error.pcdf.validation.dcmeter.type.invalid");
        }
        return res;
    }

    private String parsePKAttrib(String val) {
        String res = "";
        this.cd.setPbKey(val);
        return res;
    }

    private String parseSGAttrib(String val) {
        String res = "";
        this.cd.setSign(val);
        return res;
    }

    private String parseBVAttrib(String val) throws ValidationException {
        String res = "";
        if (val.equals("0")) {
            this.cd.setBillValid(false);
            throw new ValidationException("Billing is not possible. DCMeter error", "error.pcdf.validation.billing.invalid");
        }
        if (!val.equals("1")) {
            throw new ValidationException("Billing information is invalid", "error.pcdf.validation.billing.invalid");
        }
        this.cd.setBillValid(true);
        return res;
    }

    private String parseCSCAttrib(String val) throws ValidationException {
        String res = "";
        try {
            this.cd.setCSC(Integer.parseInt(val));
        }
        catch (NumberFormatException e) {
            this.cd.setCSC(0);
            throw new ValidationException("Charging counter is invalid", "error.pcdf.validation.charging.counter.invalid");
        }
        return res;
    }

    private String convertTime(String ts) throws ValidationException {
        String tsd = "";
        try {
            int y = Integer.parseInt(ts.substring(0, 2));
            int m3 = Integer.parseInt(ts.substring(2, 4));
            int d = Integer.parseInt(ts.substring(4, 6));
            int h2 = Integer.parseInt(ts.substring(6, 8));
            int mn = Integer.parseInt(ts.substring(8, 10));
            int sec = Integer.parseInt(ts.substring(10));
            long secCount = h2 * 3600 + mn * 60 + sec;
            if (y < 19) {
                throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
            }
            if (m3 == 0 || m3 > 12) {
                throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
            }
            if (d == 0 || d > 31) {
                throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
            }
            if (h2 > 23) {
                throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
            }
            if (mn > 59) {
                throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
            }
            if (sec > 59) {
                throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
            }
            tsd = "20" + ts.substring(0, 2) + "-" + ts.substring(2, 4) + "-" + ts.substring(4, 6) + "T" + ts.substring(6, 8) + ":" + ts.substring(8, 10) + ":" + ts.substring(10);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Corrupt time information", "error.pcdf.validation.time.invalid");
        }
        return tsd;
    }

    private String convertDuration(String v) throws ValidationException {
        String res = "";
        if (v.length() != 6) {
            throw new ValidationException("Charging duration is invalid", "error.pcdf.validation.charging.duration.invalid");
        }
        String hStr = v.substring(0, 2);
        String mStr = v.substring(2, 4);
        String sStr = v.substring(4, 6);
        int hInt = Integer.parseInt(hStr);
        int mInt = Integer.parseInt(mStr);
        int sInt = Integer.parseInt(sStr);
        if (hInt < 0 || hInt > 99) {
            throw new ValidationException("Charging duration is invalid", "error.pcdf.validation.charging.duration.invalid");
        }
        if (mInt < 0 || mInt > 59) {
            throw new ValidationException("Charging duration is invalid", "error.pcdf.validation.charging.duration.invalid");
        }
        if (sInt < 0 || sInt > 59) {
            throw new ValidationException("Charging duration is invalid", "error.pcdf.validation.charging.duration.invalid");
        }
        this.cd.setDuration(hInt * 3600 + mInt * 60 + sInt);
        return res;
    }

    public Values readPcdfFile(String filename) throws ValidationException, InvalidInputException {
        String result;
        Values vals = new Values();
        ArrayList<Value> listVals = new ArrayList<Value>();
        String content = this.readFileContents(filename);
        if (!content.equals("") && (result = this.parsePcdfFile(content)).equals("")) {
            Value val = new Value();
            PublicKey pbKey = new PublicKey();
            pbKey.setValue(this.cd.getPbKey());
            pbKey.setEncoding("secp256r1");
            val.setPublicKey(pbKey);
            val.setContext(this.cd.getChData());
            val.setTransactionId(this.cd.getTxIdInt());
            SignedData sd = new SignedData();
            sd.setFormat("PCDF");
            sd.setEncoding("SHA256withECDSA");
            sd.setValue(this.cd.getChData());
            val.setSignedData(sd);
            listVals.add(val);
        }
        vals.setValues(listVals);
        return vals;
    }

    public Values readPCDFString(String content) throws ValidationException, InvalidInputException {
        Values vals = new Values();
        ArrayList<Value> listVals = new ArrayList<Value>();
        String result = this.parsePcdfFile(content);
        if (result.equals("")) {
            Value val = new Value();
            PublicKey pbKey = new PublicKey();
            pbKey.setValue(this.cd.getPbKey());
            pbKey.setEncoding("secp256r1");
            val.setPublicKey(pbKey);
            val.setContext(this.cd.getChData());
            val.setTransactionId(this.cd.getTxIdInt());
            SignedData sd = new SignedData();
            sd.setFormat("PCDF");
            sd.setEncoding("SHA256withECDSA");
            sd.setValue(this.cd.getChData());
            val.setSignedData(sd);
            listVals.add(val);
        }
        vals.setValues(listVals);
        return vals;
    }

    private String readFileContents(String filename) throws InvalidInputException {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader reader = new BufferedReader(fr);
            String comp = "";
            try {
                String textLine;
                while ((textLine = reader.readLine()) != null) {
                    comp = comp + textLine;
                }
                fr.close();
                return comp;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvalidInputException("File cannot be read", "error.pcdf.file.not.readable", e);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new InvalidInputException("Input is not a file or the file cannot be found", "error.path.not.a.file", e);
        }
    }

    private String removeSTXETX(String input) {
        String result = "";
        if (input.indexOf("\\u0002") == 0) {
            input = input.substring(6);
        } else if (input.charAt(0) == '\u0002') {
            input = input.substring(1);
        }
        int ps = input.lastIndexOf(")");
        if (ps != -1) {
            input = input.substring(0, ps + 1);
        }
        return input;
    }

    private String removeSTXETX2(String input) throws ValidationException {
        int pss = input.indexOf("128.8.0");
        if (pss != -1) {
            int ps = (input = input.substring(pss)).lastIndexOf(")");
            if (ps != -1) {
                input = input.substring(0, ps + 1);
            }
        } else {
            throw new ValidationException("Charging data is not valid", "error.pcdf.validation.obis.invalid");
        }
        return input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkAndRemoveSTXETX(String input) throws ValidationException {
        String result = "";
        if (input.indexOf("\\u0002") == 0) {
            int ps = (input = input.replaceAll("\\\\u0002", "")).indexOf("\\u0003");
            if (ps == -1) throw new ValidationException("No ETX Marker at the end of the data", "error.pcdf.validation.etx.missing");
            return input.substring(0, ps);
        }
        if (input.getBytes()[0] != 2) throw new ValidationException("No STX Marker at the end of the data", "error.pcdf.validation.stx.missing");
        if (input.getBytes()[input.length() - 1] != 3) throw new ValidationException("No ETX Marker at the end of the data", "error.pcdf.validation.etx.missing");
        return input.substring(1, input.length() - 1);
    }

    private PcdfAttribute detectAttribute(String s2) {
        PcdfAttribute a = new PcdfAttribute();
        String[] attrs = (s2 = s2.replace("(", "")).split(":");
        if (attrs.length != 2) {
            a.setErr(1);
        } else if (attributes.containsKey(attrs[0])) {
            a.setAttrName(attrs[0]);
            a.setAttrVal(attrs[1]);
            a.setErr(0);
        }
        return a;
    }

    private boolean checkPcdfFile(String input) throws InvalidInputException {
        ArrayList<String> miss = new ArrayList<String>();
        miss.add("ST");
        miss.add("CT");
        miss.add("CD");
        miss.add("TV");
        miss.add("SP");
        miss.add("RV");
        miss.add("SI");
        miss.add("CS");
        miss.add("HW");
        miss.add("DT");
        miss.add("PK");
        miss.add("SG");
        miss.add("BV");
        miss.add("CSC");
        int count = 0;
        for (String s2 : miss) {
            if (input.indexOf("(" + s2 + ":") == -1) continue;
            ++count;
        }
        if (count > 0) {
            throw new InvalidInputException("File cannot be read", "error.pcdf.file.not.readable");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parsePcdfFile(String input) throws ValidationException {
        String[] lst;
        String res = "";
        if ((input = this.removeSTXETX2(input)).indexOf("TSW0") == 0) throw new ValidationException("Charging data is not valid", "error.pcdf.validation.obis.invalid");
        if (input.indexOf("128.8.0") != 0) throw new ValidationException("Charging data is not valid", "error.pcdf.validation.obis.invalid");
        input = input.replaceAll("128.8.0", "");
        for (String s2 : lst = input.split("\\)")) {
            PcdfAttribute a = this.detectAttribute(s2);
            if (a.getErr() == 0) {
                String funcName = attributes.get(a.getAttrName());
                this.missing.remove(a.getAttrName());
                if (a.getAttrName().equals("ST")) {
                    this.parseSTAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("CT")) {
                    this.parseCTAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("CD")) {
                    this.parseCDAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("TV")) {
                    this.parseTVAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("BV")) {
                    this.parseBVAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("CSC")) {
                    this.parseCSCAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("SP")) {
                    this.parseSPAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("RV")) {
                    this.parseRVAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("SI")) {
                    this.parseSIAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("CS")) {
                    this.parseCSAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("HW")) {
                    this.parseHWAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("DT")) {
                    this.parseDTAttrib(a.getAttrVal());
                    continue;
                }
                if (a.getAttrName().equals("PK")) {
                    this.parsePKAttrib(a.getAttrVal());
                    continue;
                }
                if (!a.getAttrName().equals("SG")) continue;
                this.parseSGAttrib(a.getAttrVal());
                continue;
            }
            if (a.getErr() <= 0) continue;
            throw new ValidationException("Charging data is not valid", "error.pcdf.validation.format");
        }
        if (this.missing.size() != 0) {
            String missFields = "";
            String sep = "";
            for (String s2 : this.missing) {
                missFields = missFields + sep + s2;
                sep = ",";
            }
            throw new ValidationException("Missing fields in the data tuple", "error.pcdf.validation.data.missing");
        }
        int pos = input.indexOf("(SG:");
        this.cd.setChData("128.8.0" + input);
        return res;
    }
}

