/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.openmuc.jsml.structures.SmlTimestamp;
import org.openmuc.jsml.structures.SmlTimestampLocal;

public class SMLUtils {
    private static final int SECONDS_PER_MINUTE = 60;

    public static OffsetDateTime parseSmlTimestamp(SmlTimestampLocal timestampLocal) {
        int offsetTotal = timestampLocal.getLocalOffset().getVal() * 60;
        Instant instant = Instant.ofEpochSecond(timestampLocal.getTimestamp().getLongValue() + (long)(offsetTotal += timestampLocal.getSeasonTimeOffset().getVal() * 60));
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.ofTotalSeconds(offsetTotal));
        return offsetDateTime;
    }

    public static OffsetDateTime parseSmlTimestamp(SmlTimestamp timestampLocal) {
        int offsetTotal = 0;
        Instant instant = Instant.ofEpochSecond(timestampLocal.getLongValue());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.ofTotalSeconds(offsetTotal));
        return offsetDateTime;
    }
}

