/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml.SignatureOnly;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.ContainedPublicKeyParser;
import com.hastobe.transparenzsoftware.verification.DecodingException;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLSignature;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLValidationException;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLVerificationParserBase;
import com.hastobe.transparenzsoftware.verification.format.sml.SignatureOnly.SMLReader;
import com.hastobe.transparenzsoftware.verification.format.sml.SignatureOnly.SMLVerifiedData;
import com.hastobe.transparenzsoftware.verification.format.sml.SignatureOnly.embedded.SignedMeterValue;
import com.hastobe.transparenzsoftware.verification.result.Error;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;
import com.hastobe.transparenzsoftware.verification.xml.VerifiedData;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureOnlyVerificationParser
extends SMLVerificationParserBase
implements ContainedPublicKeyParser {
    private static final Logger LOGGER = LogManager.getLogger(SignatureOnlyVerificationParser.class);
    private SMLReader smlReader = new SMLReader();

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.EDL_40_SIG;
    }

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey) {
        try {
            SignedMeterValue signedMeterValue = this.smlReader.readFromString(Utils.unescapeXML(data));
            signedMeterValue.validate();
            SMLSignature smlSignature = this.smlReader.parseSMLSigXml(signedMeterValue);
            if (smlSignature.getUnit() != 30) {
                throw new SMLValidationException("Invalid unit present in sml data", "error.sml.invalid.unit");
            }
            SMLVerifiedData verifiedData = new SMLVerifiedData(smlSignature, VerificationType.EDL_40_SIG, EncodingType.PLAIN, Utils.toFormattedHex(publicKey));
            if (this.verifier.verify(publicKey, smlSignature)) {
                return new VerificationResult(verifiedData);
            }
            return new VerificationResult((VerifiedData)verifiedData, Error.withVerificationFailed());
        }
        catch (ValidationException e) {
            return new VerificationResult(Error.withValidationException(e));
        }
    }

    @Override
    public boolean canParseData(String data) {
        try {
            SignedMeterValue signedMeterValue = this.smlReader.readFromString(Utils.unescapeXML(data));
            signedMeterValue.validate();
        }
        catch (ValidationException e) {
            LOGGER.info("Data not matching for " + (Object)((Object)VerificationType.EDL_40_SIG));
            return false;
        }
        LOGGER.info("Match for " + (Object)((Object)VerificationType.EDL_40_SIG) + " detected");
        return true;
    }

    @Override
    public String parsePublicKey(String data) {
        try {
            SignedMeterValue signedMeterValue = this.smlReader.readFromString(Utils.unescapeXML(data));
            return signedMeterValue.getPublicKey() != null ? signedMeterValue.getPublicKey().getCleanedValue() : null;
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public String createFormattedKey(String data) {
        String parsedKey;
        String formattedKey = parsedKey = this.parsePublicKey(data);
        List<EncodingType> encodingTypes = EncodingType.guessType(parsedKey, false);
        if (encodingTypes.size() > 0) {
            try {
                formattedKey = Utils.toFormattedHex(encodingTypes.get(0).decode(parsedKey), 4);
            }
            catch (DecodingException e) {
                LOGGER.warn("Could not decode parsed key", (Throwable)e);
            }
        }
        return formattedKey;
    }
}

