/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.BackgroundPositionShorthand;
import org.apache.fop.fo.properties.BorderSpacingShorthandParser;
import org.apache.fop.fo.properties.BorderWidthPropertyMaker;
import org.apache.fop.fo.properties.BoxPropShorthandParser;
import org.apache.fop.fo.properties.CharacterProperty;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.DimensionPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.FontShorthandParser;
import org.apache.fop.fo.properties.FontShorthandProperty;
import org.apache.fop.fo.properties.FontSizePropertyMaker;
import org.apache.fop.fo.properties.FontStretchPropertyMaker;
import org.apache.fop.fo.properties.FontWeightPropertyMaker;
import org.apache.fop.fo.properties.GenericShorthandParser;
import org.apache.fop.fo.properties.IndentPropertyMaker;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.LineHeightPropertyMaker;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.PageBreakShorthandParser;
import org.apache.fop.fo.properties.PageDimensionMaker;
import org.apache.fop.fo.properties.PositionShorthandParser;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.fo.properties.ReferenceOrientationMaker;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fo.properties.SpacePropertyMaker;
import org.apache.fop.fo.properties.SpacingPropertyMaker;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fo.properties.TableBorderPrecedence;
import org.apache.fop.fo.properties.TextDecorationProperty;
import org.apache.fop.fo.properties.ToBeImplementedProperty;
import org.apache.fop.fo.properties.VerticalAlignShorthandParser;
import org.apache.fop.fo.properties.WhiteSpaceShorthandParser;
import org.apache.fop.fo.properties.XMLLangShorthandParser;

public final class FOPropertyMapping
implements Constants {
    private static Map s_htPropNames = new HashMap();
    private static Map s_htSubPropNames = new HashMap();
    private static Map s_htPropIds = new HashMap();
    private static PropertyMaker[] s_generics = null;
    private Property[] enums = null;
    private PropertyMaker genericColor = null;
    private PropertyMaker genericBoolean = null;
    private PropertyMaker genericKeep = null;
    private PropertyMaker genericCondLength = null;
    private PropertyMaker genericCondPadding = null;
    private PropertyMaker genericPadding = null;
    private PropertyMaker genericCondBorderWidth = null;
    private PropertyMaker genericBorderWidth = null;
    private PropertyMaker genericBorderStyle = null;
    private PropertyMaker genericBreak = null;
    private PropertyMaker genericSpace = null;

    private void createGenerics() {
        this.genericColor = new ColorProperty.Maker(0);
        this.genericBoolean = new EnumProperty.Maker(0);
        this.genericBoolean.addEnum("true", this.getEnumProperty(149, "TRUE"));
        this.genericBoolean.addEnum("false", this.getEnumProperty(48, "FALSE"));
        this.genericKeep = new KeepProperty.Maker(0);
        PropertyMaker sub = new NumberProperty.Maker(5632);
        sub.setByShorthand(true);
        sub.setDefault("auto");
        sub.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        sub.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(sub);
        sub = new NumberProperty.Maker(5120);
        sub.setByShorthand(true);
        sub.setDefault("auto");
        sub.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        sub.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(sub);
        sub = new NumberProperty.Maker(4608);
        sub.setByShorthand(true);
        sub.setDefault("auto");
        sub.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        sub.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(sub);
        this.genericCondLength = new CondLengthProperty.Maker(0);
        sub = new LengthProperty.Maker(2048);
        sub.setByShorthand(true);
        this.genericCondLength.addSubpropMaker(sub);
        sub = new EnumProperty.Maker(1024);
        sub.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        sub.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondLength.addSubpropMaker(sub);
        this.genericCondPadding = new CondLengthProperty.Maker(0);
        this.genericCondPadding.useGeneric(this.genericCondLength);
        this.genericCondPadding.setInherited(false);
        this.genericCondPadding.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondPadding.setPercentBase(5);
        this.genericPadding = new LengthProperty.Maker(0);
        this.genericPadding.setInherited(false);
        this.genericPadding.setDefault("0pt");
        this.genericPadding.setPercentBase(5);
        this.genericPadding.addShorthand(s_generics[154]);
        this.genericCondBorderWidth = new CondLengthProperty.Maker(0);
        this.genericCondBorderWidth.setInherited(false);
        this.genericCondBorderWidth.addKeyword("thin", "0.5pt");
        this.genericCondBorderWidth.addKeyword("medium", "1pt");
        this.genericCondBorderWidth.addKeyword("thick", "2pt");
        sub = new LengthProperty.Maker(2048);
        sub.setByShorthand(true);
        sub.addKeyword("thin", "0.5pt");
        sub.addKeyword("medium", "1pt");
        sub.addKeyword("thick", "2pt");
        sub.setDefault("medium");
        this.genericCondBorderWidth.addSubpropMaker(sub);
        sub = new EnumProperty.Maker(1024);
        sub.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        sub.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondBorderWidth.addSubpropMaker(sub);
        this.genericBorderWidth = new LengthProperty.Maker(0);
        this.genericBorderWidth.setInherited(false);
        this.genericBorderWidth.addKeyword("thin", "0.5pt");
        this.genericBorderWidth.addKeyword("medium", "1pt");
        this.genericBorderWidth.addKeyword("thick", "2pt");
        this.genericBorderWidth.setDefault("medium");
        this.genericBorderStyle = new EnumProperty.Maker(0);
        this.genericBorderStyle.setInherited(false);
        this.genericBorderStyle.addEnum("none", this.getEnumProperty(95, "NONE"));
        this.genericBorderStyle.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        this.genericBorderStyle.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        this.genericBorderStyle.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        this.genericBorderStyle.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        this.genericBorderStyle.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        this.genericBorderStyle.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        this.genericBorderStyle.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        this.genericBorderStyle.addEnum("inset", this.getEnumProperty(67, "INSET"));
        this.genericBorderStyle.addEnum("outset", this.getEnumProperty(101, "OUTSET"));
        this.genericBorderStyle.setDefault("none");
        this.genericBreak = new EnumProperty.Maker(0);
        this.genericBreak.setInherited(false);
        this.genericBreak.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        this.genericBreak.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        this.genericBreak.addEnum("page", this.getEnumProperty(104, "PAGE"));
        this.genericBreak.addEnum("even-page", this.getEnumProperty(44, "EVEN_PAGE"));
        this.genericBreak.addEnum("odd-page", this.getEnumProperty(100, "ODD_PAGE"));
        this.genericBreak.setDefault("auto");
        this.genericSpace = new SpaceProperty.Maker(0);
        this.genericSpace.setInherited(false);
        sub = new LengthProperty.Maker(3072);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        this.genericSpace.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(3584);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        this.genericSpace.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(2560);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        this.genericSpace.addSubpropMaker(sub);
        sub = new NumberProperty.Maker(4096);
        sub.addEnum("force", this.getEnumProperty(53, "FORCE"));
        sub.setDefault("0");
        this.genericSpace.addSubpropMaker(sub);
        sub = new EnumProperty.Maker(1024);
        sub.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        sub.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        sub.setDefault("discard");
        this.genericSpace.addSubpropMaker(sub);
    }

    private static void addPropertyMaker(String name, PropertyMaker maker) {
        FOPropertyMapping.s_generics[maker.getPropId()] = maker;
        s_htPropNames.put(name, new Integer(maker.getPropId()));
        s_htPropIds.put(new Integer(maker.getPropId()), name);
    }

    private static void addSubpropMakerName(String name, int id) {
        s_htSubPropNames.put(name, new Integer(id));
        s_htPropIds.put(new Integer(id), name);
    }

    private Property getEnumProperty(int enumValue, String text) {
        if (this.enums == null) {
            this.enums = new Property[189];
        }
        if (this.enums[enumValue] == null) {
            this.enums[enumValue] = EnumProperty.getInstance(enumValue, text);
        }
        return this.enums[enumValue];
    }

    public static PropertyMaker[] getGenericMappings() {
        if (s_generics == null) {
            s_generics = new PropertyMaker[254];
            FOPropertyMapping gp = new FOPropertyMapping();
            gp.createShorthandProperties();
            gp.createGenerics();
            gp.createAccessibilityProperties();
            gp.createAbsolutePositionProperties();
            gp.createAuralProperties();
            gp.createBorderPaddingBackgroundProperties();
            gp.createFontProperties();
            gp.createHyphenationProperties();
            gp.createMarginBlockProperties();
            gp.createMarginInlineProperties();
            gp.createRelativePosProperties();
            gp.createAreaAlignmentProperties();
            gp.createAreaDimensionProperties();
            gp.createBlockAndLineProperties();
            gp.createCharacterProperties();
            gp.createColorProperties();
            gp.createFloatProperties();
            gp.createKeepsAndBreaksProperties();
            gp.createLayoutProperties();
            gp.createLeaderAndRuleProperties();
            gp.createDynamicProperties();
            gp.createMarkersProperties();
            gp.createNumberToStringProperties();
            gp.createPaginationAndLayoutProperties();
            gp.createTableProperties();
            gp.createWritingModeProperties();
            gp.createMiscProperties();
            FOPropertyMapping.addSubpropMakerName("length", 2048);
            FOPropertyMapping.addSubpropMakerName("conditionality", 1024);
            FOPropertyMapping.addSubpropMakerName("block-progression-direction", 512);
            FOPropertyMapping.addSubpropMakerName("inline-progression-direction", 1536);
            FOPropertyMapping.addSubpropMakerName("within-line", 5120);
            FOPropertyMapping.addSubpropMakerName("within-column", 4608);
            FOPropertyMapping.addSubpropMakerName("within-page", 5632);
            FOPropertyMapping.addSubpropMakerName("minimum", 3072);
            FOPropertyMapping.addSubpropMakerName("maximum", 2560);
            FOPropertyMapping.addSubpropMakerName("optimum", 3584);
            FOPropertyMapping.addSubpropMakerName("precedence", 4096);
        }
        return s_generics;
    }

    public static int getPropertyId(String name) {
        Integer i;
        if (name != null && (i = (Integer)s_htPropNames.get(name)) != null) {
            return i;
        }
        return -1;
    }

    public static int getSubPropertyId(String name) {
        Integer i;
        if (name != null && (i = (Integer)s_htSubPropNames.get(name)) != null) {
            return i;
        }
        return -1;
    }

    public static String getPropertyName(int id) {
        if ((id & 0xFFFFFE00) == 0 || (id & 0x1FF) == 0) {
            return (String)s_htPropIds.get(new Integer(id));
        }
        return (String)s_htPropIds.get(new Integer(id & 0x1FF)) + "." + s_htPropIds.get(new Integer(id & 0xFFFFFE00));
    }

    private void createAccessibilityProperties() {
        StringProperty.Maker m3 = new StringProperty.Maker(199);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("source-document", m3);
        m3 = new StringProperty.Maker(190);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("role", m3);
    }

    private void createAbsolutePositionProperties() {
        EnumProperty.Maker m3 = new EnumProperty.Maker(1);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        m3.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        m3.setDefault("auto");
        m3.addShorthand(s_generics[175]);
        FOPropertyMapping.addPropertyMaker("absolute-position", m3);
        LengthProperty.Maker l = new LengthProperty.Maker(231);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("top", l);
        l = new LengthProperty.Maker(189);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("right", l);
        l = new LengthProperty.Maker(57);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("bottom", l);
        l = new LengthProperty.Maker(127);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("left", l);
    }

    private void createAuralProperties() {
        ToBeImplementedProperty.Maker m3 = new ToBeImplementedProperty.Maker(6);
        m3.setInherited(true);
        m3.setDefault("center");
        FOPropertyMapping.addPropertyMaker("azimuth", m3);
        m3 = new ToBeImplementedProperty.Maker(77);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-after", m3);
        m3 = new ToBeImplementedProperty.Maker(78);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-before", m3);
        m3 = new ToBeImplementedProperty.Maker(83);
        m3.setInherited(true);
        m3.setDefault("level");
        FOPropertyMapping.addPropertyMaker("elevation", m3);
        m3 = new ToBeImplementedProperty.Maker(170);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-after", m3);
        m3 = new ToBeImplementedProperty.Maker(171);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-before", m3);
        m3 = new ToBeImplementedProperty.Maker(172);
        m3.setInherited(true);
        m3.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("pitch", m3);
        m3 = new ToBeImplementedProperty.Maker(173);
        m3.setInherited(true);
        m3.setDefault("50");
        FOPropertyMapping.addPropertyMaker("pitch-range", m3);
        m3 = new ToBeImplementedProperty.Maker(174);
        m3.setInherited(false);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("play-during", m3);
        m3 = new ToBeImplementedProperty.Maker(188);
        m3.setInherited(true);
        m3.setDefault("50");
        FOPropertyMapping.addPropertyMaker("richness", m3);
        m3 = new ToBeImplementedProperty.Maker(205);
        m3.setInherited(true);
        m3.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("speak", m3);
        m3 = new ToBeImplementedProperty.Maker(206);
        m3.setInherited(true);
        m3.setDefault("once");
        FOPropertyMapping.addPropertyMaker("speak-header", m3);
        m3 = new ToBeImplementedProperty.Maker(207);
        m3.setInherited(true);
        m3.setDefault("continuous");
        FOPropertyMapping.addPropertyMaker("speak-numeral", m3);
        m3 = new ToBeImplementedProperty.Maker(208);
        m3.setInherited(true);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("speak-punctuation", m3);
        m3 = new ToBeImplementedProperty.Maker(209);
        m3.setInherited(true);
        m3.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("speech-rate", m3);
        m3 = new ToBeImplementedProperty.Maker(214);
        m3.setInherited(true);
        m3.setDefault("50");
        FOPropertyMapping.addPropertyMaker("stress", m3);
        m3 = new ToBeImplementedProperty.Maker(236);
        m3.setInherited(true);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("voice-family", m3);
        m3 = new ToBeImplementedProperty.Maker(237);
        m3.setInherited(true);
        m3.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("volume", m3);
    }

    private void createBorderPaddingBackgroundProperties() {
        PropertyMaker m3 = new EnumProperty.Maker(8);
        m3.setInherited(false);
        m3.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        m3.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        m3.setDefault("scroll");
        FOPropertyMapping.addPropertyMaker("background-attachment", m3);
        m3 = new ColorProperty.Maker(9){

            protected Property convertPropertyDatatype(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
                String nameval = p.getNCname();
                if (nameval != null) {
                    FObj fobj = fo == null ? propertyList.getFObj() : fo;
                    FOUserAgent ua = fobj == null ? null : fobj.getUserAgent();
                    return ColorProperty.getInstance(ua, nameval);
                }
                return super.convertPropertyDatatype(p, propertyList, fo);
            }
        };
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("transparent");
        FOPropertyMapping.addPropertyMaker("background-color", m3);
        m3 = new StringProperty.Maker(10);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background-image", m3);
        m3 = new EnumProperty.Maker(14);
        m3.setInherited(false);
        m3.addEnum("repeat", this.getEnumProperty(112, "REPEAT"));
        m3.addEnum("repeat-x", this.getEnumProperty(113, "REPEATX"));
        m3.addEnum("repeat-y", this.getEnumProperty(114, "REPEATY"));
        m3.addEnum("no-repeat", this.getEnumProperty(96, "NOREPEAT"));
        m3.setDefault("repeat");
        FOPropertyMapping.addPropertyMaker("background-repeat", m3);
        m3 = new LengthProperty.Maker(12);
        m3.setInherited(false);
        m3.setDefault("0%");
        m3.addKeyword("left", "0%");
        m3.addKeyword("center", "50%");
        m3.addKeyword("right", "100%");
        m3.setPercentBase(9);
        m3.addShorthand(s_generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-horizontal", m3);
        m3 = new LengthProperty.Maker(13);
        m3.setInherited(false);
        m3.setDefault("0%");
        m3.addKeyword("top", "0%");
        m3.addKeyword("center", "50%");
        m3.addKeyword("bottom", "100%");
        m3.setPercentBase(10);
        m3.addShorthand(s_generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-vertical", m3);
        m3 = new ColorProperty.Maker(23);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        CorrespondingPropertyMaker corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(53, 53, 42);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-color", m3);
        m3 = new EnumProperty.Maker(25);
        m3.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(54, 54, 43);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-style", m3);
        m3 = new CondLengthProperty.Maker(26);
        m3.useGeneric(this.genericCondBorderWidth);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(55, 55, 44);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-width", m3);
        m3 = new ColorProperty.Maker(19);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(28, 28, 38);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-color", m3);
        m3 = new EnumProperty.Maker(21);
        m3.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(29, 29, 39);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-style", m3);
        m3 = new CondLengthProperty.Maker(22);
        m3.useGeneric(this.genericCondBorderWidth);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(30, 30, 40);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-width", m3);
        m3 = new ColorProperty.Maker(47);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(38, 42, 53);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-color", m3);
        m3 = new EnumProperty.Maker(49);
        m3.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(39, 43, 54);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-style", m3);
        m3 = new CondLengthProperty.Maker(50);
        m3.useGeneric(this.genericCondBorderWidth);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(40, 44, 55);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-width", m3);
        m3 = new ColorProperty.Maker(33);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(42, 38, 28);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-color", m3);
        m3 = new EnumProperty.Maker(35);
        m3.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(43, 39, 29);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-style", m3);
        m3 = new CondLengthProperty.Maker(36);
        m3.useGeneric(this.genericCondBorderWidth);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(44, 40, 30);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-width", m3);
        m3 = new ColorProperty.Maker(53);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        m3.addShorthand(s_generics[52]);
        m3.addShorthand(s_generics[32]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(23, 23, 47);
        FOPropertyMapping.addPropertyMaker("border-top-color", m3);
        m3 = new EnumProperty.Maker(54);
        m3.useGeneric(this.genericBorderStyle);
        m3.addShorthand(s_generics[52]);
        m3.addShorthand(s_generics[51]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(25, 25, 49);
        FOPropertyMapping.addPropertyMaker("border-top-style", m3);
        BorderWidthPropertyMaker bwm = new BorderWidthPropertyMaker(55);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(54);
        bwm.addShorthand(s_generics[52]);
        bwm.addShorthand(s_generics[56]);
        bwm.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(26, 26, 50);
        FOPropertyMapping.addPropertyMaker("border-top-width", bwm);
        m3 = new ColorProperty.Maker(28);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        m3.addShorthand(s_generics[27]);
        m3.addShorthand(s_generics[32]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(19, 19, 33);
        FOPropertyMapping.addPropertyMaker("border-bottom-color", m3);
        m3 = new EnumProperty.Maker(29);
        m3.useGeneric(this.genericBorderStyle);
        m3.addShorthand(s_generics[27]);
        m3.addShorthand(s_generics[51]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(21, 21, 35);
        FOPropertyMapping.addPropertyMaker("border-bottom-style", m3);
        bwm = new BorderWidthPropertyMaker(30);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(29);
        bwm.addShorthand(s_generics[27]);
        bwm.addShorthand(s_generics[56]);
        bwm.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(22, 22, 36);
        FOPropertyMapping.addPropertyMaker("border-bottom-width", bwm);
        m3 = new ColorProperty.Maker(38);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        m3.addShorthand(s_generics[37]);
        m3.addShorthand(s_generics[32]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(47, 33, 19);
        FOPropertyMapping.addPropertyMaker("border-left-color", m3);
        m3 = new EnumProperty.Maker(39);
        m3.useGeneric(this.genericBorderStyle);
        m3.addShorthand(s_generics[37]);
        m3.addShorthand(s_generics[51]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(49, 35, 21);
        FOPropertyMapping.addPropertyMaker("border-left-style", m3);
        bwm = new BorderWidthPropertyMaker(40);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(39);
        bwm.addShorthand(s_generics[37]);
        bwm.addShorthand(s_generics[56]);
        bwm.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(50, 36, 22);
        FOPropertyMapping.addPropertyMaker("border-left-width", bwm);
        m3 = new ColorProperty.Maker(42);
        m3.useGeneric(this.genericColor);
        m3.setInherited(false);
        m3.setDefault("black");
        m3.addShorthand(s_generics[41]);
        m3.addShorthand(s_generics[32]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(33, 47, 23);
        FOPropertyMapping.addPropertyMaker("border-right-color", m3);
        m3 = new EnumProperty.Maker(43);
        m3.useGeneric(this.genericBorderStyle);
        m3.addShorthand(s_generics[41]);
        m3.addShorthand(s_generics[51]);
        m3.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(35, 49, 25);
        FOPropertyMapping.addPropertyMaker("border-right-style", m3);
        bwm = new BorderWidthPropertyMaker(44);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(43);
        bwm.addShorthand(s_generics[41]);
        bwm.addShorthand(s_generics[56]);
        bwm.addShorthand(s_generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(36, 50, 26);
        FOPropertyMapping.addPropertyMaker("border-right-width", bwm);
        m3 = new CondLengthProperty.Maker(156);
        m3.useGeneric(this.genericCondPadding);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(162, 162, 160);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-before", m3);
        m3 = new CondLengthProperty.Maker(155);
        m3.useGeneric(this.genericCondPadding);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(157, 157, 159);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-after", m3);
        m3 = new CondLengthProperty.Maker(161);
        m3.useGeneric(this.genericCondPadding);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(159, 160, 162);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-start", m3);
        m3 = new CondLengthProperty.Maker(158);
        m3.useGeneric(this.genericCondPadding);
        m3.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(160, 159, 157);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-end", m3);
        m3 = new LengthProperty.Maker(162);
        m3.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(156, 156, 161);
        FOPropertyMapping.addPropertyMaker("padding-top", m3);
        m3 = new LengthProperty.Maker(157);
        m3.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(155, 155, 158);
        FOPropertyMapping.addPropertyMaker("padding-bottom", m3);
        m3 = new LengthProperty.Maker(159);
        m3.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(161, 158, 155);
        FOPropertyMapping.addPropertyMaker("padding-left", m3);
        m3 = new LengthProperty.Maker(160);
        m3.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m3);
        corr.setCorresponding(158, 161, 156);
        FOPropertyMapping.addPropertyMaker("padding-right", m3);
    }

    private void createFontProperties() {
        PropertyMaker m3 = new FontFamilyProperty.Maker(92);
        m3.setInherited(true);
        m3.setDefault("sans-serif");
        m3.addShorthand(s_generics[91]);
        FOPropertyMapping.addPropertyMaker("font-family", m3);
        m3 = new EnumProperty.Maker(93);
        m3.setInherited(true);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("character-by-character", this.getEnumProperty(25, "CHARACTER_BY_CHARACTER"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("font-selection-strategy", m3);
        m3 = new FontSizePropertyMaker(94);
        m3.setInherited(true);
        m3.setDefault("12pt");
        m3.addKeyword("xx-small", "6.944pt");
        m3.addKeyword("x-small", "8.333pt");
        m3.addKeyword("small", "10pt");
        m3.addKeyword("medium", "12pt");
        m3.addKeyword("large", "14.4pt");
        m3.addKeyword("x-large", "17.28pt");
        m3.addKeyword("xx-large", "20.736pt");
        m3.addEnum("larger", this.getEnumProperty(71, "LARGER"));
        m3.addEnum("smaller", this.getEnumProperty(132, "SMALLER"));
        m3.setPercentBase(2);
        m3.addShorthand(s_generics[91]);
        FOPropertyMapping.addPropertyMaker("font-size", m3);
        m3 = new FontStretchPropertyMaker(96);
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m3.addEnum("wider", this.getEnumProperty(160, "WIDER"));
        m3.addEnum("narrower", this.getEnumProperty(85, "NARROWER"));
        m3.addEnum("ultra-condensed", this.getEnumProperty(150, "ULTRA_CONDENSED"));
        m3.addEnum("extra-condensed", this.getEnumProperty(46, "EXTRA_CONDENSED"));
        m3.addEnum("condensed", this.getEnumProperty(29, "CONDENSED"));
        m3.addEnum("semi-condensed", this.getEnumProperty(127, "SEMI_CONDENSED"));
        m3.addEnum("semi-expanded", this.getEnumProperty(128, "SEMI_EXPANDED"));
        m3.addEnum("expanded", this.getEnumProperty(45, "EXPANDED"));
        m3.addEnum("extra-expanded", this.getEnumProperty(47, "EXTRA_EXPANDED"));
        m3.addEnum("ultra-expanded", this.getEnumProperty(151, "ULTRA_EXPANDED"));
        m3.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-stretch", m3);
        m3 = new NumberProperty.Maker(95);
        m3.setInherited(true);
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("font-size-adjust", m3);
        m3 = new EnumProperty.Maker(97);
        m3.setInherited(true);
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m3.addEnum("italic", this.getEnumProperty(164, "ITALIC"));
        m3.addEnum("oblique", this.getEnumProperty(165, "OBLIQUE"));
        m3.addEnum("backslant", this.getEnumProperty(166, "BACKSLANT"));
        m3.setDefault("normal");
        m3.addShorthand(s_generics[91]);
        FOPropertyMapping.addPropertyMaker("font-style", m3);
        m3 = new EnumProperty.Maker(98);
        m3.setInherited(true);
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m3.addEnum("small-caps", this.getEnumProperty(131, "SMALL_CAPS"));
        m3.setDefault("normal");
        m3.addShorthand(s_generics[91]);
        FOPropertyMapping.addPropertyMaker("font-variant", m3);
        m3 = new FontWeightPropertyMaker(99);
        m3.setInherited(true);
        m3.addKeyword("normal", "400");
        m3.addKeyword("bold", "700");
        m3.addEnum("bolder", this.getEnumProperty(167, "BOLDER"));
        m3.addEnum("lighter", this.getEnumProperty(168, "LIGHTER"));
        m3.addEnum("100", this.getEnumProperty(169, "100"));
        m3.addEnum("200", this.getEnumProperty(170, "200"));
        m3.addEnum("300", this.getEnumProperty(171, "300"));
        m3.addEnum("400", this.getEnumProperty(172, "400"));
        m3.addEnum("500", this.getEnumProperty(173, "500"));
        m3.addEnum("600", this.getEnumProperty(174, "600"));
        m3.addEnum("700", this.getEnumProperty(175, "700"));
        m3.addEnum("800", this.getEnumProperty(176, "800"));
        m3.addEnum("900", this.getEnumProperty(177, "900"));
        m3.setDefault("400");
        m3.addShorthand(s_generics[91]);
        FOPropertyMapping.addPropertyMaker("font-weight", m3);
    }

    private void createHyphenationProperties() {
        PropertyMaker m3 = new StringProperty.Maker(75);
        m3.setInherited(true);
        m3.setDefault("none");
        m3.addShorthand(s_generics[246]);
        FOPropertyMapping.addPropertyMaker("country", m3);
        m3 = new StringProperty.Maker(121);
        m3.setInherited(true);
        m3.setDefault("none");
        m3.addShorthand(s_generics[246]);
        FOPropertyMapping.addPropertyMaker("language", m3);
        m3 = new StringProperty.Maker(196);
        m3.setInherited(true);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("script", m3);
        m3 = new EnumProperty.Maker(107);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(true);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("hyphenate", m3);
        m3 = new CharacterProperty.Maker(108);
        m3.setInherited(true);
        m3.setDefault("-");
        FOPropertyMapping.addPropertyMaker("hyphenation-character", m3);
        m3 = new NumberProperty.Maker(111);
        m3.setInherited(true);
        m3.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-push-character-count", m3);
        m3 = new NumberProperty.Maker(112);
        m3.setInherited(true);
        m3.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-remain-character-count", m3);
    }

    private void createMarginBlockProperties() {
        PropertyMaker m3 = new LengthProperty.Maker(138);
        m3.setInherited(false);
        m3.setDefault("0pt");
        m3.addShorthand(s_generics[134]);
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-top", m3);
        m3 = new LengthProperty.Maker(135);
        m3.setInherited(false);
        m3.setDefault("0pt");
        m3.addShorthand(s_generics[134]);
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-bottom", m3);
        m3 = new LengthProperty.Maker(136);
        m3.setInherited(false);
        m3.setDefault("0pt");
        m3.addShorthand(s_generics[134]);
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-left", m3);
        m3 = new LengthProperty.Maker(137);
        m3.setInherited(false);
        m3.setDefault("0pt");
        m3.addShorthand(s_generics[134]);
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-right", m3);
        m3 = new SpaceProperty.Maker(201);
        m3.useGeneric(this.genericSpace);
        SpacePropertyMaker corr = new SpacePropertyMaker(m3);
        corr.setCorresponding(138, 138, 137);
        corr.setUseParent(false);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-before", m3);
        m3 = new SpaceProperty.Maker(200);
        m3.useGeneric(this.genericSpace);
        corr = new SpacePropertyMaker(m3);
        corr.setCorresponding(135, 135, 136);
        corr.setUseParent(false);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-after", m3);
        m3 = new LengthProperty.Maker(211);
        m3.setInherited(true);
        m3.setDefault("0pt");
        m3.setPercentBase(4);
        IndentPropertyMaker sCorr = new IndentPropertyMaker(m3);
        sCorr.setCorresponding(136, 137, 138);
        sCorr.setUseParent(false);
        sCorr.setRelative(true);
        sCorr.setPaddingCorresponding(new int[]{159, 160, 162});
        sCorr.setBorderWidthCorresponding(new int[]{40, 44, 55});
        FOPropertyMapping.addPropertyMaker("start-indent", m3);
        m3 = new LengthProperty.Maker(85);
        m3.setInherited(true);
        m3.setDefault("0pt");
        m3.setPercentBase(4);
        IndentPropertyMaker eCorr = new IndentPropertyMaker(m3);
        eCorr.setCorresponding(137, 136, 135);
        eCorr.setUseParent(false);
        eCorr.setRelative(true);
        eCorr.setPaddingCorresponding(new int[]{160, 159, 157});
        eCorr.setBorderWidthCorresponding(new int[]{44, 40, 30});
        FOPropertyMapping.addPropertyMaker("end-indent", m3);
    }

    private void createMarginInlineProperties() {
        SpaceProperty.Maker m3 = new SpaceProperty.Maker(202);
        ((PropertyMaker)m3).useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-end", m3);
        m3 = new SpaceProperty.Maker(203);
        ((PropertyMaker)m3).useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-start", m3);
    }

    private void createRelativePosProperties() {
        EnumProperty.Maker m3 = new EnumProperty.Maker(183);
        m3.setInherited(false);
        m3.addEnum("static", this.getEnumProperty(136, "STATIC"));
        m3.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        m3.setDefault("static");
        m3.addShorthand(s_generics[175]);
        FOPropertyMapping.addPropertyMaker("relative-position", m3);
    }

    private void createAreaAlignmentProperties() {
        PropertyMaker m3 = new LengthProperty.Maker(3);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m3.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        m3.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        m3.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m3.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        m3.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        m3.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        m3.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        m3.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m3.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        m3.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        m3.setDefault("auto");
        m3.setPercentBase(12);
        m3.addShorthand(s_generics[234]);
        FOPropertyMapping.addPropertyMaker("alignment-adjust", m3);
        m3 = new EnumProperty.Maker(4);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m3.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        m3.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        m3.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m3.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        m3.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        m3.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        m3.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        m3.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m3.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        m3.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        m3.setDefault("auto");
        m3.addShorthand(s_generics[234]);
        FOPropertyMapping.addPropertyMaker("alignment-baseline", m3);
        m3 = new LengthProperty.Maker(15);
        m3.setInherited(false);
        m3.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m3.addEnum("sub", this.getEnumProperty(137, "SUB"));
        m3.addEnum("super", this.getEnumProperty(138, "SUPER"));
        m3.setDefault("baseline");
        m3.addShorthand(s_generics[234]);
        m3.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("baseline-shift", m3);
        m3 = new EnumProperty.Maker(81);
        m3.setInherited(true);
        m3.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m3.addEnum("after", this.getEnumProperty(3, "AFTER"));
        m3.addEnum("center", this.getEnumProperty(23, "CENTER"));
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("distribute", this.getEnumProperty(163, "DISTRIBUTE"));
        m3.addEnum("fill", this.getEnumProperty(162, "FILL"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("display-align", m3);
        m3 = new EnumProperty.Maker(82);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("use-script", this.getEnumProperty(157, "USE_SCRIPT"));
        m3.addEnum("no-change", this.getEnumProperty(87, "NO_CHANGE"));
        m3.addEnum("reset-size", this.getEnumProperty(116, "RESET_SIZE"));
        m3.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        m3.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m3.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        m3.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        m3.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        m3.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m3.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        m3.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        m3.setDefault("auto");
        m3.addShorthand(s_generics[234]);
        FOPropertyMapping.addPropertyMaker("dominant-baseline", m3);
        m3 = new EnumProperty.Maker(182);
        m3.setInherited(true);
        m3.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m3.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m3.setDefault("before");
        FOPropertyMapping.addPropertyMaker("relative-align", m3);
    }

    private void createAreaDimensionProperties() {
        PropertyMaker m3 = new LengthRangeProperty.Maker(17);
        m3.setInherited(false);
        m3.setPercentBase(6);
        LengthProperty.Maker l = new LengthProperty.Maker(3072);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(6);
        l.setByShorthand(true);
        m3.addSubpropMaker(l);
        l = new LengthProperty.Maker(3584);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(6);
        l.setByShorthand(true);
        m3.addSubpropMaker(l);
        l = new LengthProperty.Maker(2560);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(6);
        l.setByShorthand(true);
        m3.addSubpropMaker(l);
        DimensionPropertyMaker pdim = new DimensionPropertyMaker(m3);
        pdim.setCorresponding(106, 106, 242);
        pdim.setExtraCorresponding(new int[][]{{146, 146, 147}, {142, 142, 144}});
        pdim.setRelative(true);
        m3.setCorresponding(pdim);
        FOPropertyMapping.addPropertyMaker("block-progression-dimension", m3);
        l = new LengthProperty.Maker(72);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        l.addEnum("scale-down-to-fit", this.getEnumProperty(187, "SCALE_DOWN_TO_FIT"));
        l.addEnum("scale-up-to-fit", this.getEnumProperty(188, "SCALE_UP_TO_FIT"));
        l.setDefault("auto");
        l.setPercentBase(8);
        FOPropertyMapping.addPropertyMaker("content-height", l);
        l = new LengthProperty.Maker(74);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        l.addEnum("scale-down-to-fit", this.getEnumProperty(187, "SCALE_DOWN_TO_FIT"));
        l.addEnum("scale-up-to-fit", this.getEnumProperty(188, "SCALE_UP_TO_FIT"));
        l.setDefault("auto");
        l.setPercentBase(7);
        FOPropertyMapping.addPropertyMaker("content-width", l);
        l = new LengthProperty.Maker(106);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(6);
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("height", l);
        m3 = new LengthRangeProperty.Maker(116);
        m3.setInherited(false);
        m3.setPercentBase(5);
        l = new LengthProperty.Maker(3072);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(5);
        l.setByShorthand(true);
        m3.addSubpropMaker(l);
        l = new LengthProperty.Maker(3584);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(5);
        l.setByShorthand(true);
        m3.addSubpropMaker(l);
        l = new LengthProperty.Maker(2560);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(5);
        l.setByShorthand(true);
        m3.addSubpropMaker(l);
        pdim = new DimensionPropertyMaker(m3);
        pdim.setRelative(true);
        pdim.setCorresponding(242, 242, 106);
        pdim.setExtraCorresponding(new int[][]{{147, 147, 146}, {144, 144, 142}});
        m3.setCorresponding(pdim);
        FOPropertyMapping.addPropertyMaker("inline-progression-dimension", m3);
        m3 = new ToBeImplementedProperty.Maker(142);
        m3.setInherited(false);
        m3.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("max-height", m3);
        m3 = new ToBeImplementedProperty.Maker(144);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("max-width", m3);
        m3 = new ToBeImplementedProperty.Maker(146);
        m3.setInherited(false);
        m3.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("min-height", m3);
        m3 = new ToBeImplementedProperty.Maker(147);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("min-width", m3);
        m3 = new EnumProperty.Maker(193);
        m3.setInherited(true);
        m3.addEnum("uniform", this.getEnumProperty(154, "UNIFORM"));
        m3.addEnum("non-uniform", this.getEnumProperty(94, "NON_UNIFORM"));
        m3.setDefault("uniform");
        FOPropertyMapping.addPropertyMaker("scaling", m3);
        m3 = new EnumProperty.Maker(194);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("integer-pixels", this.getEnumProperty(69, "INTEGER_PIXELS"));
        m3.addEnum("resample-any-method", this.getEnumProperty(115, "RESAMPLE_ANY_METHOD"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("scaling-method", m3);
        l = new LengthProperty.Maker(242);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(5);
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("width", l);
        l = new LengthProperty.Maker(251);
        l.setInherited(false);
        l.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:block-progression-unit", l);
    }

    private void createBlockAndLineProperties() {
        PropertyMaker m3 = new EnumProperty.Maker(109);
        m3.setInherited(true);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        m3.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("hyphenation-keep", m3);
        m3 = new NumberProperty.Maker(110);
        m3.setInherited(true);
        m3.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        m3.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("hyphenation-ladder-count", m3);
        m3 = new LengthProperty.Maker(122);
        m3.setInherited(true);
        m3.setDefault("0pt");
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("last-line-end-indent", m3);
        m3 = new LineHeightPropertyMaker(131);
        m3.useGeneric(this.genericSpace);
        m3.setInherited(true);
        m3.addKeyword("normal", "1.2");
        m3.setPercentBase(1);
        m3.setDefault("normal", true);
        m3.addShorthand(s_generics[91]);
        FOPropertyMapping.addPropertyMaker("line-height", m3);
        m3 = new EnumProperty.Maker(132);
        m3.setInherited(true);
        m3.addEnum("consider-shifts", this.getEnumProperty(30, "CONSIDER_SHIFTS"));
        m3.addEnum("disregard-shifts", this.getEnumProperty(33, "DISREGARD_SHIFTS"));
        m3.setDefault("consider-shifts");
        FOPropertyMapping.addPropertyMaker("line-height-shift-adjustment", m3);
        m3 = new EnumProperty.Maker(133);
        m3.setInherited(true);
        m3.addEnum("line-height", this.getEnumProperty(76, "LINE_HEIGHT"));
        m3.addEnum("font-height", this.getEnumProperty(52, "FONT_HEIGHT"));
        m3.addEnum("max-height", this.getEnumProperty(83, "MAX_HEIGHT"));
        m3.setDefault("max-height");
        FOPropertyMapping.addPropertyMaker("line-stacking-strategy", m3);
        m3 = new EnumProperty.Maker(130);
        m3.setInherited(true);
        m3.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        m3.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        m3.addEnum("treat-as-space", this.getEnumProperty(147, "TREAT_AS_SPACE"));
        m3.addEnum("treat-as-zero-width-space", this.getEnumProperty(148, "TREAT_AS_ZERO_WIDTH_SPACE"));
        m3.setDefault("treat-as-space");
        m3.addShorthand(s_generics[238]);
        FOPropertyMapping.addPropertyMaker("linefeed-treatment", m3);
        m3 = new EnumProperty.Maker(240);
        m3.setInherited(true);
        m3.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        m3.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        m3.addEnum("ignore-if-before-linefeed", this.getEnumProperty(62, "IGNORE_IF_BEFORE_LINEFEED"));
        m3.addEnum("ignore-if-after-linefeed", this.getEnumProperty(61, "IGNORE_IF_AFTER_LINEFEED"));
        m3.addEnum("ignore-if-surrounding-linefeed", this.getEnumProperty(63, "IGNORE_IF_SURROUNDING_LINEFEED"));
        m3.setDefault("ignore-if-surrounding-linefeed");
        m3.addShorthand(s_generics[238]);
        FOPropertyMapping.addPropertyMaker("white-space-treatment", m3);
        m3 = new EnumProperty.Maker(223);
        m3.setInherited(true);
        m3.addEnum("center", this.getEnumProperty(23, "CENTER"));
        m3.addEnum("end", this.getEnumProperty(39, "END"));
        m3.addEnum("right", this.getEnumProperty(39, "END"));
        m3.addEnum("start", this.getEnumProperty(135, "START"));
        m3.addEnum("left", this.getEnumProperty(135, "START"));
        m3.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        m3.addEnum("inside", this.getEnumProperty(135, "START"));
        m3.addEnum("outside", this.getEnumProperty(39, "END"));
        m3.setDefault("start");
        FOPropertyMapping.addPropertyMaker("text-align", m3);
        m3 = new EnumProperty.Maker(224){

            public Property get(int subpropId, PropertyList propertyList, boolean bTryInherit, boolean bTryDefault) throws PropertyException {
                Property p = super.get(subpropId, propertyList, bTryInherit, bTryDefault);
                if (p != null && p.getEnum() == 110 && (p = propertyList.getNearestSpecified(224)).getEnum() == 110) {
                    return this.calcRelative(propertyList);
                }
                return p;
            }

            private Property calcRelative(PropertyList propertyList) throws PropertyException {
                Property corresponding = propertyList.get(223);
                if (corresponding == null) {
                    return null;
                }
                int correspondingValue = corresponding.getEnum();
                if (correspondingValue == 70) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (correspondingValue == 39) {
                    return FOPropertyMapping.this.getEnumProperty(39, "END");
                }
                if (correspondingValue == 135) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (correspondingValue == 23) {
                    return FOPropertyMapping.this.getEnumProperty(23, "CENTER");
                }
                return null;
            }
        };
        m3.setInherited(false);
        m3.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        m3.addEnum("center", this.getEnumProperty(23, "CENTER"));
        m3.addEnum("end", this.getEnumProperty(39, "END"));
        m3.addEnum("right", this.getEnumProperty(39, "END"));
        m3.addEnum("start", this.getEnumProperty(135, "START"));
        m3.addEnum("left", this.getEnumProperty(135, "START"));
        m3.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        m3.addEnum("inside", this.getEnumProperty(135, "START"));
        m3.addEnum("outside", this.getEnumProperty(39, "END"));
        m3.setDefault("relative", true);
        FOPropertyMapping.addPropertyMaker("text-align-last", m3);
        m3 = new LengthProperty.Maker(228);
        m3.setInherited(true);
        m3.setDefault("0pt");
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("text-indent", m3);
        m3 = new EnumProperty.Maker(239);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(true);
        m3.setDefault("true");
        m3.addShorthand(s_generics[238]);
        FOPropertyMapping.addPropertyMaker("white-space-collapse", m3);
        m3 = new EnumProperty.Maker(244);
        m3.setInherited(true);
        m3.addEnum("wrap", this.getEnumProperty(161, "WRAP"));
        m3.addEnum("no-wrap", this.getEnumProperty(93, "NO_WRAP"));
        m3.setDefault("wrap");
        m3.addShorthand(s_generics[238]);
        FOPropertyMapping.addPropertyMaker("wrap-option", m3);
    }

    private void createCharacterProperties() {
        PropertyMaker m3 = new CharacterProperty.Maker(63);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("character", m3);
        m3 = new SpacingPropertyMaker(128);
        m3.useGeneric(this.genericSpace);
        m3.setInherited(true);
        m3.getSubpropMaker(4096).setDefault("force");
        m3.getSubpropMaker(1024).setDefault("discard");
        m3.setDefault("normal");
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("letter-spacing", m3);
        m3 = new EnumProperty.Maker(215);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("suppress", this.getEnumProperty(139, "SUPPRESS"));
        m3.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("suppress-at-line-break", m3);
        m3 = new TextDecorationProperty.Maker(226);
        m3.setInherited(false);
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.addEnum("underline", this.getEnumProperty(153, "UNDERLINE"));
        m3.addEnum("overline", this.getEnumProperty(103, "OVERLINE"));
        m3.addEnum("line-through", this.getEnumProperty(77, "LINE_THROUGH"));
        m3.addEnum("blink", this.getEnumProperty(17, "BLINK"));
        m3.addEnum("no-underline", this.getEnumProperty(92, "NO_UNDERLINE"));
        m3.addEnum("no-overline", this.getEnumProperty(91, "NO_OVERLINE"));
        m3.addEnum("no-line-through", this.getEnumProperty(90, "NO_LINE_THROUGH"));
        m3.addEnum("no-blink", this.getEnumProperty(86, "NO_BLINK"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-decoration", m3);
        m3 = new ToBeImplementedProperty.Maker(229);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-shadow", m3);
        m3 = new EnumProperty.Maker(230);
        m3.setInherited(true);
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.addEnum("capitalize", this.getEnumProperty(22, "CAPITALIZE"));
        m3.addEnum("uppercase", this.getEnumProperty(155, "UPPERCASE"));
        m3.addEnum("lowercase", this.getEnumProperty(78, "LOWERCASE"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-transform", m3);
        m3 = new EnumProperty.Maker(232);
        m3.useGeneric(this.genericBoolean);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.setInherited(false);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("treat-as-word-space", m3);
        m3 = new SpacingPropertyMaker(243);
        m3.useGeneric(this.genericSpace);
        m3.setInherited(true);
        m3.getSubpropMaker(4096).setDefault("force");
        m3.getSubpropMaker(1024).setDefault("discard");
        m3.setDefault("normal");
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("word-spacing", m3);
    }

    private void createColorProperties() {
        PropertyMaker m3 = new ColorProperty.Maker(66);
        m3.useGeneric(this.genericColor);
        m3.setInherited(true);
        m3.setDefault("black");
        FOPropertyMapping.addPropertyMaker("color", m3);
        m3 = new StringProperty.Maker(67);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("color-profile-name", m3);
        m3 = new EnumProperty.Maker(184);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("perceptual", this.getEnumProperty(107, "PERCEPTUAL"));
        m3.addEnum("relative-colorimetric", this.getEnumProperty(111, "RELATIVE_COLOMETRIC"));
        m3.addEnum("saturation", this.getEnumProperty(124, "SATURATION"));
        m3.addEnum("absolute-colorimetric", this.getEnumProperty(2, "ABSOLUTE_COLORMETRIC"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("rendering-intent", m3);
    }

    private void createFloatProperties() {
        EnumProperty.Maker m3 = new EnumProperty.Maker(64);
        m3.setInherited(false);
        m3.addEnum("start", this.getEnumProperty(135, "START"));
        m3.addEnum("end", this.getEnumProperty(39, "END"));
        m3.addEnum("left", this.getEnumProperty(135, "START"));
        m3.addEnum("right", this.getEnumProperty(39, "END"));
        m3.addEnum("both", this.getEnumProperty(19, "BOTH"));
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("clear", m3);
        m3 = new EnumProperty.Maker(89);
        m3.setInherited(false);
        m3.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m3.addEnum("start", this.getEnumProperty(135, "START"));
        m3.addEnum("end", this.getEnumProperty(39, "END"));
        m3.addEnum("left", this.getEnumProperty(135, "START"));
        m3.addEnum("right", this.getEnumProperty(39, "END"));
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("float", m3);
        m3 = new EnumProperty.Maker(248);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.addEnum("line", this.getEnumProperty(75, "LINE"));
        m3.addEnum("indent", this.getEnumProperty(65, "INDENT"));
        m3.addEnum("block", this.getEnumProperty(18, "BLOCK"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("intrusion-displace", m3);
    }

    private void createKeepsAndBreaksProperties() {
        PropertyMaker m3 = new EnumProperty.Maker(58);
        m3.useGeneric(this.genericBreak);
        m3.addShorthand(s_generics[163]);
        FOPropertyMapping.addPropertyMaker("break-after", m3);
        m3 = new EnumProperty.Maker(59);
        m3.useGeneric(this.genericBreak);
        m3.addShorthand(s_generics[164]);
        FOPropertyMapping.addPropertyMaker("break-before", m3);
        m3 = new KeepProperty.Maker(118);
        m3.useGeneric(this.genericKeep);
        m3.setInherited(true);
        m3.setDefault("auto");
        m3.addShorthand(s_generics[165]);
        FOPropertyMapping.addPropertyMaker("keep-together", m3);
        m3 = new KeepProperty.Maker(119);
        m3.useGeneric(this.genericKeep);
        m3.setInherited(false);
        m3.setDefault("auto");
        m3.addShorthand(s_generics[163]);
        FOPropertyMapping.addPropertyMaker("keep-with-next", m3);
        m3 = new KeepProperty.Maker(120);
        m3.useGeneric(this.genericKeep);
        m3.setInherited(false);
        m3.setDefault("auto");
        m3.addShorthand(s_generics[164]);
        FOPropertyMapping.addPropertyMaker("keep-with-previous", m3);
        m3 = new NumberProperty.Maker(152);
        m3.setInherited(true);
        m3.setDefault("2");
        FOPropertyMapping.addPropertyMaker("orphans", m3);
        m3 = new NumberProperty.Maker(241);
        m3.setInherited(true);
        m3.setDefault("2");
        FOPropertyMapping.addPropertyMaker("widows", m3);
        m3 = new LengthProperty.Maker(252);
        m3.setInherited(true);
        m3.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:widow-content-limit", m3);
        m3 = new LengthProperty.Maker(253);
        m3.setInherited(true);
        m3.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:orphan-content-limit", m3);
    }

    private void createLayoutProperties() {
        PropertyMaker m3 = new ToBeImplementedProperty.Maker(65);
        m3.setInherited(false);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("clip", m3);
        m3 = new EnumProperty.Maker(153);
        m3.setInherited(false);
        m3.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        m3.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        m3.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        m3.addEnum("error-if-overflow", this.getEnumProperty(42, "ERROR_IF_OVERFLOW"));
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("overflow", m3);
        m3 = new ReferenceOrientationMaker(179);
        m3.setInherited(true);
        m3.setDefault("0");
        FOPropertyMapping.addPropertyMaker("reference-orientation", m3);
        m3 = new EnumProperty.Maker(204);
        m3.setInherited(false);
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.addEnum("all", this.getEnumProperty(5, "ALL"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("span", m3);
    }

    private void createLeaderAndRuleProperties() {
        PropertyMaker m3 = new EnumProperty.Maker(123);
        m3.setInherited(true);
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.addEnum("reference-area", this.getEnumProperty(109, "REFERENCE_AREA"));
        m3.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("leader-alignment", m3);
        m3 = new EnumProperty.Maker(125);
        m3.setInherited(true);
        m3.addEnum("space", this.getEnumProperty(134, "SPACE"));
        m3.addEnum("rule", this.getEnumProperty(123, "RULE"));
        m3.addEnum("dots", this.getEnumProperty(35, "DOTS"));
        m3.addEnum("use-content", this.getEnumProperty(158, "USECONTENT"));
        m3.setDefault("space");
        FOPropertyMapping.addPropertyMaker("leader-pattern", m3);
        m3 = new LengthProperty.Maker(126);
        m3.setInherited(true);
        m3.setDefault("use-font-metrics", true);
        m3.addKeyword("use-font-metrics", "0pt");
        m3.setPercentBase(3);
        FOPropertyMapping.addPropertyMaker("leader-pattern-width", m3);
        m3 = new LengthRangeProperty.Maker(124);
        m3.setInherited(true);
        m3.setPercentBase(3);
        LengthProperty.Maker sub = new LengthProperty.Maker(3072);
        sub.setDefault("0pt");
        sub.setPercentBase(5);
        sub.setByShorthand(true);
        m3.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(3584);
        sub.setDefault("12.0pt");
        sub.setPercentBase(5);
        sub.setByShorthand(true);
        m3.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(2560);
        sub.setDefault("100%", true);
        sub.setPercentBase(5);
        sub.setByShorthand(true);
        m3.addSubpropMaker(sub);
        FOPropertyMapping.addPropertyMaker("leader-length", m3);
        m3 = new EnumProperty.Maker(191);
        m3.setInherited(true);
        m3.addEnum("none", this.getEnumProperty(95, "NONE"));
        m3.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        m3.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        m3.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        m3.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        m3.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        m3.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        m3.setDefault("solid");
        FOPropertyMapping.addPropertyMaker("rule-style", m3);
        m3 = new LengthProperty.Maker(192);
        m3.setInherited(true);
        m3.setDefault("1.0pt");
        FOPropertyMapping.addPropertyMaker("rule-thickness", m3);
    }

    private void createDynamicProperties() {
        PropertyMaker m3 = new ToBeImplementedProperty.Maker(2);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("active-state", m3);
        m3 = new ToBeImplementedProperty.Maker(5);
        m3.setInherited(true);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("auto-restore", m3);
        m3 = new ToBeImplementedProperty.Maker(61);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-name", m3);
        m3 = new ToBeImplementedProperty.Maker(62);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-title", m3);
        m3 = new ToBeImplementedProperty.Maker(79);
        m3.setInherited(false);
        m3.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("destination-placement-offset", m3);
        m3 = new StringProperty.Maker(88);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("external-destination", m3);
        m3 = new ToBeImplementedProperty.Maker(114);
        m3.setInherited(false);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("indicate-destination", m3);
        m3 = new StringProperty.Maker(117);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("internal-destination", m3);
        m3 = new ToBeImplementedProperty.Maker(197);
        m3.setInherited(false);
        m3.setDefault("replace");
        FOPropertyMapping.addPropertyMaker("show-destination", m3);
        m3 = new EnumProperty.Maker(212);
        m3.setInherited(false);
        m3.addEnum("show", this.getEnumProperty(130, "SHOW"));
        m3.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        m3.setDefault("show");
        FOPropertyMapping.addPropertyMaker("starting-state", m3);
        m3 = new ToBeImplementedProperty.Maker(216);
        m3.setInherited(false);
        m3.setDefault("xsl-any");
        FOPropertyMapping.addPropertyMaker("switch-to", m3);
        m3 = new ToBeImplementedProperty.Maker(220);
        m3.setInherited(false);
        m3.setDefault("use-target-processing-context");
        FOPropertyMapping.addPropertyMaker("target-presentation-context", m3);
        m3 = new ToBeImplementedProperty.Maker(221);
        m3.setInherited(false);
        m3.setDefault("document-root");
        FOPropertyMapping.addPropertyMaker("target-processing-context", m3);
        m3 = new ToBeImplementedProperty.Maker(222);
        m3.setInherited(false);
        m3.setDefault("use-normal-stylesheet");
        FOPropertyMapping.addPropertyMaker("target-stylesheet", m3);
    }

    private void createMarkersProperties() {
        PropertyMaker m3 = new StringProperty.Maker(139);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("marker-class-name", m3);
        m3 = new StringProperty.Maker(186);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("retrieve-class-name", m3);
        m3 = new EnumProperty.Maker(187);
        m3.setInherited(false);
        m3.addEnum("first-starting-within-page", this.getEnumProperty(54, "FSWP"));
        m3.addEnum("first-including-carryover", this.getEnumProperty(49, "FIC"));
        m3.addEnum("last-starting-within-page", this.getEnumProperty(81, "LSWP"));
        m3.addEnum("last-ending-within-page", this.getEnumProperty(74, "LEWP"));
        m3.setDefault("first-starting-within-page");
        FOPropertyMapping.addPropertyMaker("retrieve-position", m3);
        m3 = new EnumProperty.Maker(185);
        m3.setInherited(false);
        m3.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m3.addEnum("page-sequence", this.getEnumProperty(105, "PAGE_SEQUENCE"));
        m3.addEnum("document", this.getEnumProperty(34, "DOCUMENT"));
        m3.setDefault("page-sequence");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary", m3);
    }

    private void createNumberToStringProperties() {
        PropertyMaker m3 = new StringProperty.Maker(101);
        m3.setInherited(false);
        m3.setDefault("1");
        FOPropertyMapping.addPropertyMaker("format", m3);
        m3 = new CharacterProperty.Maker(104);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("grouping-separator", m3);
        m3 = new NumberProperty.Maker(105);
        m3.setInherited(false);
        m3.setDefault("0");
        FOPropertyMapping.addPropertyMaker("grouping-size", m3);
        m3 = new EnumProperty.Maker(129);
        m3.setInherited(false);
        m3.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m3.addEnum("traditional", this.getEnumProperty(146, "TRADITIONAL"));
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("letter-value", m3);
    }

    private void createPaginationAndLayoutProperties() {
        PropertyMaker m3 = new EnumProperty.Maker(16);
        m3.setInherited(false);
        m3.addEnum("blank", this.getEnumProperty(16, "BLANK"));
        m3.addEnum("not-blank", this.getEnumProperty(98, "NOT_BLANK"));
        m3.addEnum("any", this.getEnumProperty(8, "ANY"));
        m3.setDefault("any");
        FOPropertyMapping.addPropertyMaker("blank-or-not-blank", m3);
        m3 = new NumberProperty.Maker(68);
        m3.setInherited(false);
        m3.setDefault("1");
        FOPropertyMapping.addPropertyMaker("column-count", m3);
        LengthProperty.Maker l = new LengthProperty.Maker(69);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("0.25in");
        FOPropertyMapping.addPropertyMaker("column-gap", l);
        m3 = new LengthProperty.Maker(87);
        m3.setInherited(true);
        m3.setDefault("0pt");
        m3.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("extent", m3);
        m3 = new StringProperty.Maker(90);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("flow-name", m3);
        m3 = new EnumProperty.Maker(100);
        m3.setInherited(false);
        m3.addEnum("even", this.getEnumProperty(43, "EVEN"));
        m3.addEnum("odd", this.getEnumProperty(99, "ODD"));
        m3.addEnum("end-on-even", this.getEnumProperty(40, "END_ON_EVEN"));
        m3.addEnum("end-on-odd", this.getEnumProperty(41, "END_ON_ODD"));
        m3.addEnum("no-force", this.getEnumProperty(88, "NO_FORCE"));
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("force-page-count", m3);
        m3 = new NumberProperty.Maker(115);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("auto-odd", this.getEnumProperty(11, "AUTO_ODD"));
        m3.addEnum("auto-even", this.getEnumProperty(10, "AUTO_EVEN"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("initial-page-number", m3);
        m3 = new StringProperty.Maker(140);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-name", m3);
        m3 = new StringProperty.Maker(141);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-reference", m3);
        m3 = new NumberProperty.Maker(143);
        m3.setInherited(false);
        m3.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        m3.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("maximum-repeats", m3);
        m3 = new EnumProperty.Maker(145);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("paginate", this.getEnumProperty(106, "PAGINATE"));
        m3.addEnum("bounded-in-one-dimension", this.getEnumProperty(21, "BOUNDED_IN_ONE_DIMENSION"));
        m3.addEnum("unbounded", this.getEnumProperty(152, "UNBOUNDED"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("media-usage", m3);
        m3 = new EnumProperty.Maker(151);
        m3.setInherited(false);
        m3.addEnum("odd", this.getEnumProperty(99, "ODD"));
        m3.addEnum("even", this.getEnumProperty(43, "EVEN"));
        m3.addEnum("any", this.getEnumProperty(8, "ANY"));
        m3.setDefault("any");
        FOPropertyMapping.addPropertyMaker("odd-or-even", m3);
        l = new PageDimensionMaker(166);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-height", l);
        m3 = new EnumProperty.Maker(167);
        m3.setInherited(false);
        m3.addEnum("first", this.getEnumProperty(50, "FIRST"));
        m3.addEnum("last", this.getEnumProperty(72, "LAST"));
        m3.addEnum("rest", this.getEnumProperty(117, "REST"));
        m3.addEnum("any", this.getEnumProperty(8, "ANY"));
        m3.addEnum("only", this.getEnumProperty(186, "ONLY"));
        m3.setDefault("any");
        FOPropertyMapping.addPropertyMaker("page-position", m3);
        l = new PageDimensionMaker(168);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-width", l);
        m3 = new EnumProperty.Maker(176);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(false);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("precedence", m3);
        m3 = new StringProperty.Maker(181);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("region-name", m3);
    }

    private void createTableProperties() {
        PropertyMaker m3 = new TableBorderPrecedence(20);
        m3.setInherited(false);
        m3.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-after-precedence", m3);
        m3 = new TableBorderPrecedence(24);
        m3.setInherited(false);
        m3.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-before-precedence", m3);
        m3 = new EnumProperty.Maker(31);
        m3.setInherited(true);
        m3.setDefault("collapse");
        m3.addEnum("separate", this.getEnumProperty(129, "SEPARATE"));
        m3.addEnum("collapse-with-precedence", this.getEnumProperty(27, "COLLAPSE_WITH_PRECEDENCE"));
        m3.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        FOPropertyMapping.addPropertyMaker("border-collapse", m3);
        m3 = new TableBorderPrecedence(34);
        m3.setInherited(false);
        m3.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-end-precedence", m3);
        m3 = new LengthPairProperty.Maker(45);
        m3.setInherited(true);
        m3.addShorthand(s_generics[46]);
        LengthProperty.Maker sub = new LengthProperty.Maker(512);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        m3.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(1536);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        m3.addSubpropMaker(sub);
        FOPropertyMapping.addPropertyMaker("border-separation", m3);
        m3 = new TableBorderPrecedence(48);
        m3.setInherited(false);
        m3.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-start-precedence", m3);
        m3 = new EnumProperty.Maker(60);
        m3.setInherited(true);
        m3.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m3.addEnum("after", this.getEnumProperty(3, "AFTER"));
        m3.addEnum("start", this.getEnumProperty(135, "START"));
        m3.addEnum("end", this.getEnumProperty(39, "END"));
        m3.addEnum("top", this.getEnumProperty(145, "TOP"));
        m3.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        m3.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m3.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m3.setDefault("before");
        FOPropertyMapping.addPropertyMaker("caption-side", m3);
        m3 = new TableFObj.ColumnNumberPropertyMaker(70);
        m3.setInherited(false);
        FOPropertyMapping.addPropertyMaker("column-number", m3);
        m3 = new LengthProperty.Maker(71);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.setDefault("auto");
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("column-width", m3);
        m3 = new EnumProperty.Maker(84);
        m3.setInherited(true);
        m3.addEnum("show", this.getEnumProperty(130, "SHOW"));
        m3.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        m3.setDefault("show");
        FOPropertyMapping.addPropertyMaker("empty-cells", m3);
        m3 = new EnumProperty.Maker(86);
        m3.setInherited(false);
        m3.useGeneric(this.genericBoolean);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("ends-row", m3);
        m3 = new NumberProperty.Maker(148);
        m3.setInherited(false);
        m3.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-repeated", m3);
        m3 = new NumberProperty.Maker(149);
        m3.setInherited(false);
        m3.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-spanned", m3);
        m3 = new NumberProperty.Maker(150);
        m3.setInherited(false);
        m3.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-rows-spanned", m3);
        m3 = new EnumProperty.Maker(213);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(false);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("starts-row", m3);
        m3 = new EnumProperty.Maker(217);
        m3.setInherited(false);
        m3.setDefault("auto");
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        FOPropertyMapping.addPropertyMaker("table-layout", m3);
        m3 = new EnumProperty.Maker(218);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(false);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-footer-at-break", m3);
        m3 = new EnumProperty.Maker(219);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(false);
        m3.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-header-at-break", m3);
    }

    private void createWritingModeProperties() {
        PropertyMaker m3 = new EnumProperty.Maker(80);
        m3.setInherited(true);
        m3.addEnum("ltr", this.getEnumProperty(80, "LTR"));
        m3.addEnum("rtl", this.getEnumProperty(122, "RTL"));
        m3.setDefault("ltr");
        FOPropertyMapping.addPropertyMaker("direction", m3);
        m3 = new ToBeImplementedProperty.Maker(102);
        m3.setInherited(true);
        m3.setDefault("0deg");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-horizontal", m3);
        m3 = new ToBeImplementedProperty.Maker(103);
        m3.setInherited(true);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-vertical", m3);
        m3 = new LengthProperty.Maker(225);
        m3.setInherited(false);
        m3.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        m3.setDefault("use-font-metrics");
        m3.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-altitude", m3);
        m3 = new LengthProperty.Maker(227);
        m3.setInherited(false);
        m3.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        m3.setDefault("use-font-metrics");
        m3.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-depth", m3);
        m3 = new EnumProperty.Maker(233);
        m3.setInherited(false);
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m3.addEnum("embed", this.getEnumProperty(38, "EMBED"));
        m3.addEnum("bidi-override", this.getEnumProperty(15, "BIDI_OVERRIDE"));
        m3.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("unicode-bidi", m3);
        m3 = new EnumProperty.Maker(245);
        m3.setInherited(true);
        m3.setDefault("lr-tb");
        m3.addEnum("lr-tb", this.getEnumProperty(79, "LR_TB"));
        m3.addEnum("rl-tb", this.getEnumProperty(121, "RL_TB"));
        m3.addEnum("tb-rl", this.getEnumProperty(140, "TB_RL"));
        m3.addKeyword("lr", "lr-tb");
        m3.addKeyword("rl", "rl-tb");
        m3.addKeyword("tb", "tb-rl");
        FOPropertyMapping.addPropertyMaker("writing-mode", m3);
    }

    private void createMiscProperties() {
        PropertyMaker m3 = new StringProperty.Maker(73);
        m3.setInherited(false);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("content-type", m3);
        m3 = new StringProperty.Maker(113);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("id", m3);
        m3 = new LengthProperty.Maker(178);
        m3.setInherited(true);
        m3.setDefault("6pt");
        FOPropertyMapping.addPropertyMaker("provisional-label-separation", m3);
        m3 = new LengthProperty.Maker(177);
        m3.setInherited(true);
        m3.setDefault("24pt");
        FOPropertyMapping.addPropertyMaker("provisional-distance-between-starts", m3);
        m3 = new StringProperty.Maker(180);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("ref-id", m3);
        m3 = new EnumProperty.Maker(195);
        m3.useGeneric(this.genericBoolean);
        m3.setInherited(true);
        m3.setDefault("true");
        FOPropertyMapping.addPropertyMaker("score-spaces", m3);
        m3 = new StringProperty.Maker(210);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("src", m3);
        m3 = new EnumProperty.Maker(235);
        m3.setInherited(false);
        m3.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        m3.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        m3.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        m3.setDefault("visible");
        FOPropertyMapping.addPropertyMaker("visibility", m3);
        m3 = new NumberProperty.Maker(247);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("z-index", m3);
    }

    private void createShorthandProperties() {
        PropertyMaker m3 = new ToBeImplementedProperty.Maker(7);
        m3.setInherited(false);
        m3.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background", m3);
        m3 = new BackgroundPositionShorthand.Maker(11);
        m3.setInherited(false);
        m3.addKeyword("left", "0% 50%");
        m3.addKeyword("left center", "0% 50%");
        m3.addKeyword("center left", "0% 50%");
        m3.addKeyword("right", "100% 50%");
        m3.addKeyword("right center", "100% 50%");
        m3.addKeyword("center right", "100% 50%");
        m3.addKeyword("center", "50% 50%");
        m3.addKeyword("center center", "50% 50%");
        m3.addKeyword("top", "50% 0%");
        m3.addKeyword("top center", "50% 0%");
        m3.addKeyword("center top", "50% 0%");
        m3.addKeyword("bottom", "50% 100%");
        m3.addKeyword("bottom center", "50% 100%");
        m3.addKeyword("center bottom", "50% 100%");
        m3.addKeyword("top left", "0% 0%");
        m3.addKeyword("left top", "0% 0%");
        m3.addKeyword("top right", "100% 0%");
        m3.addKeyword("right top", "100% 0%");
        m3.addKeyword("bottom left", "0% 100%");
        m3.addKeyword("left bottom", "0% 100%");
        m3.addKeyword("bottom right", "100% 100%");
        m3.addKeyword("right bottom", "100% 100%");
        m3.setDefault("0% 0%");
        m3.setPercentBase(0);
        m3.setDatatypeParser(new BackgroundPositionShorthand.Parser());
        FOPropertyMapping.addPropertyMaker("background-position", m3);
        m3 = new ListProperty.Maker(18);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border", m3);
        m3 = new ListProperty.Maker(27);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-bottom", m3);
        m3 = new ListProperty.Maker(32);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-color", m3);
        m3 = new ListProperty.Maker(37);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-left", m3);
        m3 = new ListProperty.Maker(41);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-right", m3);
        m3 = new ListProperty.Maker(51);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-style", m3);
        m3 = new ListProperty.Maker(46);
        m3.setInherited(true);
        m3.setDefault("0pt");
        m3.setDatatypeParser(new BorderSpacingShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-spacing", m3);
        m3 = new ListProperty.Maker(52);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-top", m3);
        m3 = new ListProperty.Maker(56);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-width", m3);
        m3 = new ToBeImplementedProperty.Maker(76);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("cue", m3);
        m3 = new FontShorthandProperty.Maker(91);
        m3.setInherited(true);
        m3.addEnum("caption", this.getEnumProperty(180, "CAPTION"));
        m3.addEnum("icon", this.getEnumProperty(181, "ICON"));
        m3.addEnum("message-box", this.getEnumProperty(183, "MESSAGE_BOX"));
        m3.addEnum("menu", this.getEnumProperty(182, "MENU"));
        m3.addEnum("small-caption", this.getEnumProperty(184, "SMALL_CAPTION"));
        m3.addEnum("status-bar", this.getEnumProperty(185, "STATUS_BAR"));
        m3.setDefault("");
        m3.setDatatypeParser(new FontShorthandParser());
        FOPropertyMapping.addPropertyMaker("font", m3);
        m3 = new ListProperty.Maker(134);
        m3.setInherited(false);
        m3.setDefault("");
        m3.setDatatypeParser(new BoxPropShorthandParser());
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin", m3);
        m3 = new ListProperty.Maker(154);
        m3.setInherited(false);
        m3.setDatatypeParser(new BoxPropShorthandParser());
        m3.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("padding", m3);
        m3 = new EnumProperty.Maker(163);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        m3.addEnum("avoid", this.getEnumProperty(178, "AVOID"));
        m3.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m3.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m3.setDefault("auto");
        m3.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-after", m3);
        m3 = new EnumProperty.Maker(164);
        m3.setInherited(false);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        m3.addEnum("avoid", this.getEnumProperty(178, "AVOID"));
        m3.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m3.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m3.setDefault("auto");
        m3.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-before", m3);
        m3 = new EnumProperty.Maker(165);
        m3.setInherited(true);
        m3.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m3.addEnum("avoid", this.getEnumProperty(178, "AVOID"));
        m3.setDefault("auto");
        m3.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-inside", m3);
        m3 = new ToBeImplementedProperty.Maker(169);
        m3.setInherited(false);
        m3.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause", m3);
        m3 = new EnumProperty.Maker(175);
        m3.setInherited(false);
        m3.addEnum("static", this.getEnumProperty(136, "STATIC"));
        m3.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        m3.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        m3.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        m3.setDefault("static");
        m3.setDatatypeParser(new PositionShorthandParser());
        FOPropertyMapping.addPropertyMaker("position", m3);
        m3 = new ToBeImplementedProperty.Maker(198);
        m3.setInherited(false);
        m3.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("size", m3);
        m3 = new LengthProperty.Maker(234);
        m3.setInherited(false);
        m3.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m3.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m3.addEnum("sub", this.getEnumProperty(137, "SUB"));
        m3.addEnum("super", this.getEnumProperty(138, "SUPER"));
        m3.addEnum("text-top", this.getEnumProperty(144, "TEXT_TOP"));
        m3.addEnum("text-bottom", this.getEnumProperty(143, "TEXT_BOTTOM"));
        m3.addEnum("top", this.getEnumProperty(145, "TOP"));
        m3.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        m3.setDatatypeParser(new VerticalAlignShorthandParser());
        m3.setDefault("baseline");
        m3.setPercentBase(12);
        FOPropertyMapping.addPropertyMaker("vertical-align", m3);
        m3 = new EnumProperty.Maker(238);
        m3.setInherited(true);
        m3.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m3.addEnum("pre", this.getEnumProperty(179, "PRE"));
        m3.addEnum("nowrap", this.getEnumProperty(93, "NO_WRAP"));
        m3.setDefault("normal");
        m3.setDatatypeParser(new WhiteSpaceShorthandParser());
        FOPropertyMapping.addPropertyMaker("white-space", m3);
        m3 = new StringProperty.Maker(246);
        m3.setInherited(true);
        m3.setDefault("");
        m3.setDatatypeParser(new XMLLangShorthandParser());
        FOPropertyMapping.addPropertyMaker("xml:lang", m3);
    }
}

