/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;

public class CommonBorderPaddingBackground {
    public int backgroundAttachment;
    public Color backgroundColor;
    public String backgroundImage;
    public int backgroundRepeat;
    public Length backgroundPositionHorizontal;
    public Length backgroundPositionVertical;
    private ImageInfo backgroundImageInfo;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int START = 2;
    public static final int END = 3;
    private static BorderInfo defaultBorderInfo;
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private CondLengthProperty[] padding = new CondLengthProperty[4];

    public static synchronized BorderInfo getDefaultBorderInfo() {
        if (defaultBorderInfo == null) {
            defaultBorderInfo = new BorderInfo(95, new ConditionalNullLength(), null);
        }
        return defaultBorderInfo;
    }

    public CommonBorderPaddingBackground() {
    }

    public CommonBorderPaddingBackground(PropertyList pList) throws PropertyException {
        this.backgroundAttachment = pList.get(8).getEnum();
        this.backgroundColor = pList.get(9).getColor(pList.getFObj().getUserAgent());
        if (this.backgroundColor.getAlpha() == 0) {
            this.backgroundColor = null;
        }
        this.backgroundImage = pList.get(10).getString();
        if (this.backgroundImage == null || "none".equals(this.backgroundImage)) {
            this.backgroundImage = null;
        } else {
            this.backgroundRepeat = pList.get(14).getEnum();
            this.backgroundPositionHorizontal = pList.get(12).getLength();
            this.backgroundPositionVertical = pList.get(13).getLength();
            String uri = URISpecification.getURL(this.backgroundImage);
            FOUserAgent userAgent = pList.getFObj().getUserAgent();
            ImageManager manager = userAgent.getFactory().getImageManager();
            ImageSessionContext sessionContext = userAgent.getImageSessionContext();
            try {
                ImageInfo info;
                this.backgroundImageInfo = info = manager.getImageInfo(uri, sessionContext);
            }
            catch (Exception e) {
                Property.log.error("Background image not available: " + uri);
            }
        }
        this.initBorderInfo(pList, 0, 23, 25, 26, 156);
        this.initBorderInfo(pList, 1, 19, 21, 22, 155);
        this.initBorderInfo(pList, 2, 47, 49, 50, 161);
        this.initBorderInfo(pList, 3, 33, 35, 36, 158);
    }

    private void initBorderInfo(PropertyList pList, int side, int colorProp, int styleProp, int widthProp, int paddingProp) throws PropertyException {
        this.padding[side] = pList.get(paddingProp).getCondLength();
        int style = pList.get(styleProp).getEnum();
        if (style != 95) {
            FOUserAgent ua = pList.getFObj().getUserAgent();
            this.setBorderInfo(new BorderInfo(style, pList.get(widthProp).getCondLength(), pList.get(colorProp).getColor(ua)), side);
        }
    }

    public void setBorderInfo(BorderInfo info, int side) {
        this.borderInfo[side] = info;
    }

    public BorderInfo getBorderInfo(int side) {
        if (this.borderInfo[side] == null) {
            return CommonBorderPaddingBackground.getDefaultBorderInfo();
        }
        return this.borderInfo[side];
    }

    public void setPadding(CommonBorderPaddingBackground source) {
        this.padding = source.padding;
    }

    public ImageInfo getImageInfo() {
        return this.backgroundImageInfo;
    }

    public int getBorderStartWidth(boolean bDiscard) {
        return this.getBorderWidth(2, bDiscard);
    }

    public int getBorderEndWidth(boolean bDiscard) {
        return this.getBorderWidth(3, bDiscard);
    }

    public int getBorderBeforeWidth(boolean bDiscard) {
        return this.getBorderWidth(0, bDiscard);
    }

    public int getBorderAfterWidth(boolean bDiscard) {
        return this.getBorderWidth(1, bDiscard);
    }

    public int getPaddingStart(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(2, bDiscard, context);
    }

    public int getPaddingEnd(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(3, bDiscard, context);
    }

    public int getPaddingBefore(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(0, bDiscard, context);
    }

    public int getPaddingAfter(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(1, bDiscard, context);
    }

    public int getBorderWidth(int side, boolean bDiscard) {
        if (this.borderInfo[side] == null || this.borderInfo[side].mStyle == 95 || this.borderInfo[side].mStyle == 57 || bDiscard && this.borderInfo[side].mWidth.isDiscard()) {
            return 0;
        }
        return this.borderInfo[side].mWidth.getLengthValue();
    }

    public Color getBorderColor(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].getColor();
        }
        return null;
    }

    public int getBorderStyle(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mStyle;
        }
        return 95;
    }

    public int getPadding(int side, boolean bDiscard, PercentBaseContext context) {
        if (this.padding[side] == null || bDiscard && this.padding[side].isDiscard()) {
            return 0;
        }
        return this.padding[side].getLengthValue(context);
    }

    public CondLengthProperty getPaddingLengthProperty(int side) {
        return this.padding[side];
    }

    public int getIPPaddingAndBorder(boolean bDiscard, PercentBaseContext context) {
        return this.getPaddingStart(bDiscard, context) + this.getPaddingEnd(bDiscard, context) + this.getBorderStartWidth(bDiscard) + this.getBorderEndWidth(bDiscard);
    }

    public int getBPPaddingAndBorder(boolean bDiscard, PercentBaseContext context) {
        return this.getPaddingBefore(bDiscard, context) + this.getPaddingAfter(bDiscard, context) + this.getBorderBeforeWidth(bDiscard) + this.getBorderAfterWidth(bDiscard);
    }

    public String toString() {
        return "CommonBordersAndPadding (Before, After, Start, End):\nBorders: (" + this.getBorderBeforeWidth(false) + ", " + this.getBorderAfterWidth(false) + ", " + this.getBorderStartWidth(false) + ", " + this.getBorderEndWidth(false) + ")\n" + "Border Colors: (" + this.getBorderColor(0) + ", " + this.getBorderColor(1) + ", " + this.getBorderColor(2) + ", " + this.getBorderColor(3) + ")\n" + "Padding: (" + this.getPaddingBefore(false, null) + ", " + this.getPaddingAfter(false, null) + ", " + this.getPaddingStart(false, null) + ", " + this.getPaddingEnd(false, null) + ")\n";
    }

    public boolean hasBackground() {
        return this.backgroundColor != null || this.getImageInfo() != null;
    }

    public boolean hasBorder() {
        return this.getBorderBeforeWidth(false) + this.getBorderAfterWidth(false) + this.getBorderStartWidth(false) + this.getBorderEndWidth(false) > 0;
    }

    public boolean hasPadding(PercentBaseContext context) {
        return this.getPaddingBefore(false, context) + this.getPaddingAfter(false, context) + this.getPaddingStart(false, context) + this.getPaddingEnd(false, context) > 0;
    }

    public boolean hasBorderInfo() {
        return this.borderInfo[0] != null || this.borderInfo[1] != null || this.borderInfo[2] != null || this.borderInfo[3] != null;
    }

    private static class ConditionalNullLength
    extends CondLengthProperty {
        private ConditionalNullLength() {
        }

        public Property getComponent(int cmpId) {
            throw new UnsupportedOperationException();
        }

        public Property getConditionality() {
            throw new UnsupportedOperationException();
        }

        public Length getLength() {
            throw new UnsupportedOperationException();
        }

        public Property getLengthComponent() {
            throw new UnsupportedOperationException();
        }

        public int getLengthValue() {
            return 0;
        }

        public int getLengthValue(PercentBaseContext context) {
            return 0;
        }

        public boolean isDiscard() {
            return true;
        }

        public void setComponent(int cmpId, Property cmpnValue, boolean isDefault) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CondLength[0mpt, discard]";
        }
    }

    public static class BorderInfo {
        private int mStyle;
        private Color mColor;
        private CondLengthProperty mWidth;

        BorderInfo(int style, CondLengthProperty width, Color color) {
            this.mStyle = style;
            this.mWidth = width;
            this.mColor = color;
        }

        public int getStyle() {
            return this.mStyle;
        }

        public Color getColor() {
            return this.mColor;
        }

        public CondLengthProperty getWidth() {
            return this.mWidth;
        }

        public int getRetainedWidth() {
            if (this.mStyle == 95 || this.mStyle == 57) {
                return 0;
            }
            return this.mWidth.getLengthValue();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("BorderInfo");
            sb.append(" {");
            sb.append(this.mStyle);
            sb.append(", ");
            sb.append(this.mColor);
            sb.append(", ");
            sb.append(this.mWidth);
            sb.append("}");
            return sb.toString();
        }
    }
}

