/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.awt.geom.RectangularShape;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMFile;
import org.apache.fop.fonts.type1.AFMParser;
import org.apache.fop.fonts.type1.PFMFile;

public class Type1FontLoader
extends FontLoader {
    private SingleByteFont singleFont;
    private static final String[] AFM_EXTENSIONS = new String[]{".AFM", ".afm", ".Afm"};

    public Type1FontLoader(String fontFileURI, FontResolver resolver) throws IOException {
        super(fontFileURI, resolver);
    }

    private String getPFMURI(String pfbURI) {
        String pfbExt = pfbURI.substring(pfbURI.length() - 3, pfbURI.length());
        String pfmExt = pfbExt.substring(0, 2) + (Character.isUpperCase(pfbExt.charAt(2)) ? "M" : "m");
        return pfbURI.substring(0, pfbURI.length() - 4) + "." + pfmExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read() throws IOException {
        AFMFile afm = null;
        PFMFile pfm = null;
        InputStream afmIn = null;
        for (int i = 0; i < AFM_EXTENSIONS.length; ++i) {
            try {
                String afmUri = this.fontFileURI.substring(0, this.fontFileURI.length() - 4) + AFM_EXTENSIONS[i];
                afmIn = Type1FontLoader.openFontUri(this.resolver, afmUri);
                if (afmIn == null) continue;
                break;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (afmIn != null) {
            try {
                AFMParser afmParser = new AFMParser();
                afm = afmParser.parse(afmIn);
            }
            finally {
                IOUtils.closeQuietly(afmIn);
            }
        }
        String pfmUri = this.getPFMURI(this.fontFileURI);
        InputStream pfmIn = null;
        try {
            pfmIn = Type1FontLoader.openFontUri(this.resolver, pfmUri);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (pfmIn != null) {
            try {
                pfm = new PFMFile();
                pfm.load(pfmIn);
            }
            finally {
                IOUtils.closeQuietly(pfmIn);
            }
        }
        if (afm == null && pfm == null) {
            throw new FileNotFoundException("Neither an AFM nor a PFM file was found for " + this.fontFileURI);
        }
        if (pfm == null) {
            throw new FileNotFoundException("No PFM file was found for " + this.fontFileURI);
        }
        this.buildFont(afm, pfm);
        this.loaded = true;
    }

    private void buildFont(AFMFile afm, PFMFile pfm) {
        RectangularShape rect;
        AFMCharMetrics chm;
        if (afm == null && pfm == null) {
            throw new IllegalArgumentException("Need at least an AFM or a PFM!");
        }
        this.singleFont = new SingleByteFont();
        this.singleFont.setFontType(FontType.TYPE1);
        this.singleFont.setResolver(this.resolver);
        this.singleFont.setEmbedFileName(this.fontFileURI);
        this.returnFont = this.singleFont;
        if (afm != null) {
            String encoding = afm.getEncodingScheme();
            if ("AdobeStandardEncoding".equals(encoding)) {
                this.singleFont.setEncoding("WinAnsiEncoding");
            } else {
                String effEncodingName = "FontSpecific".equals(encoding) ? afm.getFontName() + "Encoding" : encoding;
                if (log.isDebugEnabled()) {
                    log.debug("Unusual font encoding encountered: " + encoding + " -> " + effEncodingName);
                }
                CodePointMapping mapping = this.buildCustomEncoding(effEncodingName, afm);
                this.singleFont.setEncoding(mapping);
            }
        } else if (pfm.getCharSet() >= 0 && pfm.getCharSet() <= 2) {
            this.singleFont.setEncoding(pfm.getCharSetName() + "Encoding");
        } else {
            log.warn("The PFM reports an unsupported encoding (" + pfm.getCharSetName() + "). The font may not work as expected.");
            this.singleFont.setEncoding("WinAnsiEncoding");
        }
        if (afm != null) {
            this.returnFont.setFontName(afm.getFontName());
            this.returnFont.setFullName(afm.getFullName());
            HashSet<String> names = new HashSet<String>();
            names.add(afm.getFamilyName());
            this.returnFont.setFamilyNames(names);
        } else {
            this.returnFont.setFontName(pfm.getPostscriptName());
            String fullName = pfm.getPostscriptName();
            fullName = fullName.replace('-', ' ');
            this.returnFont.setFullName(fullName);
            HashSet<String> names = new HashSet<String>();
            names.add(pfm.getWindowsName());
            this.returnFont.setFamilyNames(names);
        }
        if (afm != null) {
            if (afm.getCapHeight() != null) {
                this.returnFont.setCapHeight(afm.getCapHeight().intValue());
            }
            if (afm.getXHeight() != null) {
                this.returnFont.setXHeight(afm.getXHeight().intValue());
            }
            if (afm.getAscender() != null) {
                this.returnFont.setAscender(afm.getAscender().intValue());
            }
            if (afm.getDescender() != null) {
                this.returnFont.setDescender(afm.getDescender().intValue());
            }
            this.returnFont.setFontBBox(afm.getFontBBoxAsIntArray());
            if (afm.getStdVW() != null) {
                this.returnFont.setStemV(afm.getStdVW().intValue());
            } else {
                this.returnFont.setStemV(80);
            }
            this.returnFont.setItalicAngle((int)afm.getWritingDirectionMetrics(0).getItalicAngle());
        } else {
            this.returnFont.setFontBBox(pfm.getFontBBox());
            this.returnFont.setStemV(pfm.getStemV());
            this.returnFont.setItalicAngle(pfm.getItalicAngle());
        }
        if (pfm != null) {
            if (this.returnFont.getCapHeight() == 0) {
                this.returnFont.setCapHeight(pfm.getCapHeight());
            }
            if (this.returnFont.getXHeight(1) == 0) {
                this.returnFont.setXHeight(pfm.getXHeight());
            }
            if (this.returnFont.getAscender() == 0) {
                this.returnFont.setAscender(pfm.getLowerCaseAscent());
            }
            if (this.returnFont.getDescender() == 0) {
                this.returnFont.setDescender(pfm.getLowerCaseDescent());
            }
        }
        if (this.returnFont.getXHeight(1) == 0) {
            int xHeight = 0;
            if (afm != null && (chm = afm.getChar("x")) != null && (rect = chm.getBBox()) != null) {
                xHeight = (int)Math.round(rect.getMinX());
            }
            if (xHeight == 0) {
                xHeight = Math.round((float)this.returnFont.getFontBBox()[3] * 0.6f);
            }
            this.returnFont.setXHeight(xHeight);
        }
        if (this.returnFont.getAscender() == 0) {
            int asc = 0;
            if (afm != null && (chm = afm.getChar("d")) != null && (rect = chm.getBBox()) != null) {
                asc = (int)Math.round(rect.getMinX());
            }
            if (asc == 0) {
                asc = Math.round((float)this.returnFont.getFontBBox()[3] * 0.9f);
            }
            this.returnFont.setAscender(asc);
        }
        if (this.returnFont.getDescender() == 0) {
            int desc = 0;
            if (afm != null && (chm = afm.getChar("p")) != null && (rect = chm.getBBox()) != null) {
                desc = (int)Math.round(rect.getMinX());
            }
            if (desc == 0) {
                desc = this.returnFont.getFontBBox()[1];
            }
            this.returnFont.setDescender(desc);
        }
        if (this.returnFont.getCapHeight() == 0) {
            this.returnFont.setCapHeight(this.returnFont.getAscender());
        }
        this.returnFont.setFlags(pfm.getFlags());
        this.returnFont.setFirstChar(pfm.getFirstChar());
        this.returnFont.setLastChar(pfm.getLastChar());
        for (short i = pfm.getFirstChar(); i <= pfm.getLastChar(); i = (short)(i + 1)) {
            this.singleFont.setWidth(i, pfm.getCharWidth(i));
        }
        this.returnFont.replaceKerningMap(pfm.getKerning());
    }

    private CodePointMapping buildCustomEncoding(String encodingName, AFMFile afm) {
        List chars = afm.getCharMetrics();
        int mappingCount = 0;
        Iterator iter = chars.iterator();
        while (iter.hasNext()) {
            String u;
            AFMCharMetrics charMetrics = (AFMCharMetrics)iter.next();
            if (charMetrics.getCharCode() < 0 || (u = charMetrics.getUnicodeSequence()) == null || u.length() != 1) continue;
            ++mappingCount;
        }
        int[] table = new int[mappingCount * 2];
        String[] charNameMap = new String[256];
        iter = chars.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            AFMCharMetrics charMetrics = (AFMCharMetrics)iter.next();
            if (charMetrics.getCharCode() < 0) continue;
            charNameMap[charMetrics.getCharCode()] = charMetrics.getCharName();
            String unicodes = charMetrics.getUnicodeSequence();
            if (unicodes == null) {
                log.info("No Unicode mapping for glyph: " + charMetrics);
                continue;
            }
            if (unicodes.length() == 1) {
                table[idx] = charMetrics.getCharCode();
                table[++idx] = unicodes.charAt(0);
                ++idx;
                continue;
            }
            log.warn("Multi-character representation of glyph not currently supported: " + charMetrics);
        }
        return new CodePointMapping(encodingName, table, charNameMap);
    }
}

