/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;

public class PDFStream
extends AbstractPDFStream {
    protected StreamCache data;

    public PDFStream() {
        try {
            this.data = StreamCacheFactory.getInstance().createStreamCache();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void add(String s2) {
        try {
            this.data.getOutputStream().write(PDFDocument.encode(s2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public OutputStream getBufferOutputStream() throws IOException {
        return this.data.getOutputStream();
    }

    public void setData(byte[] data) throws IOException {
        this.data.clear();
        this.data.write(data);
    }

    public int getDataLength() {
        try {
            return this.data.getSize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int getSizeHint() throws IOException {
        return this.data.getSize();
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.data.outputContents(out);
    }

    protected int output(OutputStream stream) throws IOException {
        int len = super.output(stream);
        this.data = null;
        return len;
    }
}

