/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.fonts.AFPFontReader;
import org.apache.fop.render.afp.fonts.CharacterSetOrientation;
import org.apache.fop.render.afp.tools.StringUtils;

public class CharacterSet {
    protected static final Log log = LogFactory.getLog(CharacterSet.class.getName());
    protected String codePage;
    protected String encoding;
    protected String name;
    private byte[] nameBytes;
    protected String path;
    private boolean isMetricsLoaded = false;
    private String currentOrientation = "0";
    private Map characterSetOrientations = null;

    public CharacterSet(String codePage, String encoding, String name, String path) {
        if (name.length() > 8) {
            String msg = "Character set name must be a maximum of 8 characters " + name;
            log.error("Constructor:: " + msg);
            throw new IllegalArgumentException(msg);
        }
        this.name = name.length() < 8 ? StringUtils.rpad(name, ' ', 8) : name;
        try {
            this.nameBytes = name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            this.nameBytes = name.getBytes();
            log.warn("Constructor:: UnsupportedEncodingException translating the name " + name);
        }
        this.codePage = codePage;
        this.encoding = encoding;
        this.path = path;
        this.characterSetOrientations = new HashMap(4);
    }

    public void addCharacterSetOrientation(CharacterSetOrientation cso) {
        this.characterSetOrientations.put(String.valueOf(cso.getOrientation()), cso);
    }

    public int getAscender() {
        this.load();
        return this.getCharacterSetOrientation().getAscender();
    }

    public int getCapHeight() {
        this.load();
        return this.getCharacterSetOrientation().getCapHeight();
    }

    public int getDescender() {
        this.load();
        return this.getCharacterSetOrientation().getDescender();
    }

    public int getFirstChar() {
        this.load();
        return this.getCharacterSetOrientation().getFirstChar();
    }

    public int getLastChar() {
        this.load();
        return this.getCharacterSetOrientation().getLastChar();
    }

    public String getPath() {
        return this.path;
    }

    public int[] getWidths() {
        this.load();
        return this.getCharacterSetOrientation().getWidths();
    }

    public int getXHeight() {
        this.load();
        return this.getCharacterSetOrientation().getXHeight();
    }

    public int width(int character) {
        this.load();
        return this.getCharacterSetOrientation().width(character);
    }

    private void load() {
        if (!this.isMetricsLoaded) {
            AFPFontReader afpFontReader = new AFPFontReader();
            afpFontReader.loadCharacterSetMetric(this);
            this.isMetricsLoaded = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameBytes() {
        return this.nameBytes;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private CharacterSetOrientation getCharacterSetOrientation() {
        CharacterSetOrientation c = (CharacterSetOrientation)this.characterSetOrientations.get(this.currentOrientation);
        return c;
    }

    public char mapChar(char c) {
        return c;
    }
}

