/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.fonts.CharacterSet;

public class OutlineFont
extends AFPFont {
    private CharacterSet charSet = null;

    public OutlineFont(String name, CharacterSet charSet) {
        super(name);
        this.charSet = charSet;
    }

    public CharacterSet getCharacterSet() {
        return this.charSet;
    }

    public CharacterSet getCharacterSet(int size) {
        return this.charSet;
    }

    public int getFirstChar() {
        return this.charSet.getFirstChar();
    }

    public int getLastChar() {
        return this.charSet.getLastChar();
    }

    public int getAscender(int size) {
        return this.charSet.getAscender() / 1000 * size;
    }

    public int getCapHeight(int size) {
        return this.charSet.getCapHeight() / 1000 * size;
    }

    public int getDescender(int size) {
        return this.charSet.getDescender() / 1000 * size;
    }

    public int getXHeight(int size) {
        return this.charSet.getXHeight() / 1000 * size;
    }

    public int getWidth(int character, int size) {
        return this.charSet.width(character) / 1000 * size;
    }

    public int[] getWidths(int size) {
        int[] widths = this.charSet.getWidths();
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = widths[i] / 1000 * size;
        }
        return widths;
    }

    public int[] getWidths() {
        return this.getWidths(1000);
    }

    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    public String getEncoding() {
        return this.charSet.getEncoding();
    }
}

