/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.MapCodedFont;
import org.apache.fop.render.afp.modca.MapPageOverlay;
import org.apache.fop.render.afp.modca.MaximumSizeExceededException;
import org.apache.fop.render.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.render.afp.modca.ObjectAreaPosition;
import org.apache.fop.render.afp.modca.PageDescriptor;
import org.apache.fop.render.afp.modca.PresentationTextDescriptor;

public final class ActiveEnvironmentGroup
extends AbstractNamedAFPObject {
    private static final String DEFAULT_NAME = "AEG00001";
    private ArrayList mapCodedFonts = new ArrayList();
    private ObjectAreaDescriptor objectAreaDescriptor = null;
    private ObjectAreaPosition objectAreaPosition = null;
    private PresentationTextDescriptor presentationTextDataDescriptor = null;
    private PageDescriptor pageDescriptor = null;
    private ArrayList mapPageOverlays = new ArrayList();

    public ActiveEnvironmentGroup(int width, int height, int widthResolution, int heightResolution) {
        this(DEFAULT_NAME, width, height, widthResolution, heightResolution);
    }

    public ActiveEnvironmentGroup(String name, int width, int height, int widthResolution, int heightResolution) {
        super(name);
        this.pageDescriptor = new PageDescriptor(width, height, widthResolution, heightResolution);
        this.objectAreaDescriptor = new ObjectAreaDescriptor(width, height, widthResolution, heightResolution);
        this.presentationTextDataDescriptor = new PresentationTextDescriptor(width, height, widthResolution, heightResolution);
    }

    public void setPosition(int x, int y, int rotation) {
        this.objectAreaPosition = new ObjectAreaPosition(x, y, rotation);
    }

    public PageDescriptor getPageDescriptor() {
        return this.pageDescriptor;
    }

    public PresentationTextDescriptor getPresentationTextDataDescriptor() {
        return this.presentationTextDataDescriptor;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        this.writeObjectList(this.mapCodedFonts, os);
        this.writeObjectList(this.mapPageOverlays, os);
        this.pageDescriptor.writeDataStream(os);
        if (this.objectAreaDescriptor != null && this.objectAreaPosition != null) {
            this.objectAreaDescriptor.writeDataStream(os);
            this.objectAreaPosition.writeDataStream(os);
        }
        this.presentationTextDataDescriptor.writeDataStream(os);
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -55;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -55;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    public void createFont(byte fontReference, AFPFont font, int size, int orientation) {
        MapCodedFont mcf = this.getCurrentMapCodedFont();
        if (mcf == null) {
            mcf = new MapCodedFont();
            this.mapCodedFonts.add(mcf);
        }
        try {
            mcf.addFont(fontReference, font, size, orientation);
        }
        catch (MaximumSizeExceededException msee) {
            mcf = new MapCodedFont();
            this.mapCodedFonts.add(mcf);
            try {
                mcf.addFont(fontReference, font, size, orientation);
            }
            catch (MaximumSizeExceededException ex) {
                log.error("createFont():: resulted in a MaximumSizeExceededException");
            }
        }
    }

    public void createOverlay(String name) {
        MapPageOverlay mpo = this.getCurrentMapPageOverlay();
        if (mpo == null) {
            mpo = new MapPageOverlay();
            this.mapPageOverlays.add(mpo);
        }
        try {
            mpo.addOverlay(name);
        }
        catch (MaximumSizeExceededException msee) {
            mpo = new MapPageOverlay();
            this.mapPageOverlays.add(mpo);
            try {
                mpo.addOverlay(name);
            }
            catch (MaximumSizeExceededException ex) {
                log.error("createOverlay():: resulted in a MaximumSizeExceededException");
            }
        }
    }

    private MapCodedFont getCurrentMapCodedFont() {
        int size = this.mapCodedFonts.size();
        if (size > 0) {
            return (MapCodedFont)this.mapCodedFonts.get(this.mapCodedFonts.size() - 1);
        }
        return null;
    }

    private MapPageOverlay getCurrentMapPageOverlay() {
        int size = this.mapPageOverlays.size();
        if (size > 0) {
            return (MapPageOverlay)this.mapPageOverlays.get(this.mapPageOverlays.size() - 1);
        }
        return null;
    }
}

