/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.fop.render.ps.PSDictionaryFormatException;
import org.apache.fop.render.ps.PSPageDeviceDictionary;

public class PSDictionary
extends HashMap {
    private static final long serialVersionUID = 815367222496219197L;

    public static PSDictionary valueOf(String str) throws PSDictionaryFormatException {
        return new Maker().parseDictionary(str);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PSPageDeviceDictionary)) {
            return false;
        }
        PSDictionary dictionaryObj = (PSDictionary)obj;
        if (dictionaryObj.size() != this.size()) {
            return false;
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!dictionaryObj.containsKey(key)) {
                return false;
            }
            if (dictionaryObj.get(key).equals(this.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 7;
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            hashCode += value.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer("<<\n");
        Iterator it = super.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            sb.append("  " + key + " ");
            Object obj = super.get(key);
            if (obj instanceof ArrayList) {
                List array = (List)obj;
                String str = "[";
                for (int i = 0; i < array.size(); ++i) {
                    Object element = array.get(i);
                    str = str + element + " ";
                }
                str = str.trim();
                str = str + "]";
                sb.append(str + "\n");
                continue;
            }
            sb.append(obj.toString() + "\n");
        }
        sb.append(">>");
        return sb.toString();
    }

    private static class Maker {
        private static final String[][] BRACES = new String[][]{{"<<", ">>"}, {"[", "]"}, {"{", "}"}};
        private static final int OPENING = 0;
        private static final int CLOSING = 1;
        private static final int DICTIONARY = 0;
        private static final int ARRAY = 1;
        private static final int PROCEDURE = 2;

        private Maker() {
        }

        protected Token nextToken(String str, int fromIndex) {
            Token t = null;
            for (int i = fromIndex; i < str.length(); ++i) {
                boolean isWhitespace = Character.isWhitespace(str.charAt(i));
                if (t == null && !isWhitespace) {
                    t = new Token();
                    t.startIndex = i;
                    continue;
                }
                if (t == null || !isWhitespace) continue;
                t.endIndex = i;
                break;
            }
            if (t != null) {
                if (t.endIndex == -1) {
                    t.endIndex = str.length();
                }
                t.value = str.substring(t.startIndex, t.endIndex);
            }
            return t;
        }

        private int indexOfMatchingBrace(String str, String[] braces, int fromIndex) throws PSDictionaryFormatException {
            int len = str.length();
            if (braces.length != 2) {
                throw new PSDictionaryFormatException("Wrong number of braces");
            }
            int openCnt = 0;
            int closeCnt = 0;
            while (fromIndex < len) {
                if (str.startsWith(braces[0], fromIndex)) {
                    ++openCnt;
                } else if (str.startsWith(braces[1], fromIndex) && openCnt > 0 && openCnt == ++closeCnt) {
                    return fromIndex;
                }
                ++fromIndex;
            }
            return -1;
        }

        private String stripBraces(String str, String[] braces) throws PSDictionaryFormatException {
            int firstIndex = str.indexOf(braces[0]);
            if (firstIndex == -1) {
                throw new PSDictionaryFormatException("Failed to find opening parameter '" + braces[0] + "");
            }
            int lastIndex = this.indexOfMatchingBrace(str, braces, firstIndex);
            if (lastIndex == -1) {
                throw new PSDictionaryFormatException("Failed to find matching closing parameter '" + braces[1] + "'");
            }
            int braceLen = braces[0].length();
            str = str.substring(firstIndex + braceLen, lastIndex).trim();
            return str;
        }

        public PSDictionary parseDictionary(String str) throws PSDictionaryFormatException {
            Token keyToken;
            PSDictionary dictionary = new PSDictionary();
            str = this.stripBraces(str.trim(), BRACES[0]);
            int len = str.length();
            int currIndex = 0;
            while ((keyToken = this.nextToken(str, currIndex)) != null && currIndex <= len) {
                if (keyToken.value == null) {
                    throw new PSDictionaryFormatException("Failed to parse object key");
                }
                Token valueToken = this.nextToken(str, keyToken.endIndex + 1);
                String[] braces = null;
                for (int i = 0; i < BRACES.length; ++i) {
                    if (!valueToken.value.startsWith(BRACES[i][0])) continue;
                    braces = BRACES[i];
                    break;
                }
                ArrayList<String> obj = null;
                if (braces != null) {
                    valueToken.endIndex = this.indexOfMatchingBrace(str, braces, valueToken.startIndex) + braces[0].length();
                    if (valueToken.endIndex < 0) {
                        throw new PSDictionaryFormatException("Closing value brace '" + braces[1] + "' not found for key '" + keyToken.value + "'");
                    }
                    valueToken.value = str.substring(valueToken.startIndex, valueToken.endIndex);
                }
                if (braces == null || braces == BRACES[2]) {
                    obj = valueToken.value;
                } else if (BRACES[1] == braces) {
                    ArrayList<String> objList = new ArrayList<String>();
                    String objString = this.stripBraces(valueToken.value, braces);
                    StringTokenizer tokenizer = new StringTokenizer(objString, ",");
                    while (tokenizer.hasMoreTokens()) {
                        objList.add(tokenizer.nextToken());
                    }
                    obj = objList;
                } else if (BRACES[0] == braces) {
                    obj = this.parseDictionary(valueToken.value);
                }
                dictionary.put(keyToken.value, obj);
                currIndex = valueToken.endIndex + 1;
            }
            return dictionary;
        }

        private class Token {
            private int startIndex = -1;
            private int endIndex = -1;
            private String value;

            private Token() {
            }
        }
    }
}

