/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.search.SearchConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchInfo
implements SearchConstants,
XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(SearchInfo.class);
    private static final Set IGNORED_NAMESPACES;
    private final String language;
    private final Namespace languageNamespace;
    private final String query;
    private final Map namespaces;

    public SearchInfo(String language, Namespace languageNamespace, String query, Map namespaces) {
        this.language = language;
        this.languageNamespace = languageNamespace;
        this.query = query;
        this.namespaces = Collections.unmodifiableMap(new HashMap(namespaces));
    }

    public SearchInfo(String language, Namespace languageNamespace, String query) {
        this(language, languageNamespace, query, Collections.EMPTY_MAP);
    }

    public String getLanguageName() {
        return this.language;
    }

    public Namespace getLanguageNameSpace() {
        return this.languageNamespace;
    }

    public String getQuery() {
        return this.query;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public Element toXml(Document document) {
        Element sRequestElem = DomUtil.createElement(document, "searchrequest", NAMESPACE);
        Iterator it = this.namespaces.keySet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String uri = (String)this.namespaces.get(prefix);
            DomUtil.setNamespaceAttribute(sRequestElem, prefix, uri);
        }
        DomUtil.addChildElement(sRequestElem, this.language, this.languageNamespace, this.query);
        return sRequestElem;
    }

    public static SearchInfo createFromXml(Element searchRequest) throws DavException {
        if (searchRequest == null || !"searchrequest".equals(searchRequest.getLocalName())) {
            log.warn("The root element must be 'searchrequest'.");
            throw new DavException(400);
        }
        Element first = DomUtil.getFirstChildElement(searchRequest);
        Attr[] nsAttributes = DomUtil.getNamespaceAttributes(searchRequest);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < nsAttributes.length; ++i) {
            if (IGNORED_NAMESPACES.contains(nsAttributes[i].getValue())) continue;
            namespaces.put(nsAttributes[i].getLocalName(), nsAttributes[i].getValue());
        }
        if (first != null) {
            return new SearchInfo(first.getLocalName(), DomUtil.getNamespace(first), DomUtil.getText(first), namespaces);
        }
        log.warn("A single child element is expected with the 'DAV:searchrequest'.");
        throw new DavException(400);
    }

    static {
        HashSet<String> s2 = new HashSet<String>();
        s2.add(Namespace.XMLNS_NAMESPACE.getURI());
        s2.add(Namespace.XML_NAMESPACE.getURI());
        s2.add(DavConstants.NAMESPACE.getURI());
        IGNORED_NAMESPACES = Collections.unmodifiableSet(s2);
    }
}

