/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.apt;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.apache.maven.doxia.module.apt.AptParseException;
import org.apache.maven.doxia.module.apt.AptSource;
import org.codehaus.plexus.util.IOUtil;

public class AptReaderSource
implements AptSource {
    private LineNumberReader reader;
    private int lineNumber;
    private String name;

    public AptReaderSource(Reader in) {
        this.reader = new LineNumberReader(in);
        this.lineNumber = -1;
    }

    public AptReaderSource(Reader in, String name) {
        this(in);
        this.name = name;
    }

    @Override
    public String getNextLine() throws AptParseException {
        String line;
        if (this.reader == null) {
            return null;
        }
        try {
            line = this.reader.readLine();
            if (line == null) {
                this.reader.close();
                this.reader = null;
            } else {
                this.lineNumber = this.reader.getLineNumber();
            }
        }
        catch (IOException e) {
            throw new AptParseException("IOException: " + e.getMessage(), e, this.lineNumber, -1);
        }
        return line;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : "";
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void close() {
        IOUtil.close(this.reader);
        this.reader = null;
    }
}

