/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractXmlSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class XhtmlBaseSink
extends AbstractXmlSink
implements HtmlMarkup {
    private final PrintWriter writer;
    private StringBuffer textBuffer = new StringBuffer();
    private boolean headFlag;
    private boolean figureCaptionFlag;
    private boolean paragraphFlag;
    private boolean verbatimFlag;
    private final LinkedList<int[]> cellJustifStack;
    private final LinkedList<Boolean> isCellJustifStack;
    private final LinkedList<Integer> cellCountStack;
    private boolean evenTableRow = true;
    private final LinkedList<StringWriter> tableContentWriterStack;
    private final LinkedList<StringWriter> tableCaptionWriterStack;
    private final LinkedList<PrettyPrintXMLWriter> tableCaptionXMLWriterStack;
    private final LinkedList<String> tableCaptionStack;
    protected MutableAttributeSet tableAttributes;
    private boolean legacyFigure;
    private boolean legacyFigureCaption;
    private boolean inFigure;
    protected boolean tableRows = false;
    private Map<String, Set<String>> warnMessages;

    public XhtmlBaseSink(Writer out) {
        this.writer = new PrintWriter(out);
        this.cellJustifStack = new LinkedList();
        this.isCellJustifStack = new LinkedList();
        this.cellCountStack = new LinkedList();
        this.tableContentWriterStack = new LinkedList();
        this.tableCaptionWriterStack = new LinkedList();
        this.tableCaptionXMLWriterStack = new LinkedList();
        this.tableCaptionStack = new LinkedList();
        this.init();
    }

    protected StringBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headFlag = headFlag;
    }

    protected boolean isHeadFlag() {
        return this.headFlag;
    }

    protected void setVerbatimFlag(boolean verb) {
        this.verbatimFlag = verb;
    }

    protected boolean isVerbatimFlag() {
        return this.verbatimFlag;
    }

    protected void setCellJustif(int[] justif) {
        this.cellJustifStack.addLast(justif);
        this.isCellJustifStack.addLast(Boolean.TRUE);
    }

    protected int[] getCellJustif() {
        return this.cellJustifStack.getLast();
    }

    protected void setCellCount(int count) {
        this.cellCountStack.addLast(count);
    }

    protected int getCellCount() {
        return Integer.parseInt(this.cellCountStack.getLast().toString());
    }

    protected void resetState() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.resetTextBuffer();
        this.cellJustifStack.clear();
        this.isCellJustifStack.clear();
        this.cellCountStack.clear();
        this.tableContentWriterStack.clear();
        this.tableCaptionWriterStack.clear();
        this.tableCaptionXMLWriterStack.clear();
        this.tableCaptionStack.clear();
        this.headFlag = false;
        this.figureCaptionFlag = false;
        this.paragraphFlag = false;
        this.verbatimFlag = false;
        this.evenTableRow = true;
        this.tableAttributes = null;
        this.legacyFigure = false;
        this.legacyFigureCaption = false;
        this.inFigure = false;
        this.tableRows = false;
        this.warnMessages = null;
    }

    protected void resetTextBuffer() {
        this.textBuffer = new StringBuffer();
    }

    @Override
    public void section(int level, SinkEventAttributes attributes) {
        this.onSection(level, attributes);
    }

    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.onSectionTitle(level, attributes);
    }

    @Override
    public void sectionTitle_(int level) {
        this.onSectionTitle_(level);
    }

    @Override
    public void section_(int level) {
        this.onSection_(level);
    }

    @Override
    public void section1() {
        this.onSection(1, null);
    }

    @Override
    public void sectionTitle1() {
        this.onSectionTitle(1, null);
    }

    @Override
    public void sectionTitle1_() {
        this.onSectionTitle_(1);
    }

    @Override
    public void section1_() {
        this.onSection_(1);
    }

    @Override
    public void section2() {
        this.onSection(2, null);
    }

    @Override
    public void sectionTitle2() {
        this.onSectionTitle(2, null);
    }

    @Override
    public void sectionTitle2_() {
        this.onSectionTitle_(2);
    }

    @Override
    public void section2_() {
        this.onSection_(2);
    }

    @Override
    public void section3() {
        this.onSection(3, null);
    }

    @Override
    public void sectionTitle3() {
        this.onSectionTitle(3, null);
    }

    @Override
    public void sectionTitle3_() {
        this.onSectionTitle_(3);
    }

    @Override
    public void section3_() {
        this.onSection_(3);
    }

    @Override
    public void section4() {
        this.onSection(4, null);
    }

    @Override
    public void sectionTitle4() {
        this.onSectionTitle(4, null);
    }

    @Override
    public void sectionTitle4_() {
        this.onSectionTitle_(4);
    }

    @Override
    public void section4_() {
        this.onSection_(4);
    }

    @Override
    public void section5() {
        this.onSection(5, null);
    }

    @Override
    public void sectionTitle5() {
        this.onSectionTitle(5, null);
    }

    @Override
    public void sectionTitle5_() {
        this.onSectionTitle_(5);
    }

    @Override
    public void section5_() {
        this.onSection_(5);
    }

    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth >= 1 && depth <= 5) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute(HTML.Attribute.CLASS, "section");
            att.addAttributes(SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            this.writeStartTag(HtmlMarkup.DIV, att);
        }
    }

    protected void onSection_(int depth) {
        if (depth >= 1 && depth <= 5) {
            this.writeEndTag(HtmlMarkup.DIV);
        }
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 1) {
            this.writeStartTag(HtmlMarkup.H2, atts);
        } else if (depth == 2) {
            this.writeStartTag(HtmlMarkup.H3, atts);
        } else if (depth == 3) {
            this.writeStartTag(HtmlMarkup.H4, atts);
        } else if (depth == 4) {
            this.writeStartTag(HtmlMarkup.H5, atts);
        } else if (depth == 5) {
            this.writeStartTag(HtmlMarkup.H6, atts);
        }
    }

    protected void onSectionTitle_(int depth) {
        if (depth == 1) {
            this.writeEndTag(HtmlMarkup.H2);
        } else if (depth == 2) {
            this.writeEndTag(HtmlMarkup.H3);
        } else if (depth == 3) {
            this.writeEndTag(HtmlMarkup.H4);
        } else if (depth == 4) {
            this.writeEndTag(HtmlMarkup.H5);
        } else if (depth == 5) {
            this.writeEndTag(HtmlMarkup.H6);
        }
    }

    @Override
    public void list() {
        this.list(null);
    }

    @Override
    public void list(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.UL, atts);
    }

    @Override
    public void list_() {
        this.writeEndTag(HtmlMarkup.UL);
    }

    @Override
    public void listItem() {
        this.listItem(null);
    }

    @Override
    public void listItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    @Override
    public void listItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    @Override
    public void numberedList(int numbering) {
        this.numberedList(numbering, null);
    }

    @Override
    public void numberedList(int numbering, SinkEventAttributes attributes) {
        String style;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        switch (numbering) {
            case 2: {
                style = "upper-alpha";
                break;
            }
            case 1: {
                style = "lower-alpha";
                break;
            }
            case 4: {
                style = "upper-roman";
                break;
            }
            case 3: {
                style = "lower-roman";
                break;
            }
            default: {
                style = "decimal";
            }
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet(1);
        }
        atts.addAttribute(HTML.Attribute.STYLE, "list-style-type: " + style);
        this.writeStartTag(HtmlMarkup.OL, atts);
    }

    @Override
    public void numberedList_() {
        this.writeEndTag(HtmlMarkup.OL);
    }

    @Override
    public void numberedListItem() {
        this.numberedListItem(null);
    }

    @Override
    public void numberedListItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    @Override
    public void numberedListItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    @Override
    public void definitionList() {
        this.definitionList(null);
    }

    @Override
    public void definitionList(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DL, atts);
    }

    @Override
    public void definitionList_() {
        this.writeEndTag(HtmlMarkup.DL);
    }

    @Override
    public void definedTerm(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DT, atts);
    }

    @Override
    public void definedTerm() {
        this.definedTerm(null);
    }

    @Override
    public void definedTerm_() {
        this.writeEndTag(HtmlMarkup.DT);
    }

    @Override
    public void definition() {
        this.definition(null);
    }

    @Override
    public void definition(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DD, atts);
    }

    @Override
    public void definition_() {
        this.writeEndTag(HtmlMarkup.DD);
    }

    @Override
    public void figure() {
        this.write(String.valueOf('<') + HtmlMarkup.IMG);
        this.legacyFigure = true;
    }

    @Override
    public void figure(SinkEventAttributes attributes) {
        this.inFigure = true;
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet(1);
        }
        if (!atts.isDefined("class")) {
            atts.addAttribute("class", "figure");
        }
        this.writeStartTag(HtmlMarkup.DIV, atts);
    }

    @Override
    public void figure_() {
        if (this.legacyFigure) {
            if (!this.figureCaptionFlag) {
                this.write(String.valueOf(' ') + HTML.Attribute.ALT + '=' + '\"' + '\"');
            }
            this.write(String.valueOf(' ') + '/' + '>');
            this.legacyFigure = false;
        } else {
            this.writeEndTag(HtmlMarkup.DIV);
            this.inFigure = false;
        }
        this.figureCaptionFlag = false;
    }

    @Override
    public void figureGraphics(String name) {
        this.write(String.valueOf(' ') + HTML.Attribute.SRC + '=' + '\"' + XhtmlBaseSink.escapeHTML(name) + '\"');
    }

    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        MutableAttributeSet filtered;
        if (this.inFigure) {
            SinkEventAttributeSet atts = new SinkEventAttributeSet(1);
            atts.addAttribute("align", "center");
            this.writeStartTag(HtmlMarkup.P, atts);
        }
        if ((filtered = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_IMG_ATTRIBUTES)) != null) {
            filtered.removeAttribute(HTML.Attribute.SRC.toString());
        }
        int count = attributes == null ? 1 : attributes.getAttributeCount() + 1;
        SinkEventAttributeSet atts = new SinkEventAttributeSet(count);
        atts.addAttribute(HTML.Attribute.SRC, XhtmlBaseSink.escapeHTML(src));
        atts.addAttributes(filtered);
        if (atts.getAttribute(HTML.Attribute.ALT.toString()) == null) {
            atts.addAttribute(HTML.Attribute.ALT.toString(), "");
        }
        this.writeStartTag(HtmlMarkup.IMG, atts, true);
        if (this.inFigure) {
            this.writeEndTag(HtmlMarkup.P);
        }
    }

    @Override
    public void figureCaption() {
        this.figureCaptionFlag = true;
        this.write(String.valueOf(' ') + HTML.Attribute.ALT + '=' + '\"');
        this.legacyFigureCaption = true;
    }

    @Override
    public void figureCaption(SinkEventAttributes attributes) {
        if (this.legacyFigureCaption) {
            this.write(String.valueOf(' ') + HTML.Attribute.ALT + '=' + '\"');
            this.legacyFigureCaption = false;
            this.figureCaptionFlag = true;
        } else {
            SinkEventAttributeSet atts = new SinkEventAttributeSet(1);
            atts.addAttribute("align", "center");
            atts.addAttributes(SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            this.paragraph(atts);
            this.italic();
        }
    }

    @Override
    public void figureCaption_() {
        if (this.legacyFigureCaption) {
            this.write(String.valueOf('\"'));
        } else {
            this.italic_();
            this.paragraph_();
        }
    }

    @Override
    public void paragraph() {
        this.paragraph(null);
    }

    @Override
    public void paragraph(SinkEventAttributes attributes) {
        this.paragraphFlag = true;
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.P, atts);
    }

    @Override
    public void paragraph_() {
        if (this.paragraphFlag) {
            this.writeEndTag(HtmlMarkup.P);
            this.paragraphFlag = false;
        }
    }

    @Override
    public void verbatim(boolean boxed) {
        if (boxed) {
            this.verbatim(SinkEventAttributeSet.BOXED);
        } else {
            this.verbatim(null);
        }
    }

    @Override
    public void verbatim(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.verbatimFlag = true;
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        boolean boxed = false;
        if (atts.isDefined("decoration")) {
            boxed = "boxed".equals(atts.getAttribute("decoration").toString());
        }
        SinkEventAttributeSet divAtts = null;
        if (boxed) {
            divAtts = new SinkEventAttributeSet(HTML.Attribute.CLASS.toString(), "source");
        }
        atts.removeAttribute("decoration");
        this.writeStartTag(HtmlMarkup.DIV, divAtts);
        this.writeStartTag(HtmlMarkup.PRE, atts);
    }

    @Override
    public void verbatim_() {
        this.writeEndTag(HtmlMarkup.PRE);
        this.writeEndTag(HtmlMarkup.DIV);
        this.verbatimFlag = false;
    }

    @Override
    public void horizontalRule() {
        this.horizontalRule(null);
    }

    @Override
    public void horizontalRule(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_HR_ATTRIBUTES);
        this.writeSimpleTag(HtmlMarkup.HR, atts);
    }

    @Override
    public void table() {
        this.table(null);
    }

    @Override
    public void table(SinkEventAttributes attributes) {
        this.tableContentWriterStack.addLast(new StringWriter());
        this.tableRows = false;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.tableAttributes = attributes == null ? new SinkEventAttributeSet(0) : SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TABLE_ATTRIBUTES);
    }

    @Override
    public void table_() {
        this.tableRows = false;
        this.writeEndTag(HtmlMarkup.TABLE);
        if (!this.cellCountStack.isEmpty()) {
            this.cellCountStack.removeLast().toString();
        }
        if (this.tableContentWriterStack.isEmpty()) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn("No table content.");
            }
            return;
        }
        String tableContent = this.tableContentWriterStack.removeLast().toString();
        String tableCaption = null;
        if (!this.tableCaptionStack.isEmpty() && this.tableCaptionStack.getLast() != null) {
            tableCaption = this.tableCaptionStack.removeLast().toString();
        }
        if (tableCaption != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(tableContent.substring(0, tableContent.indexOf(62) + 1));
            sb.append(tableCaption);
            sb.append(tableContent.substring(tableContent.indexOf(62) + 1));
            this.write(sb.toString());
        } else {
            this.write(tableContent);
        }
    }

    @Override
    public void tableRows(int[] justification, boolean grid) {
        this.tableRows = true;
        this.setCellJustif(justification);
        if (this.tableAttributes == null) {
            this.tableAttributes = new SinkEventAttributeSet(0);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (!this.tableAttributes.isDefined(HTML.Attribute.BORDER.toString())) {
            att.addAttribute(HTML.Attribute.BORDER, grid ? "1" : "0");
        }
        if (!this.tableAttributes.isDefined(HTML.Attribute.CLASS.toString())) {
            att.addAttribute(HTML.Attribute.CLASS, "bodyTable");
        }
        att.addAttributes(this.tableAttributes);
        this.tableAttributes.removeAttributes(this.tableAttributes);
        this.writeStartTag(HtmlMarkup.TABLE, att);
        this.cellCountStack.addLast(0);
    }

    @Override
    public void tableRows_() {
        this.tableRows = false;
        if (!this.cellJustifStack.isEmpty()) {
            this.cellJustifStack.removeLast();
        }
        if (!this.isCellJustifStack.isEmpty()) {
            this.isCellJustifStack.removeLast();
        }
        this.evenTableRow = true;
    }

    @Override
    public void tableRow() {
        if (!this.tableRows) {
            this.tableRows(null, false);
        }
        this.tableRow(null);
    }

    @Override
    public void tableRow(SinkEventAttributes attributes) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (this.evenTableRow) {
            att.addAttribute(HTML.Attribute.CLASS, "a");
        } else {
            att.addAttribute(HTML.Attribute.CLASS, "b");
        }
        att.addAttributes(SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TR_ATTRIBUTES));
        this.writeStartTag(HtmlMarkup.TR, att);
        boolean bl = this.evenTableRow = !this.evenTableRow;
        if (!this.cellCountStack.isEmpty()) {
            this.cellCountStack.removeLast();
            this.cellCountStack.addLast(0);
        }
    }

    @Override
    public void tableRow_() {
        this.writeEndTag(HtmlMarkup.TR);
    }

    @Override
    public void tableCell() {
        this.tableCell((SinkEventAttributes)null);
    }

    @Override
    public void tableHeaderCell() {
        this.tableHeaderCell((SinkEventAttributes)null);
    }

    @Override
    public void tableCell(String width) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.WIDTH, width);
        this.tableCell(false, att);
    }

    @Override
    public void tableHeaderCell(String width) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.WIDTH, width);
        this.tableCell(true, att);
    }

    @Override
    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false, attributes);
    }

    @Override
    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true, attributes);
    }

    private void tableCell(boolean headerRow, MutableAttributeSet attributes) {
        HTML.Tag t;
        HTML.Tag tag = t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        if (attributes == null) {
            this.writeStartTag(t, null);
        } else {
            this.writeStartTag(t, SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TD_ATTRIBUTES));
        }
    }

    @Override
    public void tableCell_() {
        this.tableCell_(false);
    }

    @Override
    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    private void tableCell_(boolean headerRow) {
        HTML.Tag t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        this.writeEndTag(t);
        if (!this.isCellJustifStack.isEmpty() && this.isCellJustifStack.getLast().equals(Boolean.TRUE) && !this.cellCountStack.isEmpty()) {
            int cellCount = Integer.parseInt(this.cellCountStack.removeLast().toString());
            this.cellCountStack.addLast(++cellCount);
        }
    }

    @Override
    public void tableCaption() {
        this.tableCaption(null);
    }

    @Override
    public void tableCaption(SinkEventAttributes attributes) {
        StringWriter sw = new StringWriter();
        this.tableCaptionWriterStack.addLast(sw);
        this.tableCaptionXMLWriterStack.addLast(new PrettyPrintXMLWriter(sw));
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.CAPTION, atts);
    }

    @Override
    public void tableCaption_() {
        this.writeEndTag(HtmlMarkup.CAPTION);
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionStack.addLast(this.tableCaptionWriterStack.removeLast().toString());
            this.tableCaptionXMLWriterStack.removeLast();
        }
    }

    @Override
    public void anchor(String name) {
        this.anchor(name, null);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        if (this.headFlag) {
            return;
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        String id = name;
        if (!DoxiaUtils.isValidId(id)) {
            id = DoxiaUtils.encodeId(name, true);
            String msg = "Modified invalid anchor name: '" + name + "' to '" + id + "'";
            this.logMessage("modifiedLink", msg);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.NAME, id);
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.A, att);
    }

    @Override
    public void anchor_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    @Override
    public void link(String name) {
        this.link(name, null);
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        if (attributes == null) {
            this.link(name, null, null);
        } else {
            String target = (String)attributes.getAttribute(HTML.Attribute.TARGET.toString());
            MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_LINK_ATTRIBUTES);
            this.link(name, target, atts);
        }
    }

    private void link(String href, String target, MutableAttributeSet attributes) {
        if (href == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (this.headFlag) {
            return;
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (DoxiaUtils.isExternalLink(href)) {
            att.addAttribute(HTML.Attribute.CLASS, "externalLink");
        }
        att.addAttribute(HTML.Attribute.HREF, HtmlTools.escapeHTML(href));
        if (target != null) {
            att.addAttribute(HTML.Attribute.TARGET, target);
        }
        if (attributes != null) {
            attributes.removeAttribute(HTML.Attribute.HREF.toString());
            attributes.removeAttribute(HTML.Attribute.TARGET.toString());
            att.addAttributes(attributes);
        }
        this.writeStartTag(HtmlMarkup.A, att);
    }

    @Override
    public void link_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    @Override
    public void italic() {
        if (!this.headFlag) {
            this.writeStartTag(HtmlMarkup.I);
        }
    }

    @Override
    public void italic_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.I);
        }
    }

    @Override
    public void bold() {
        if (!this.headFlag) {
            this.writeStartTag(HtmlMarkup.B);
        }
    }

    @Override
    public void bold_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.B);
        }
    }

    @Override
    public void monospaced() {
        if (!this.headFlag) {
            this.writeStartTag(HtmlMarkup.TT);
        }
    }

    @Override
    public void monospaced_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.TT);
        }
    }

    @Override
    public void lineBreak() {
        this.lineBreak(null);
    }

    @Override
    public void lineBreak(SinkEventAttributes attributes) {
        if (this.headFlag || this.isVerbatimFlag()) {
            this.getTextBuffer().append(EOL);
        } else {
            MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BR_ATTRIBUTES);
            this.writeSimpleTag(HtmlMarkup.BR, atts);
        }
    }

    @Override
    public void pageBreak() {
        this.comment(" PB ");
    }

    @Override
    public void nonBreakingSpace() {
        if (this.headFlag) {
            this.getTextBuffer().append(' ');
        } else {
            this.write("&#160;");
        }
    }

    @Override
    public void text(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    @Override
    public void text(String text, SinkEventAttributes attributes) {
        if (attributes == null) {
            this.text(text);
        } else {
            if (attributes.containsAttribute("decoration", "underline")) {
                this.writeStartTag(HtmlMarkup.U);
            }
            if (attributes.containsAttribute("decoration", "line-through")) {
                this.writeStartTag(HtmlMarkup.S);
            }
            if (attributes.containsAttribute("valign", "sub")) {
                this.writeStartTag(HtmlMarkup.SUB);
            }
            if (attributes.containsAttribute("valign", "sup")) {
                this.writeStartTag(HtmlMarkup.SUP);
            }
            this.text(text);
            if (attributes.containsAttribute("valign", "sup")) {
                this.writeEndTag(HtmlMarkup.SUP);
            }
            if (attributes.containsAttribute("valign", "sub")) {
                this.writeEndTag(HtmlMarkup.SUB);
            }
            if (attributes.containsAttribute("decoration", "line-through")) {
                this.writeEndTag(HtmlMarkup.S);
            }
            if (attributes.containsAttribute("decoration", "underline")) {
                this.writeEndTag(HtmlMarkup.U);
            }
        }
    }

    @Override
    public void rawText(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else {
            this.write(text);
        }
    }

    @Override
    public void comment(String comment) {
        if (comment != null) {
            String originalComment = comment;
            while (comment.contains("--")) {
                comment = comment.replace("--", "- -");
            }
            if (comment.endsWith("-")) {
                comment = comment + " ";
            }
            if (!originalComment.equals(comment)) {
                this.getLog().warn("[Xhtml Sink] Modified invalid comment '" + originalComment + "' to '" + comment + "'");
            }
            StringBuilder buffer = new StringBuilder(comment.length() + 7);
            buffer.append('<').append('!').append('-').append('-');
            buffer.append(comment);
            buffer.append('-').append('-').append('>');
            this.write(buffer.toString());
        }
    }

    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        if (requiredParams == null || !(requiredParams[0] instanceof Integer)) {
            String msg = "No type information for unknown event: '" + name + "', ignoring!";
            this.logMessage("noTypeInfo", msg);
            return;
        }
        int tagType = (Integer)requiredParams[0];
        if (tagType == 4) {
            this.rawText(name);
            return;
        }
        if (tagType == 5) {
            this.rawText(EOL + "//<![CDATA[" + requiredParams[1] + "]]>" + EOL);
            return;
        }
        HTML.Tag tag = HtmlTools.getHtmlTag(name);
        if (tag == null) {
            String msg = "No HTML tag found for unknown event: '" + name + "', ignoring!";
            this.logMessage("noHtmlTag", msg);
        } else if (tagType == 1) {
            this.writeSimpleTag(tag, this.escapeAttributeValues(attributes));
        } else if (tagType == 2) {
            this.writeStartTag(tag, this.escapeAttributeValues(attributes));
        } else if (tagType == 3) {
            this.writeEndTag(tag);
        } else {
            String msg = "No type information for unknown event: '" + name + "', ignoring!";
            this.logMessage("noTypeInfo", msg);
        }
    }

    private SinkEventAttributes escapeAttributeValues(SinkEventAttributes attributes) {
        SinkEventAttributeSet set = new SinkEventAttributeSet(attributes.getAttributeCount());
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            set.addAttribute(name, XhtmlBaseSink.escapeHTML(attributes.getAttribute(name).toString()));
        }
        return set;
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
        if (this.getLog().isWarnEnabled() && this.warnMessages != null) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn(msg);
                }
            }
            this.warnMessages = null;
        }
        this.init();
    }

    protected void content(String text) {
        String txt = XhtmlBaseSink.escapeHTML(text);
        txt = StringUtils.replace(txt, "&amp;#", "&#");
        this.write(txt);
    }

    protected void verbatimContent(String text) {
        this.write(XhtmlBaseSink.escapeHTML(text));
    }

    protected static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text, false);
    }

    protected static String encodeURL(String text) {
        return HtmlTools.encodeURL(text);
    }

    @Override
    protected void write(String text) {
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionXMLWriterStack.getLast().writeText(XhtmlBaseSink.unifyEOLs(text));
        } else if (!this.tableContentWriterStack.isEmpty() && this.tableContentWriterStack.getLast() != null) {
            this.tableContentWriterStack.getLast().write(XhtmlBaseSink.unifyEOLs(text));
        } else {
            this.writer.write(XhtmlBaseSink.unifyEOLs(text));
        }
    }

    @Override
    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeStartTag(t, att, isSimpleTag);
        } else {
            String tag = (this.getNameSpace() != null ? this.getNameSpace() + ":" : "") + t.toString();
            this.tableCaptionXMLWriterStack.getLast().startElement(tag);
            if (att != null) {
                Enumeration<?> names = att.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object key = names.nextElement();
                    Object value = att.getAttribute(key);
                    this.tableCaptionXMLWriterStack.getLast().addAttribute(key.toString(), value.toString());
                }
            }
            if (isSimpleTag) {
                this.tableCaptionXMLWriterStack.getLast().endElement();
            }
        }
    }

    @Override
    protected void writeEndTag(HTML.Tag t) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeEndTag(t);
        } else {
            this.tableCaptionXMLWriterStack.getLast().endElement();
        }
    }

    private void logMessage(String key, String msg) {
        Set<String> set;
        String mesg = "[XHTML Sink] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(mesg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(mesg);
        this.warnMessages.put(key, set);
    }
}

