/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.events;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSet;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.events.AbstractDSCComment;

public class DSCCommentBeginResource
extends AbstractDSCComment {
    private PSResource resource;
    private Integer min;
    private Integer max;

    public DSCCommentBeginResource() {
    }

    public DSCCommentBeginResource(PSResource resource) {
        this.resource = resource;
    }

    public DSCCommentBeginResource(PSResource resource, int min2, int max) {
        this.resource = resource;
        this.min = new Integer(min2);
        this.max = new Integer(max);
    }

    public PSResource getResource() {
        return this.resource;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public String getName() {
        return "BeginResource";
    }

    public boolean hasValues() {
        return true;
    }

    public void parseValue(String value) {
        List params = this.splitParams(value);
        Iterator iter = params.iterator();
        String name = (String)iter.next();
        if ("font".equals(name)) {
            String fontname = (String)iter.next();
            this.resource = new PSResource(name, fontname);
        } else if ("procset".equals(name)) {
            String procname = (String)iter.next();
            String version = (String)iter.next();
            String revision = (String)iter.next();
            this.resource = new PSProcSet(procname, Float.parseFloat(version), Integer.parseInt(revision));
        } else if ("file".equals(name)) {
            String filename = (String)iter.next();
            this.resource = new PSResource(name, filename);
        } else {
            throw new IllegalArgumentException("Invalid resource type: " + name);
        }
    }

    public void generate(PSGenerator gen) throws IOException {
        if (this.getMin() != null) {
            Object[] params = new Object[]{this.getResource(), this.getMin(), this.getMax()};
            gen.writeDSCComment(this.getName(), params);
        } else {
            gen.writeDSCComment(this.getName(), this.getResource());
        }
    }
}

