/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PlexusTools {
    public static PlexusConfiguration buildConfiguration(String resourceName, Reader configuration) throws PlexusConfigurationException {
        try {
            return new XmlPlexusConfiguration(Xpp3DomBuilder.build(configuration));
        }
        catch (XmlPullParserException e) {
            throw new PlexusConfigurationException("Failed to parse configuration resource: '" + resourceName + "'\nError was: '" + e.getLocalizedMessage() + "'", e);
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("IO error building configuration from: " + resourceName, e);
        }
    }

    public static PlexusConfiguration buildConfiguration(String configuration) throws PlexusConfigurationException {
        return PlexusTools.buildConfiguration("<String Memory Resource>", new StringReader(configuration));
    }

    public static ComponentDescriptor buildComponentDescriptor(String configuration) throws PlexusConfigurationException {
        return PlexusTools.buildComponentDescriptor(PlexusTools.buildConfiguration(configuration));
    }

    public static ComponentDescriptor buildComponentDescriptor(PlexusConfiguration configuration) throws PlexusConfigurationException {
        ComponentDescriptor cd2 = new ComponentDescriptor();
        cd2.setRole(configuration.getChild("role").getValue());
        cd2.setRoleHint(configuration.getChild("role-hint").getValue());
        cd2.setImplementation(configuration.getChild("implementation").getValue());
        cd2.setVersion(configuration.getChild("version").getValue());
        cd2.setComponentType(configuration.getChild("component-type").getValue());
        cd2.setInstantiationStrategy(configuration.getChild("instantiation-strategy").getValue());
        cd2.setLifecycleHandler(configuration.getChild("lifecycle-handler").getValue());
        cd2.setComponentProfile(configuration.getChild("component-profile").getValue());
        cd2.setComponentComposer(configuration.getChild("component-composer").getValue());
        cd2.setComponentConfigurator(configuration.getChild("component-configurator").getValue());
        cd2.setComponentFactory(configuration.getChild("component-factory").getValue());
        cd2.setDescription(configuration.getChild("description").getValue());
        cd2.setAlias(configuration.getChild("alias").getValue());
        String s2 = configuration.getChild("isolated-realm").getValue();
        if (s2 != null) {
            cd2.setIsolatedRealm(s2.equals("true"));
        }
        cd2.setConfiguration(configuration.getChild("configuration"));
        PlexusConfiguration[] requirements = configuration.getChild("requirements").getChildren("requirement");
        for (int i = 0; i < requirements.length; ++i) {
            PlexusConfiguration requirement = requirements[i];
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("role").getValue());
            cr.setRoleHint(requirement.getChild("role-hint").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            cd2.addRequirement(cr);
        }
        return cd2;
    }

    public static ComponentSetDescriptor buildComponentSet(PlexusConfiguration c) throws PlexusConfigurationException {
        ComponentSetDescriptor csd = new ComponentSetDescriptor();
        PlexusConfiguration[] components = c.getChild("components").getChildren("component");
        for (int i = 0; i < components.length; ++i) {
            PlexusConfiguration component = components[i];
            csd.addComponentDescriptor(PlexusTools.buildComponentDescriptor(component));
        }
        PlexusConfiguration[] dependencies = c.getChild("dependencies").getChildren("dependency");
        for (int i = 0; i < dependencies.length; ++i) {
            PlexusConfiguration d = dependencies[i];
            ComponentDependency cd2 = new ComponentDependency();
            cd2.setArtifactId(d.getChild("artifact-id").getValue());
            cd2.setGroupId(d.getChild("group-id").getValue());
            String type = d.getChild("type").getValue();
            if (type != null) {
                cd2.setType(type);
            }
            cd2.setVersion(d.getChild("version").getValue());
            csd.addDependency(cd2);
        }
        return csd;
    }
}

