/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

class CodePrinter {
    private static final int LITERAL_CHAR_MAX_SIZE = 6;
    private String lineTerminator = "\n";
    private int indentStep = 4;
    private int indentTabSize = 8;
    private char[] buffer = new char[4096];
    private int offset;

    CodePrinter() {
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public void setLineTerminator(String string) {
        this.lineTerminator = string;
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int n) {
        this.indentStep = n;
    }

    public int getIndentTabSize() {
        return this.indentTabSize;
    }

    public void setIndentTabSize(int n) {
        this.indentTabSize = n;
    }

    public void clear() {
        this.offset = 0;
    }

    private int ensure_area(int n) {
        int n2 = this.offset;
        int n3 = n2 + n;
        if (n3 > this.buffer.length) {
            int n4 = this.buffer.length * 2;
            if (n3 > n4) {
                n4 = n3;
            }
            char[] cArray = new char[n4];
            System.arraycopy(this.buffer, 0, cArray, 0, n2);
            this.buffer = cArray;
        }
        return n2;
    }

    private int add_area(int n) {
        int n2 = this.ensure_area(n);
        this.offset = n2 + n;
        return n2;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLastChar() {
        return this.offset == 0 ? -1 : this.buffer[this.offset - 1];
    }

    public void p(char c) {
        int n = this.add_area(1);
        this.buffer[n] = c;
    }

    public void p(String string) {
        int n = string.length();
        int n2 = this.add_area(n);
        string.getChars(0, n, this.buffer, n2);
    }

    public final void p(char[] cArray) {
        this.p(cArray, 0, cArray.length);
    }

    public void p(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.add_area(n3);
        System.arraycopy(cArray, n, this.buffer, n4, n3);
    }

    public void p(int n) {
        this.p(Integer.toString(n));
    }

    public void qchar(int n) {
        int n2 = this.ensure_area(8);
        this.buffer[n2] = 39;
        n2 = this.put_string_literal_char(n2 + 1, n, false);
        this.buffer[n2] = 39;
        this.offset = n2 + 1;
    }

    public void qstring(String string) {
        int n = string.length();
        int n2 = this.ensure_area(2 + 6 * n);
        this.buffer[n2] = 34;
        ++n2;
        for (int i = 0; i != n; ++i) {
            n2 = this.put_string_literal_char(n2, string.charAt(i), true);
        }
        this.buffer[n2] = 34;
        this.offset = n2 + 1;
    }

    private int put_string_literal_char(int n, int n2, boolean bl) {
        boolean bl2 = true;
        switch (n2) {
            case 8: {
                n2 = 98;
                break;
            }
            case 9: {
                n2 = 116;
                break;
            }
            case 10: {
                n2 = 110;
                break;
            }
            case 12: {
                n2 = 102;
                break;
            }
            case 13: {
                n2 = 114;
                break;
            }
            case 39: {
                bl2 = !bl;
                break;
            }
            case 34: {
                bl2 = bl;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            this.buffer[n] = 92;
            this.buffer[n + 1] = (char)n2;
            n += 2;
        } else if (32 <= n2 && n2 <= 126) {
            this.buffer[n] = (char)n2;
            ++n;
        } else {
            this.buffer[n] = 92;
            this.buffer[n + 1] = 117;
            this.buffer[n + 2] = CodePrinter.digit_to_hex_letter(0xF & n2 >> 12);
            this.buffer[n + 3] = CodePrinter.digit_to_hex_letter(0xF & n2 >> 8);
            this.buffer[n + 4] = CodePrinter.digit_to_hex_letter(0xF & n2 >> 4);
            this.buffer[n + 5] = CodePrinter.digit_to_hex_letter(0xF & n2);
            n += 6;
        }
        return n;
    }

    private static char digit_to_hex_letter(int n) {
        return (char)(n < 10 ? 48 + n : 55 + n);
    }

    public void indent(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.indentStep * n;
        if (this.indentTabSize <= 0) {
            n4 = 0;
            n3 = n5;
        } else {
            n4 = n5 / this.indentTabSize;
            n3 = n4 + n5 % this.indentTabSize;
        }
        int n6 = n2 + n4;
        int n7 = n2 + n3;
        for (n2 = this.add_area(n3); n2 != n6; ++n2) {
            this.buffer[n2] = 9;
        }
        while (n2 != n7) {
            this.buffer[n2] = 32;
            ++n2;
        }
    }

    public void nl() {
        this.p('\n');
    }

    public void line(int n, String string) {
        this.indent(n);
        this.p(string);
        this.nl();
    }

    public void erase(int n, int n2) {
        System.arraycopy(this.buffer, n2, this.buffer, n, this.offset - n2);
        this.offset -= n2 - n;
    }

    public String toString() {
        return new String(this.buffer, 0, this.offset);
    }
}

