/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.SmlFile;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.transport.Crc16;
import org.openmuc.jsml.transport.MessageExtractor;

public class Transport {
    private int timeout = 30000;

    public void send(DataOutputStream os, byte[] smlPackage) throws IOException {
        int numStuffBits;
        ByteArrayOutputStream bs = new ByteArrayOutputStream(smlPackage.length + 30);
        DataOutputStream dataByteArrayOutputStream = new DataOutputStream(bs);
        Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1B1B1B1BL);
        Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1010101L);
        int numEscapeSeqFound = 0;
        for (int i = 0; i < smlPackage.length; i += 4) {
            if (i >= smlPackage.length - 3) {
                for (int j = i; j < smlPackage.length; ++j) {
                    dataByteArrayOutputStream.write(smlPackage[j]);
                }
                break;
            }
            if ((smlPackage[i] & 0xFF) == 27 && (smlPackage[i + 1] & 0xFF) == 27 && (smlPackage[i + 2] & 0xFF) == 27 && (smlPackage[i + 3] & 0xFF) == 27) {
                Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1B1B1B1BL);
                ++numEscapeSeqFound;
            }
            for (int k = 0; k < 4; ++k) {
                dataByteArrayOutputStream.writeByte(smlPackage[i + k]);
            }
        }
        if ((numStuffBits = 4 - (smlPackage.length + numEscapeSeqFound * 4) % 4) == 4) {
            numStuffBits = 0;
        }
        for (int i = 0; i < numStuffBits; ++i) {
            dataByteArrayOutputStream.writeByte(0);
        }
        Transport.writeUnsignedInt(dataByteArrayOutputStream, 0x1B1B1B1BL);
        dataByteArrayOutputStream.writeByte(26);
        dataByteArrayOutputStream.writeByte(numStuffBits & 0xFF);
        byte[] packet = bs.toByteArray();
        int crc16 = Crc16.check(packet);
        os.write(packet);
        os.writeShort(crc16 & 0xFFFF);
        os.flush();
        dataByteArrayOutputStream.close();
        bs.close();
    }

    public SmlFile getSMLFile(DataInputStream is) throws IOException {
        MessageExtractor extractor = new MessageExtractor(is, this.timeout);
        return this.handleSMLStream(extractor.getSmlMessage());
    }

    private SmlFile handleSMLStream(byte[] smlPacket) throws IOException {
        try (DataInputStream is = new DataInputStream(new ByteArrayInputStream(smlPacket));){
            SmlFile smlFile = new SmlFile();
            while (is.available() > 0) {
                SmlMessage message = new SmlMessage();
                if (!message.decode(is)) {
                    throw new IOException("Could not decode message");
                }
                smlFile.add(message);
            }
            SmlFile smlFile2 = smlFile;
            return smlFile2;
        }
    }

    private static void writeUnsignedInt(DataOutputStream os, long value) throws IOException {
        os.writeByte((int)((value & 0xFF000000L) >> 24));
        os.writeByte((int)((value & 0xFF0000L) >> 16));
        os.writeByte((int)((value & 0xFF00L) >> 8));
        os.writeByte((int)(value & 0xFFL));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

