/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import com.hastobe.transparenzsoftware.gui.Colors;
import com.hastobe.transparenzsoftware.gui.listeners.SelectBoxChangedListener;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EncodingTypePanel
extends JPanel {
    private static final String TEXT_ENCODING = "app.view.encoding";
    private static final String TEXT_TYPE = "app.view.format";
    private final JComboBox chooserEncoding;
    private final JLabel labelEncoding;
    private final JLabel labelType;
    private final JLabel chooserType;
    VerificationType actualType = VerificationType.UNKNOWN;

    public EncodingTypePanel(SelectBoxChangedListener selectBoxChangedListener) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.labelEncoding = new JLabel(Translator.get(TEXT_ENCODING));
        this.labelEncoding.setForeground(Colors.ENCODING_LABEL);
        this.chooserEncoding = new JComboBox();
        this.labelType = new JLabel(Translator.get(TEXT_TYPE));
        this.labelType.setForeground(Colors.TYPE_LABEL);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.labelType, gbc);
        this.chooserType = new JLabel();
        this.setType();
        gbc.fill = 2;
        gbc.ipady = 0;
        gbc.weighty = 1.0;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        this.add((Component)this.chooserType, gbc);
    }

    public void setEncoding(EncodingType encoding) {
        this.chooserEncoding.setSelectedItem((Object)encoding);
    }

    public void setVerificationType(VerificationType type) {
        this.actualType = type;
        this.setType();
    }

    private void setType() {
        switch (this.actualType) {
            case ALFEN: 
            case EDL_40_MENNEKES: 
            case EDL_40_P: 
            case EDL_40_SIG: 
            case ISA_EDL_40_P: 
            case OCMF: 
            case PCDF: {
                this.chooserType.setText(this.actualType.name());
                break;
            }
            default: {
                this.chooserType.setText(Translator.get("error.format.unknown"));
            }
        }
    }

    public VerificationType getVerificationType() {
        return this.actualType;
    }

    public EncodingType getEncoding() {
        return (EncodingType)((Object)this.chooserEncoding.getSelectedItem());
    }

    public void setEnabledFields(boolean b) {
        this.chooserEncoding.setEnabled(b);
        this.chooserType.setEnabled(b);
    }
}

