/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views.customelements;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = 8333875024682878518L;
    private String text;
    private URI uri;

    public LinkLabel(String text, String uri) {
        this(text, URI.create(uri));
    }

    public LinkLabel(String t, URI u) {
        this.text = t;
        this.uri = u;
        this.setText(this.text);
        this.setToolTipText(this.uri.toString());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LinkLabel.open(LinkLabel.this.uri);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setText(LinkLabel.this.text, false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setText(LinkLabel.this.text, true);
            }
        });
        Font font = this.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.setFont(font.deriveFont(attributes));
        this.setForeground(Color.BLUE);
    }

    @Override
    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean ul) {
        super.setText(text);
        this.text = text;
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Failed to launch the link, your computer is likely misconfigured.", "Cannot Launch Link", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Java is not able to launch links on your computer.", "Cannot Launch Link", 2);
        }
    }
}

