/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml.EDL40;

import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.format.sml.EDL40.EDL40Signature;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLConfig;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLSignature;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLUtils;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlListEntry;
import org.openmuc.jsml.structures.SmlListType;
import org.openmuc.jsml.structures.SmlMessage;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlTimestamp;
import org.openmuc.jsml.structures.SmlTimestampLocal;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.structures.responses.SmlPublicCloseRes;
import org.openmuc.jsml.structures.responses.SmlPublicOpenRes;
import org.openmuc.jsml.transport.MessageExtractor;

public class SMLReader {
    private static final Logger LOGGER = LogManager.getLogger(SMLReader.class);
    private static final String TYPE_CONTRACT_ID = "81 82 81 54 01 FF";
    private static final String TYPE_SIGNED_VALUE = "01 00 01 11 00 FF";
    private static final String TYPE_SIGNED_VALUE_2 = "01 00 01 08 00 FF";
    private static final String TYPE_PAGINATION = "81 80 81 71 01 FF";
    private static final String TYPE_MANUFACTURER_SPECIFIC = "81 80 81 61 01 FF";
    private static final String TYPE_SECONDS_INDEX = "81 00 60 08 00 01";

    private SMLSignature parseASNObject(ASNObject asnObject) throws ValidationException {
        EDL40Signature parsedSml = null;
        if (asnObject instanceof SmlPublicOpenRes) {
            SmlPublicOpenRes openRes = (SmlPublicOpenRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlPublicOpenRes message");
            }
        } else if (asnObject instanceof SmlGetListRes) {
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlGetListRes message");
            }
            parsedSml = new EDL40Signature();
            SmlGetListRes getListRes = (SmlGetListRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                this.showDebugInformation(getListRes);
            }
            parsedSml.setServerId(getListRes.getServerId().getValue());
            block16: for (SmlListEntry smlEntry : getListRes.getValList().getValListEntry()) {
                LOGGER.debug("verify smlEntry " + smlEntry.getObjName());
                if (smlEntry.getObjName() == null) {
                    LOGGER.warn("Entry without an asnObject name found");
                    continue;
                }
                switch (smlEntry.getObjName().toHexString()) {
                    case "81 82 81 54 01 FF": {
                        if (smlEntry.getValue().getChoice() instanceof OctetString) {
                            OctetString contractId = (OctetString)smlEntry.getValue().getChoice();
                            parsedSml.setContractId(contractId.getValue(), true);
                        }
                        if (!(smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal)) continue block16;
                        parsedSml.setTimestampContractId(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        continue block16;
                    }
                    case "01 00 01 11 00 FF": {
                        ASNObject statusChoice;
                        OctetString obisIDElement = smlEntry.getObjName();
                        parsedSml.setObisNr(obisIDElement.getValue());
                        Integer64 wh = (Integer64)smlEntry.getValue().getChoice();
                        parsedSml.setUnit(smlEntry.getUnit().getVal());
                        parsedSml.setScaler(smlEntry.getScaler().getVal());
                        parsedSml.setMeterPosition(wh.getVal());
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal) {
                            parsedSml.setTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        }
                        if (!((statusChoice = smlEntry.getStatus().getChoice()) instanceof Unsigned32)) continue block16;
                        parsedSml.setStatus(((Unsigned32)statusChoice).getVal());
                        continue block16;
                    }
                    case "01 00 01 08 00 FF": {
                        OctetString obisIDElement2 = smlEntry.getObjName();
                        parsedSml.setObisNr(obisIDElement2.getValue());
                        Integer64 wh2 = (Integer64)smlEntry.getValue().getChoice();
                        parsedSml.setUnit(smlEntry.getUnit().getVal());
                        parsedSml.setScaler(smlEntry.getScaler().getVal());
                        parsedSml.setMeterPosition(wh2.getVal());
                        if (smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal) {
                            parsedSml.setTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestampLocal)smlEntry.getValTime().getChoice()));
                        } else if (smlEntry.getValTime().getChoice() instanceof SmlTimestamp) {
                            parsedSml.setTimestamp(SMLUtils.parseSmlTimestamp((SmlTimestamp)smlEntry.getValTime().getChoice()));
                        }
                        Unsigned32 secondsIndex2 = new Unsigned32(708606L);
                        parsedSml.setSecondsIndex(secondsIndex2.getVal());
                        Unsigned32 paginationData2 = new Unsigned32(10L);
                        parsedSml.setPagination(paginationData2.getVal());
                        ASNObject statusChoice2 = smlEntry.getStatus().getChoice();
                        if (!(statusChoice2 instanceof Unsigned32)) continue block16;
                        parsedSml.setStatus(((Unsigned32)statusChoice2).getVal());
                        continue block16;
                    }
                    case "81 80 81 71 01 FF": {
                        if (smlEntry.getValue().getChoice() instanceof Unsigned32) {
                            Unsigned32 paginationData = (Unsigned32)smlEntry.getValue().getChoice();
                            parsedSml.setPagination(paginationData.getVal());
                            continue block16;
                        }
                        throw new SMLValidationException("pagination data does not contain a unsigned integer");
                    }
                    case "81 00 60 08 00 01": {
                        if (!(smlEntry.getValue().getChoice() instanceof SmlListType)) {
                            throw new SMLValidationException("Time data entry does not contain a smlListType");
                        }
                        SmlListType smlListType = (SmlListType)smlEntry.getValue().getChoice();
                        if (!(smlListType.getChoice() instanceof SmlTime)) {
                            throw new SMLValidationException("SmlListtype data does not contain a time entry");
                        }
                        SmlTime smlTime = (SmlTime)smlListType.getChoice();
                        if (!(smlTime.getChoice() instanceof Unsigned32)) {
                            throw new SMLValidationException("SmlTime dose not contain secondsIndex");
                        }
                        Unsigned32 secondsIndex = (Unsigned32)smlTime.getChoice();
                        parsedSml.setSecondsIndex(secondsIndex.getVal());
                        continue block16;
                    }
                    case "81 80 81 61 01 FF": {
                        continue block16;
                    }
                    default: {
                        LOGGER.warn("Unknown element " + smlEntry.getObjName().toHexString());
                    }
                }
            }
            byte[] originalSignature = getListRes.getListSignature().getValue();
            parsedSml.setBytesLog(originalSignature[originalSignature.length - 2], originalSignature[originalSignature.length - 1]);
            parsedSml.setProvidedSignature(originalSignature);
        } else if (asnObject instanceof SmlPublicCloseRes) {
            SmlPublicCloseRes closeRes = (SmlPublicCloseRes)asnObject;
            if (SMLConfig.DEBUG_SML_MESSAGES) {
                LOGGER.debug("Found SmlPublicCloseRes message");
            }
        } else {
            LOGGER.warn("Unknown sml object found: " + asnObject.getClass().getSimpleName());
        }
        return parsedSml;
    }

    private void showDebugInformation(SmlGetListRes getListRes) {
        LOGGER.debug("ServerID:\t" + getListRes.getServerId());
        LOGGER.debug("ListName:\t" + getListRes.getListName());
        LOGGER.debug("Signature:\t" + getListRes.getListSignature());
        SmlTime time = getListRes.getActSensorTime();
        LOGGER.debug("ActSensorTime:\t" + time.getChoice());
        for (SmlListEntry smlEntry : getListRes.getValList().getValListEntry()) {
            LOGGER.debug("------");
            LOGGER.debug("ObjName:\t" + smlEntry.getObjName());
            LOGGER.debug("Value:\t" + smlEntry.getValue());
            LOGGER.debug("Unit:\t" + smlEntry.getUnit());
            LOGGER.debug("Signature:\t" + smlEntry.getValueSignature());
            LOGGER.debug("Scaler:\t" + smlEntry.getScaler());
            LOGGER.debug("Status:\t" + smlEntry.getStatus().getChoice());
            if (smlEntry.getValTime() == null || !(smlEntry.getValTime().getChoice() instanceof SmlTimestampLocal)) continue;
            LOGGER.debug("Timestamp:\t" + ((SmlTimestampLocal)smlEntry.getValTime().getChoice()).getTimestamp());
        }
    }

    private SMLSignature parseRawSMLBytes(byte[] payloadBytes) throws IOException, ValidationException {
        MessageExtractor messageExtractor = this.createMessageExtractor(payloadBytes);
        DataInputStream smlFileDis = this.convertMessageExtractorToSmlMessages(messageExtractor);
        ArrayList<SmlMessage> messages = new ArrayList<SmlMessage>();
        while (smlFileDis.available() > 0) {
            SmlMessage message = new SmlMessage();
            message.decode(smlFileDis);
            messages.add(message);
            Object obj = message.getMessageBody().getChoice();
            SMLSignature SMLSignature2 = this.parseASNObject((ASNObject)obj);
            if (SMLSignature2 == null) continue;
            return SMLSignature2;
        }
        return null;
    }

    private DataInputStream convertMessageExtractorToSmlMessages(MessageExtractor messageExtractor) throws IOException {
        byte[] smlFile = messageExtractor.getSmlMessage();
        ByteArrayInputStream bais = new ByteArrayInputStream(smlFile);
        return new DataInputStream(bais);
    }

    private MessageExtractor createMessageExtractor(byte[] payloadBytes) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(payloadBytes));
        DataInputStream dis = new DataInputStream(bis);
        return new MessageExtractor(dis, 300L);
    }

    public SMLSignature parsePayloadData(byte[] smlData) throws ValidationException {
        try {
            SMLSignature smlSignature = this.parseRawSMLBytes(smlData);
            if (smlSignature == null) {
                throw new SMLValidationException("Could not read sml data incomplete data", "error.sml.incomplete");
            }
            smlSignature.isDataComplete();
            if (smlSignature.getUnit() != 30) {
                throw new SMLValidationException("Invalid unit present in sml data", "error.sml.invalid.unit");
            }
            return smlSignature;
        }
        catch (IOException e) {
            throw new SMLValidationException("Could not read sml data, invalid format", e);
        }
    }
}

