/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.gui.views.helper.DetailsList;
import com.hastobe.transparenzsoftware.i18n.Translator;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.RegulationLawException;
import com.hastobe.transparenzsoftware.verification.ValidationException;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes.EDLMennekesSignature;
import com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.ChargingProcess;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.OffsetDateTimeAdapter;
import com.hastobe.transparenzsoftware.verification.xml.VerifiedData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="verifiedData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EDLMennekesVerifiedData
extends VerifiedData {
    private VerificationType verificationType;
    private EncodingType encodingType;
    private String publicKey;
    private String serverId;
    private String contractId;
    private int secondIndexStart;
    private int secondIndexEnd;
    private String obisIdStart;
    private String obisIdEnd;
    private OffsetDateTime timestampContract;
    private String statusStart;
    private String statusEnd;
    private long eventCounterStart;
    private long eventCounterEnd;
    private int scalerStart;
    private int scalerEnd;
    private String signatureStart;
    private String signatureEnd;
    private int paginationStart;
    private int paginationEnd;
    private List<Meter> meters;
    private double meterStart;
    private double meterStop;

    public EDLMennekesVerifiedData() {
    }

    public EDLMennekesVerifiedData(ChargingProcess chargingProcess, EDLMennekesSignature start, EDLMennekesSignature stop) {
        this.verificationType = VerificationType.EDL_40_MENNEKES;
        this.encodingType = EncodingType.PLAIN;
        this.publicKey = Utils.clearString(chargingProcess.getPublicKey());
        this.serverId = chargingProcess.getServerId();
        this.contractId = chargingProcess.getCustomerIdent();
        this.meters = new ArrayList<Meter>();
        this.timestampContract = chargingProcess.getTimestampCustomerIdent();
        if (start != null) {
            this.meterStart = start.getMeterPositionAsLong();
            this.meterStart = this.meterStart != 0.0 ? this.meterStart * Math.pow(10.0, start.getScaler()) / 1000.0 : 0.0;
            this.meters.add(new Meter(this.meterStart, start.getTimestampAsDate(), Meter.Type.START, Meter.TimeSyncType.INFORMATIVE, start.getScaler()));
            this.obisIdStart = Utils.toFormattedHex(start.getObisNr());
            this.statusStart = Utils.toFormattedHex(start.getStatus());
            this.paginationStart = chargingProcess.getMeasurementStart().getPagination();
            this.scalerStart = chargingProcess.getMeasurementStart().getScaler();
            this.signatureStart = chargingProcess.getMeasurementStart().getSignature();
            this.secondIndexStart = chargingProcess.getMeasurementStart().getSecondIndex();
            this.eventCounterStart = chargingProcess.getMeasurementStart().getEventCounter();
        }
        if (stop != null) {
            this.meterStop = stop.getMeterPositionAsLong();
            this.meterStop = this.meterStop != 0.0 ? this.meterStop * Math.pow(10.0, stop.getScaler()) / 1000.0 : 0.0;
            this.meters.add(new Meter(this.meterStop, stop.getTimestampAsDate(), Meter.Type.STOP, Meter.TimeSyncType.INFORMATIVE, stop.getScaler()));
            this.obisIdEnd = Utils.toFormattedHex(stop.getObisNr());
            this.statusEnd = Utils.toFormattedHex(stop.getStatus());
            this.paginationEnd = chargingProcess.getMeasurementEnd().getPagination();
            this.scalerEnd = chargingProcess.getMeasurementEnd().getScaler();
            this.signatureEnd = chargingProcess.getMeasurementEnd().getSignature();
            this.secondIndexEnd = chargingProcess.getMeasurementEnd().getSecondIndex();
            this.eventCounterEnd = chargingProcess.getMeasurementStart().getEventCounter();
        }
    }

    @Override
    public List<Meter> getMeters() {
        return this.meters;
    }

    @Override
    public String getFormat() {
        return this.verificationType.name();
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getEncoding() {
        return this.encodingType.getCode();
    }

    @Override
    public DetailsList getAdditionalData() {
        DetailsList additionalData = new DetailsList();
        additionalData.put(Translator.get("app.verify.sml.customerId"), this.getContractId());
        additionalData.put(Translator.get("app.verify.sml.timestampCustomer"), OffsetDateTimeAdapter.formattedDateTime(this.getTimestampContract()));
        additionalData.put(Translator.get("app.verify.sml.serverId"), this.getServerId());
        additionalData.put(Translator.get("app.verify.sml.publicKey"), this.getPublicKey());
        String startString = Translator.get("app.verify.start");
        String endString = Translator.get("app.verify.end");
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.obisId"), startString), this.getObisIdStart());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.secondsIndex"), startString), this.getSecondIndexStart());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.status"), startString), this.getStatusStart());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.pagination"), startString), this.getPaginationStart());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.scaler"), startString), this.getScalerStart());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.signature"), startString), this.getSignatureStart());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.obisId"), endString), this.getObisIdEnd());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.secondsIndex"), endString), this.getSecondIndexEnd());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.status"), endString), this.getStatusEnd());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.pagination"), endString), this.getPaginationEnd());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.scaler"), endString), this.getScalerEnd());
        additionalData.put(String.format("%s (%s)", Translator.get("app.verify.sml.signature"), endString), this.getSignatureEnd());
        return additionalData;
    }

    @Override
    public boolean lawConform(VerifiedData stopValue) throws RegulationLawException, ValidationException {
        throw new ValidationException("EDL Mennekes transaction data can only be verified as one value", "app.verify.mennekes.law.conform.compare");
    }

    public boolean checkLawIntegrityForTransaction() throws RegulationLawException {
        if (this.getEventCounterStart() != this.getEventCounterEnd()) {
            throw new RegulationLawException("Event counter of start and stop differs", "app.verify.law.conform.eventcounter.differs");
        }
        if (this.getPaginationStart() >= this.getPaginationEnd()) {
            throw new RegulationLawException("Pagination is of start is higher or equal than the pagination of stop", "app.verify.law.conform.pagination.wrong");
        }
        if (this.getMeterStart() > this.getMeterStop()) {
            throw new RegulationLawException("Meter value of start is higher than meter value of stop", "app.verify.law.conform.meter.wrong");
        }
        return true;
    }

    public VerificationType getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(VerificationType verificationType) {
        this.verificationType = verificationType;
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getContractId() {
        return this.contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public int getSecondIndexStart() {
        return this.secondIndexStart;
    }

    public void setSecondIndexStart(int secondIndexStart) {
        this.secondIndexStart = secondIndexStart;
    }

    public int getSecondIndexEnd() {
        return this.secondIndexEnd;
    }

    public void setSecondIndexEnd(int secondIndexEnd) {
        this.secondIndexEnd = secondIndexEnd;
    }

    public String getObisIdStart() {
        return this.obisIdStart;
    }

    public void setObisIdStart(String obisIdStart) {
        this.obisIdStart = obisIdStart;
    }

    public String getObisIdEnd() {
        return this.obisIdEnd;
    }

    public void setObisIdEnd(String obisIdEnd) {
        this.obisIdEnd = obisIdEnd;
    }

    public String getStatusStart() {
        return this.statusStart;
    }

    public void setStatusStart(String statusStart) {
        this.statusStart = statusStart;
    }

    public String getStatusEnd() {
        return this.statusEnd;
    }

    public void setStatusEnd(String statusEnd) {
        this.statusEnd = statusEnd;
    }

    public int getScalerStart() {
        return this.scalerStart;
    }

    public void setScalerStart(int scalerStart) {
        this.scalerStart = scalerStart;
    }

    public int getScalerEnd() {
        return this.scalerEnd;
    }

    public void setScalerEnd(int scalerEnd) {
        this.scalerEnd = scalerEnd;
    }

    public String getSignatureStart() {
        return this.signatureStart;
    }

    public void setSignatureStart(String signatureStart) {
        this.signatureStart = signatureStart;
    }

    public String getSignatureEnd() {
        return this.signatureEnd;
    }

    public void setSignatureEnd(String signatureEnd) {
        this.signatureEnd = signatureEnd;
    }

    public int getPaginationStart() {
        return this.paginationStart;
    }

    public void setPaginationStart(int paginationStart) {
        this.paginationStart = paginationStart;
    }

    public int getPaginationEnd() {
        return this.paginationEnd;
    }

    public void setPaginationEnd(int paginationEnd) {
        this.paginationEnd = paginationEnd;
    }

    public OffsetDateTime getTimestampContract() {
        return this.timestampContract;
    }

    public void setTimestampContract(OffsetDateTime timestampContract) {
        this.timestampContract = timestampContract;
    }

    protected long getEventCounterStart() {
        return this.eventCounterStart;
    }

    protected void setEventCounterStart(long eventCounterStart) {
        this.eventCounterStart = eventCounterStart;
    }

    protected long getEventCounterEnd() {
        return this.eventCounterEnd;
    }

    protected void setEventCounterEnd(long eventCounterEnd) {
        this.eventCounterEnd = eventCounterEnd;
    }

    protected double getMeterStart() {
        return this.meterStart;
    }

    protected void setMeterStart(double meterStart) {
        this.meterStart = meterStart;
    }

    protected double getMeterStop() {
        return this.meterStop;
    }

    protected void setMeterStop(double meterStop) {
        this.meterStop = meterStop;
    }
}

