/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SMLSignature {
    public static final int SERVER_ID_OFFSET = 0;
    public static final int SERVER_ID_LENGTH = 10;
    public static final int TIMESTAMP_OFFSET = 10;
    public static final int TIMESTAMP_LENGTH = 4;
    public static final int STATUS_OFFSET = 14;
    public static final int SECONDS_INDEX_OFFSET = 15;
    public static final int SECONDS_INDEX_LENGTH = 4;
    public static final int PAGINATION_INDEX_OFFSET = 19;
    public static final int PAGINATION_INDEX_LENGTH = 4;
    public static final int OBIS_ID_OFFSET = 23;
    public static final int OBIS_ID_LENGTH = 6;
    public static final int UNIT_OFFSET = 29;
    public static final int SCALER_OFFSET = 30;
    public static final int METER_POSITION_OFFSET = 31;
    public static final int METER_POSITION_LENGTH = 8;
    public static final int LOGBUCH_OFFSET = 39;
    public static final int LOGBUCH_LENGTH = 2;
    public static final int CONTRACT_ID_OFFSET = 41;
    public static final int CONTRACT_ID_LENGTH = 128;
    public static final int CONTRACT_ID_TIMESTAMP_OFFSET = 169;
    public static final int CONTRACT_ID_TIMESTAMP_LENGTH = 4;
    public static final int RESERVED_BYTES_OFFSET = 173;
    public static final int RESERVED_BYTES_LENGTH = 147;
    public static final int LENGTH_SIGNATURE = 320;
    private static final Logger LOGGER = LogManager.getLogger(SMLSignature.class);
    private byte[] serverId;
    private byte status;
    private byte[] secondsIndex;
    private byte[] pagination;
    private byte[] obisNr;
    private byte unit;
    private byte scaler;
    private byte[] meterPosition;
    private byte[] bytesLog;
    private byte[] contractId;

    public byte[] getServerId() {
        return this.serverId;
    }

    public void setServerId(byte[] serverId) throws SMLValidationException {
        if (serverId.length != 10) {
            throw new SMLValidationException("Server Id was not 10 bytes long");
        }
        this.serverId = serverId;
    }

    public abstract byte[] getTimestamp();

    public abstract OffsetDateTime getTimestampAsDate();

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setStatus(int status) {
        this.status = (byte)(status & 0xFF);
    }

    public byte[] getObisNr() {
        return this.obisNr;
    }

    public void setObisNr(byte[] obisNr) throws SMLValidationException {
        if (obisNr.length != 6) {
            throw new SMLValidationException("Obis id was not 6 bytes long");
        }
        this.obisNr = obisNr;
    }

    public byte getUnit() {
        return this.unit;
    }

    public void setUnit(byte unit) {
        this.unit = unit;
    }

    public void setUnit(int unit) {
        this.unit = (byte)(unit & 0xFF);
    }

    public byte getScaler() {
        return this.scaler;
    }

    public void setScaler(byte scaler) {
        this.scaler = scaler;
    }

    public byte[] getMeterPosition() {
        return this.meterPosition;
    }

    public void setMeterPosition(byte[] meterPosition) throws SMLValidationException {
        this.setMeterPosition(meterPosition, true);
    }

    public void setMeterPosition(byte[] meterPosition, boolean reverse) throws SMLValidationException {
        if (meterPosition.length != 8) {
            throw new SMLValidationException("Meter position was not 89 bytes long");
        }
        this.meterPosition = reverse ? Utils.reverseByteOrder(meterPosition) : meterPosition;
    }

    public void setMeterPosition(long meterPosition) throws SMLValidationException {
        this.setMeterPosition(SMLSignature.longToBytes(meterPosition));
    }

    public long getMeterPositionAsLong() {
        return Utils.bytesToLong(Utils.reverseByteOrder(this.meterPosition));
    }

    public byte[] getBytesLog() {
        return this.bytesLog;
    }

    public void setBytesLog(byte[] bytesLog) throws SMLValidationException {
        if (bytesLog.length != 2) {
            throw new SMLValidationException("Logbook bytes not 2 bytes long");
        }
        this.bytesLog = bytesLog;
    }

    public void setBytesLog(byte lowByte, byte highByte) {
        this.bytesLog = new byte[]{lowByte, highByte};
    }

    public byte[] getContractId() {
        return this.contractId;
    }

    public void setContractId(byte[] contractId) throws SMLValidationException {
        this.setContractId(contractId, false);
    }

    public void setContractId(byte[] contractId, boolean fillUp) throws SMLValidationException {
        if (contractId.length < 128 && fillUp) {
            byte[] fillUpData = new byte[128];
            System.arraycopy(contractId, 0, fillUpData, 0, contractId.length);
            this.contractId = fillUpData;
        } else {
            if (fillUp && contractId.length > 128 || contractId.length != 128) {
                throw new SMLValidationException("base signature not 128 bytes long");
            }
            this.contractId = contractId;
        }
    }

    public void setSecondsIndex(int index) throws SMLValidationException {
        this.setSecondsIndex(Utils.reverseByteOrder(SMLSignature.intToBytes(index)));
    }

    public void setSecondsIndex(byte[] data) throws SMLValidationException {
        if (data.length != 4) {
            throw new SMLValidationException("Seconds index was not 4 bytes long");
        }
        this.secondsIndex = data;
    }

    public byte[] getSecondsIndex() {
        return this.secondsIndex;
    }

    public byte[] getPagination() {
        return this.pagination;
    }

    public void setPagination(byte[] pagination) throws SMLValidationException {
        if (pagination.length != 4) {
            throw new SMLValidationException("Pagination index was not 4 bytes long");
        }
        this.pagination = pagination;
    }

    public void setPagination(int pagination) throws SMLValidationException {
        this.setPagination(Utils.reverseByteOrder(SMLSignature.intToBytes(pagination)));
    }

    public abstract byte[] getTimestampContractId();

    public abstract OffsetDateTime getTimestampContractIdAsDate();

    public byte[] buildExtendedSignatureData() {
        byte[] signature = new byte[320];
        System.arraycopy(this.serverId, 0, signature, 0, 10);
        System.arraycopy(this.getTimestamp(), 0, signature, 10, 4);
        signature[14] = this.status;
        System.arraycopy(this.pagination, 0, signature, 19, 4);
        System.arraycopy(this.secondsIndex, 0, signature, 15, 4);
        System.arraycopy(this.obisNr, 0, signature, 23, 6);
        signature[29] = this.unit;
        signature[30] = (byte)(this.scaler & 0xFF);
        System.arraycopy(this.meterPosition, 0, signature, 31, 8);
        System.arraycopy(this.bytesLog, 0, signature, 39, 2);
        System.arraycopy(this.contractId, 0, signature, 41, 128);
        System.arraycopy(this.getTimestampContractId(), 0, signature, 169, 4);
        return signature;
    }

    private static byte[] longToBytes(long meterPosition) {
        return ByteBuffer.allocate(8).putLong(meterPosition).array();
    }

    protected static byte[] timeToBytes(int time) {
        return Utils.reverseByteOrder(SMLSignature.intToBytes(time));
    }

    protected static byte[] timeToBytes(OffsetDateTime dateTime) {
        int seconds = (int)(dateTime.toEpochSecond() + (long)dateTime.getOffset().getTotalSeconds());
        return SMLSignature.timeToBytes(seconds);
    }

    protected static byte[] intToBytes(int time) {
        int pos1 = time & 0xFF000000;
        int pos2 = time & 0xFF0000;
        int pos3 = time & 0xFF00;
        int pos4 = time & 0xFF;
        return new byte[]{(byte)(pos1 >>= 24), (byte)(pos2 >>= 16), (byte)(pos3 >>= 8), (byte)pos4};
    }

    public abstract byte[] getProvidedSignature();

    public boolean isDataComplete() throws SMLValidationException {
        if (this.getServerId() == null) {
            throw new SMLValidationException("SML field server id missing", "error.sml.missing.serverid");
        }
        if (this.getTimestamp() == null) {
            throw new SMLValidationException("SML field timestamp missing", "error.sml.missing.timestamp");
        }
        if (this.getSecondsIndex() == null) {
            throw new SMLValidationException("SML field seconds index missing", "error.sml.missing.secondsindex");
        }
        if (this.getPagination() == null) {
            throw new SMLValidationException("SML field pagination missing", "error.sml.missing.pagination");
        }
        if (this.getObisNr() == null) {
            throw new SMLValidationException("SML field obis id missing", "error.sml.missing.obisnr");
        }
        if (this.getMeterPosition() == null) {
            throw new SMLValidationException("SML field meter position missing", "error.sml.missing.meterposition");
        }
        if (this.getBytesLog() == null) {
            throw new SMLValidationException("SML log bytes missing", "error.sml.missing.logbytes");
        }
        if (this.getContractId() == null) {
            throw new SMLValidationException("SML field contract id missing", "error.sml.missing.contractid");
        }
        if (this.getTimestampContractId() == null) {
            throw new SMLValidationException("SML field timestamp contract id missing", "error.sml.missing.timestampcontractid");
        }
        if (this.getProvidedSignature() == null) {
            throw new SMLValidationException("SML field signature", "error.sml.missing.signature");
        }
        return true;
    }
}

