/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.fop.util.DefaultErrorListener;
import org.apache.fop.util.QName;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AreaTreeParser {
    protected static Log log = LogFactory.getLog(AreaTreeParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    static /* synthetic */ Class class$org$apache$fop$area$RegionViewport;
    static /* synthetic */ Class class$org$apache$fop$area$BodyRegion;
    static /* synthetic */ Class class$org$apache$fop$area$BlockParent;
    static /* synthetic */ Class class$org$apache$fop$area$inline$AbstractTextArea;
    static /* synthetic */ Class class$org$apache$fop$area$inline$Viewport;
    static /* synthetic */ Class class$org$apache$fop$area$RegionReference;
    static /* synthetic */ Class class$org$apache$fop$area$NormalFlow;
    static /* synthetic */ Class class$org$apache$fop$area$Footnote;
    static /* synthetic */ Class class$org$apache$fop$area$BeforeFloat;
    static /* synthetic */ Class class$org$apache$fop$area$Block;
    static /* synthetic */ Class class$org$apache$fop$area$LineArea;
    static /* synthetic */ Class class$org$apache$fop$area$inline$InlineArea;
    static /* synthetic */ Class class$org$apache$fop$area$inline$InlineParent;
    static /* synthetic */ Class class$org$apache$fop$area$inline$InlineBlockParent;
    static /* synthetic */ Class class$org$apache$fop$area$inline$TextArea;
    static /* synthetic */ Class class$org$apache$fop$area$inline$ForeignObject;
    static /* synthetic */ Class class$org$apache$fop$area$BookmarkData;
    static /* synthetic */ Class class$org$apache$fop$area$DestinationData;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$org$apache$fop$area$Trait$InternalLink;
    static /* synthetic */ Class class$org$apache$fop$area$Trait$Background;
    static /* synthetic */ Class class$org$apache$fop$traits$BorderProps;

    public void parse(Source src, AreaTreeModel treeModel, FOUserAgent userAgent) throws TransformerException {
        Transformer transformer = tFactory.newTransformer();
        transformer.setErrorListener(new DefaultErrorListener(log));
        SAXResult res = new SAXResult(this.getContentHandler(treeModel, userAgent));
        transformer.transform(src, res);
    }

    public ContentHandler getContentHandler(AreaTreeModel treeModel, FOUserAgent userAgent) {
        ElementMappingRegistry elementMappingRegistry = userAgent.getFactory().getElementMappingRegistry();
        return new Handler(treeModel, userAgent, elementMappingRegistry);
    }

    private static class Handler
    extends DefaultHandler {
        private Map makers = new HashMap();
        private AreaTreeModel treeModel;
        private FOUserAgent userAgent;
        private ElementMappingRegistry elementMappingRegistry;
        private Attributes lastAttributes;
        private StringBuffer content = new StringBuffer();
        private PageViewport currentPageViewport;
        private Map pageViewportsByKey = new HashMap();
        private Set idFirstsAssigned = new HashSet();
        private Stack areaStack = new Stack();
        private boolean firstFlow;
        private Stack delegateStack = new Stack();
        private ContentHandler delegate;
        private DOMImplementation domImplementation;
        private static final Object[] SUBSET_COMMON = new Object[]{Trait.PROD_ID};
        private static final Object[] SUBSET_LINK = new Object[]{Trait.INTERNAL_LINK, Trait.EXTERNAL_LINK};
        private static final Object[] SUBSET_COLOR = new Object[]{Trait.BACKGROUND, Trait.COLOR};
        private static final Object[] SUBSET_FONT = new Object[]{Trait.FONT, Trait.FONT_SIZE, Trait.BLINK, Trait.OVERLINE, Trait.OVERLINE_COLOR, Trait.LINETHROUGH, Trait.LINETHROUGH_COLOR, Trait.UNDERLINE, Trait.UNDERLINE_COLOR};
        private static final Object[] SUBSET_BOX = new Object[]{Trait.BORDER_BEFORE, Trait.BORDER_AFTER, Trait.BORDER_START, Trait.BORDER_END, Trait.SPACE_BEFORE, Trait.SPACE_AFTER, Trait.SPACE_START, Trait.SPACE_END, Trait.PADDING_BEFORE, Trait.PADDING_AFTER, Trait.PADDING_START, Trait.PADDING_END, Trait.START_INDENT, Trait.END_INDENT, Trait.IS_REFERENCE_AREA, Trait.IS_VIEWPORT_AREA};

        public Handler(AreaTreeModel treeModel, FOUserAgent userAgent, ElementMappingRegistry elementMappingRegistry) {
            this.treeModel = treeModel;
            this.userAgent = userAgent;
            this.elementMappingRegistry = elementMappingRegistry;
            this.makers.put("areaTree", new AreaTreeMaker());
            this.makers.put("page", new PageMaker());
            this.makers.put("pageSequence", new PageSequenceMaker());
            this.makers.put("title", new TitleMaker());
            this.makers.put("pageViewport", new PageViewportMaker());
            this.makers.put("regionViewport", new RegionViewportMaker());
            this.makers.put("regionBefore", new RegionBeforeMaker());
            this.makers.put("regionAfter", new RegionAfterMaker());
            this.makers.put("regionStart", new RegionStartMaker());
            this.makers.put("regionEnd", new RegionEndMaker());
            this.makers.put("regionBody", new RegionBodyMaker());
            this.makers.put("flow", new FlowMaker());
            this.makers.put("mainReference", new MainReferenceMaker());
            this.makers.put("span", new SpanMaker());
            this.makers.put("footnote", new FootnoteMaker());
            this.makers.put("beforeFloat", new BeforeFloatMaker());
            this.makers.put("block", new BlockMaker());
            this.makers.put("lineArea", new LineAreaMaker());
            this.makers.put("inline", new InlineMaker());
            this.makers.put("inlineparent", new InlineParentMaker());
            this.makers.put("inlineblockparent", new InlineBlockParentMaker());
            this.makers.put("text", new TextMaker());
            this.makers.put("word", new WordMaker());
            this.makers.put("space", new SpaceMaker());
            this.makers.put("char", new CharMaker());
            this.makers.put("leader", new LeaderMaker());
            this.makers.put("viewport", new ViewportMaker());
            this.makers.put("image", new ImageMaker());
            this.makers.put("foreignObject", new ForeignObjectMaker());
            this.makers.put("bookmarkTree", new BookmarkTreeMaker());
            this.makers.put("bookmark", new BookmarkMaker());
            this.makers.put("destination", new DestinationMaker());
        }

        private static Rectangle2D parseRect(String rect) {
            StringTokenizer tokenizer = new StringTokenizer(rect, " ");
            return new Rectangle2D.Double(Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()));
        }

        private Area findAreaType(Class clazz) {
            if (this.areaStack.size() > 0) {
                int pos;
                Object obj = null;
                for (pos = this.areaStack.size() - 1; pos >= 0; --pos) {
                    Object e = this.areaStack.get(pos);
                    obj = e;
                    if (clazz.isInstance(e)) break;
                }
                if (pos >= 0) {
                    return obj;
                }
            }
            return null;
        }

        private RegionViewport getCurrentRegionViewport() {
            return (RegionViewport)this.findAreaType(class$org$apache$fop$area$RegionViewport == null ? (class$org$apache$fop$area$RegionViewport = AreaTreeParser.class$("org.apache.fop.area.RegionViewport")) : class$org$apache$fop$area$RegionViewport);
        }

        private BodyRegion getCurrentBodyRegion() {
            return (BodyRegion)this.findAreaType(class$org$apache$fop$area$BodyRegion == null ? (class$org$apache$fop$area$BodyRegion = AreaTreeParser.class$("org.apache.fop.area.BodyRegion")) : class$org$apache$fop$area$BodyRegion);
        }

        private BlockParent getCurrentBlockParent() {
            return (BlockParent)this.findAreaType(class$org$apache$fop$area$BlockParent == null ? (class$org$apache$fop$area$BlockParent = AreaTreeParser.class$("org.apache.fop.area.BlockParent")) : class$org$apache$fop$area$BlockParent);
        }

        private AbstractTextArea getCurrentText() {
            return (AbstractTextArea)this.findAreaType(class$org$apache$fop$area$inline$AbstractTextArea == null ? (class$org$apache$fop$area$inline$AbstractTextArea = AreaTreeParser.class$("org.apache.fop.area.inline.AbstractTextArea")) : class$org$apache$fop$area$inline$AbstractTextArea);
        }

        private Viewport getCurrentViewport() {
            return (Viewport)this.findAreaType(class$org$apache$fop$area$inline$Viewport == null ? (class$org$apache$fop$area$inline$Viewport = AreaTreeParser.class$("org.apache.fop.area.inline.Viewport")) : class$org$apache$fop$area$inline$Viewport);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                this.delegateStack.push(qName);
                this.delegate.startElement(uri, localName, qName, attributes);
            } else if (this.domImplementation != null) {
                TransformerHandler handler;
                try {
                    handler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException e) {
                    throw new SAXException("Error creating a new TransformerHandler", e);
                }
                Document doc = this.domImplementation.createDocument(uri, qName, null);
                doc.removeChild(doc.getDocumentElement());
                handler.setResult(new DOMResult(doc));
                Area parent = (Area)this.areaStack.peek();
                ((ForeignObject)parent).setDocument(doc);
                this.domImplementation = null;
                this.delegate = handler;
                this.delegateStack.push(qName);
                this.delegate.startDocument();
                this.delegate.startElement(uri, localName, qName, attributes);
            } else {
                this.lastAttributes = attributes;
                boolean handled = true;
                if ("".equals(uri)) {
                    Maker maker = (Maker)this.makers.get(localName);
                    if (maker != null) {
                        maker.startElement(attributes);
                    } else if (!"extension-attachments".equals(localName)) {
                        handled = false;
                    }
                } else {
                    ContentHandlerFactoryRegistry registry = this.userAgent.getFactory().getContentHandlerFactoryRegistry();
                    ContentHandlerFactory factory = registry.getFactory(uri);
                    if (factory != null) {
                        this.delegate = factory.createContentHandler();
                        this.delegateStack.push(qName);
                        this.delegate.startDocument();
                        this.delegate.startElement(uri, localName, qName, attributes);
                    } else {
                        handled = false;
                    }
                }
                if (!handled) {
                    if (uri == null || uri.length() == 0) {
                        throw new SAXException("Unhandled element " + localName + " in namespace: " + uri);
                    }
                    log.warn("Unhandled element " + localName + " in namespace: " + uri);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endElement(uri, localName, qName);
                this.delegateStack.pop();
                if (this.delegateStack.size() == 0) {
                    this.delegate.endDocument();
                    if (this.delegate instanceof ContentHandlerFactory.ObjectSource) {
                        Object obj = ((ContentHandlerFactory.ObjectSource)((Object)this.delegate)).getObject();
                        this.handleExternallyGeneratedObject(obj);
                    }
                    this.delegate = null;
                }
            } else {
                Maker maker;
                if ("".equals(uri) && (maker = (Maker)this.makers.get(localName)) != null) {
                    maker.endElement();
                }
                this.content.setLength(0);
            }
        }

        private void pushNewRegionReference(Attributes attributes, int side) {
            String regionName = attributes.getValue("name");
            RegionViewport rv = this.getCurrentRegionViewport();
            RegionReference reg = new RegionReference(side, regionName, rv);
            this.transferForeignObjects(attributes, reg);
            reg.setCTM(this.getAttributeAsCTM(attributes, "ctm"));
            this.setAreaAttributes(attributes, reg);
            rv.setRegionReference(reg);
            this.currentPageViewport.getPage().setRegionViewport(side, rv);
            this.areaStack.push(reg);
        }

        private void assertObjectOfClass(Object obj, Class clazz) {
            if (!clazz.isInstance(obj)) {
                throw new IllegalStateException("Object is not an instance of " + clazz.getName() + " but of " + obj.getClass().getName());
            }
        }

        protected void handleExternallyGeneratedObject(Object obj) {
            if (this.areaStack.size() == 0 && obj instanceof ExtensionAttachment) {
                ExtensionAttachment attachment = (ExtensionAttachment)obj;
                if (this.currentPageViewport == null) {
                    this.treeModel.handleOffDocumentItem(new OffDocumentExtensionAttachment(attachment));
                } else {
                    this.currentPageViewport.addExtensionAttachment(attachment);
                }
            } else {
                log.warn("Don't know how to handle externally generated object: " + obj);
            }
        }

        private void setAreaAttributes(Attributes attributes, Area area) {
            area.setIPD(Integer.parseInt(attributes.getValue("ipd")));
            area.setBPD(Integer.parseInt(attributes.getValue("bpd")));
        }

        private void setTraits(Attributes attributes, Area area, Object[] traitSubset) {
            int c = traitSubset.length;
            for (int i = 0; i < c; ++i) {
                String fontName;
                Object trait = traitSubset[i];
                String traitName = Trait.getTraitName(trait);
                String value = attributes.getValue(traitName);
                if (value != null) {
                    Class cl = Trait.getTraitClass(trait);
                    if (cl == (class$java$lang$Integer == null ? AreaTreeParser.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        area.addTrait(trait, new Integer(value));
                        continue;
                    }
                    if (cl == (class$java$lang$Boolean == null ? AreaTreeParser.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        area.addTrait(trait, Boolean.valueOf(value));
                        continue;
                    }
                    if (cl == (class$java$lang$String == null ? AreaTreeParser.class$("java.lang.String") : class$java$lang$String)) {
                        area.addTrait(trait, value);
                        if (trait != Trait.PROD_ID || this.idFirstsAssigned.contains(value) || this.currentPageViewport == null) continue;
                        this.currentPageViewport.setFirstWithID(value);
                        this.idFirstsAssigned.add(value);
                        continue;
                    }
                    if (cl == (class$java$awt$Color == null ? AreaTreeParser.class$("java.awt.Color") : class$java$awt$Color)) {
                        try {
                            area.addTrait(trait, ColorUtil.parseColorString(this.userAgent, value));
                            continue;
                        }
                        catch (PropertyException e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    if (cl == (class$org$apache$fop$area$Trait$InternalLink == null ? AreaTreeParser.class$("org.apache.fop.area.Trait$InternalLink") : class$org$apache$fop$area$Trait$InternalLink)) {
                        area.addTrait(trait, new Trait.InternalLink(value));
                        continue;
                    }
                    if (cl == (class$org$apache$fop$area$Trait$Background == null ? AreaTreeParser.class$("org.apache.fop.area.Trait$Background") : class$org$apache$fop$area$Trait$Background)) {
                        Trait.Background bkg = new Trait.Background();
                        try {
                            Color col = ColorUtil.parseColorString(this.userAgent, attributes.getValue("bkg-color"));
                            bkg.setColor(col);
                        }
                        catch (PropertyException e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                        String uri = attributes.getValue("bkg-img");
                        if (uri != null) {
                            bkg.setURL(uri);
                            try {
                                ImageManager manager = this.userAgent.getFactory().getImageManager();
                                ImageSessionContext sessionContext = this.userAgent.getImageSessionContext();
                                ImageInfo info = manager.getImageInfo(uri, sessionContext);
                                bkg.setImageInfo(info);
                            }
                            catch (Exception e) {
                                log.error("Background image not available: " + uri, e);
                            }
                            String repeat = attributes.getValue("bkg-repeat");
                            if (repeat != null) {
                                bkg.setRepeat(repeat);
                            }
                            bkg.setHoriz(this.getAttributeAsInteger(attributes, "bkg-horz-offset", 0));
                            bkg.setVertical(this.getAttributeAsInteger(attributes, "bkg-vert-offset", 0));
                        }
                        area.addTrait(trait, bkg);
                        continue;
                    }
                    if (cl != (class$org$apache$fop$traits$BorderProps == null ? AreaTreeParser.class$("org.apache.fop.traits.BorderProps") : class$org$apache$fop$traits$BorderProps)) continue;
                    area.addTrait(trait, BorderProps.valueOf(this.userAgent, value));
                    continue;
                }
                if (trait != Trait.FONT || (fontName = attributes.getValue("font-name")) == null) continue;
                String fontStyle = attributes.getValue("font-style");
                int fontWeight = this.getAttributeAsInteger(attributes, "font-weight", 400);
                area.addTrait(trait, FontInfo.createFontKey(fontName, fontStyle, fontWeight));
            }
        }

        private boolean getAttributeAsBoolean(Attributes attributes, String name, boolean defaultValue) {
            String s2 = attributes.getValue(name);
            if (s2 == null) {
                return defaultValue;
            }
            return Boolean.valueOf(s2);
        }

        private int getAttributeAsInteger(Attributes attributes, String name, int defaultValue) {
            String s2 = attributes.getValue(name);
            if (s2 == null) {
                return defaultValue;
            }
            return Integer.parseInt(s2);
        }

        private CTM getAttributeAsCTM(Attributes attributes, String name) {
            String s2 = attributes.getValue(name).trim();
            if (s2.startsWith("[") && s2.endsWith("]")) {
                s2 = s2.substring(1, s2.length() - 1);
                StringTokenizer tokenizer = new StringTokenizer(s2, " ");
                double[] values = new double[]{Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken())};
                return new CTM(values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            throw new IllegalArgumentException("CTM must be surrounded by square brackets");
        }

        private Rectangle2D getAttributeAsRectangle2D(Attributes attributes, String name) {
            String s2 = attributes.getValue(name).trim();
            StringTokenizer tokenizer = new StringTokenizer(s2, " ");
            double[] values = new double[]{Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken())};
            return new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
        }

        private void transferForeignObjects(Attributes atts, AreaTreeObject ato) {
            int c = atts.getLength();
            for (int i = 0; i < c; ++i) {
                String ns = atts.getURI(i);
                if (ns.length() <= 0 || "http://www.w3.org/2000/xmlns/".equals(ns)) continue;
                QName qname = new QName(ns, atts.getQName(i));
                ato.setForeignAttribute(qname, atts.getValue(i));
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
            } else {
                this.content.append(ch, start, length);
            }
        }

        private class DestinationMaker
        extends AbstractMaker {
            private DestinationMaker() {
            }

            public void startElement(Attributes attributes) {
                String[] linkdata = Trait.InternalLink.parseXMLAttribute(Handler.this.lastAttributes.getValue("internal-link"));
                PageViewport pv = (PageViewport)Handler.this.pageViewportsByKey.get(linkdata[0]);
                DestinationData dest = new DestinationData(linkdata[1]);
                ArrayList<PageViewport> pages = new ArrayList<PageViewport>();
                pages.add(pv);
                dest.resolveIDRef(linkdata[1], pages);
                Handler.this.areaStack.push(dest);
            }

            public void endElement() {
                Object tos = Handler.this.areaStack.pop();
                Handler.this.assertObjectOfClass(tos, class$org$apache$fop$area$DestinationData == null ? (class$org$apache$fop$area$DestinationData = AreaTreeParser.class$("org.apache.fop.area.DestinationData")) : class$org$apache$fop$area$DestinationData);
                Handler.this.treeModel.handleOffDocumentItem((DestinationData)tos);
            }
        }

        private class BookmarkMaker
        extends AbstractMaker {
            private BookmarkMaker() {
            }

            public void startElement(Attributes attributes) {
                String title = attributes.getValue("title");
                boolean showChildren = Handler.this.getAttributeAsBoolean(attributes, "show-children", false);
                String[] linkdata = Trait.InternalLink.parseXMLAttribute(attributes.getValue("internal-link"));
                PageViewport pv = (PageViewport)Handler.this.pageViewportsByKey.get(linkdata[0]);
                BookmarkData bm = new BookmarkData(title, showChildren, pv, linkdata[1]);
                Object tos = Handler.this.areaStack.peek();
                if (tos instanceof BookmarkData) {
                    BookmarkData parent = (BookmarkData)tos;
                    parent.addSubData(bm);
                }
                Handler.this.areaStack.push(bm);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$BookmarkData == null ? (class$org$apache$fop$area$BookmarkData = AreaTreeParser.class$("org.apache.fop.area.BookmarkData")) : class$org$apache$fop$area$BookmarkData);
            }
        }

        private class BookmarkTreeMaker
        extends AbstractMaker {
            private BookmarkTreeMaker() {
            }

            public void startElement(Attributes attributes) {
                BookmarkData bm = new BookmarkData();
                Handler.this.areaStack.push(bm);
            }

            public void endElement() {
                Object tos = Handler.this.areaStack.pop();
                Handler.this.assertObjectOfClass(tos, class$org$apache$fop$area$BookmarkData == null ? (class$org$apache$fop$area$BookmarkData = AreaTreeParser.class$("org.apache.fop.area.BookmarkData")) : class$org$apache$fop$area$BookmarkData);
                Handler.this.treeModel.handleOffDocumentItem((BookmarkData)tos);
            }
        }

        private class ForeignObjectMaker
        extends AbstractMaker {
            private ForeignObjectMaker() {
            }

            public void startElement(Attributes attributes) throws SAXException {
                String ns = attributes.getValue("ns");
                Handler.this.domImplementation = Handler.this.elementMappingRegistry.getDOMImplementationForNamespace(ns);
                if (Handler.this.domImplementation == null) {
                    throw new SAXException("No DOMImplementation could be identified to handle namespace: " + ns);
                }
                ForeignObject foreign = new ForeignObject(ns);
                Handler.this.transferForeignObjects(attributes, foreign);
                Handler.this.setAreaAttributes(attributes, foreign);
                Handler.this.setTraits(attributes, foreign, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(foreign);
                Handler.this.areaStack.push(foreign);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$inline$ForeignObject == null ? (class$org$apache$fop$area$inline$ForeignObject = AreaTreeParser.class$("org.apache.fop.area.inline.ForeignObject")) : class$org$apache$fop$area$inline$ForeignObject);
            }
        }

        private class ImageMaker
        extends AbstractMaker {
            private ImageMaker() {
            }

            public void startElement(Attributes attributes) {
                String url = attributes.getValue("url");
                Image image = new Image(url);
                Handler.this.transferForeignObjects(attributes, image);
                Handler.this.setAreaAttributes(attributes, image);
                Handler.this.setTraits(attributes, image, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(image);
            }
        }

        private class ViewportMaker
        extends AbstractMaker {
            private ViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                Viewport viewport = new Viewport(null);
                Handler.this.transferForeignObjects(attributes, viewport);
                Handler.this.setAreaAttributes(attributes, viewport);
                Handler.this.setTraits(attributes, viewport, SUBSET_COMMON);
                Handler.this.setTraits(attributes, viewport, SUBSET_BOX);
                Handler.this.setTraits(attributes, viewport, SUBSET_COLOR);
                viewport.setContentPosition(Handler.this.getAttributeAsRectangle2D(attributes, "pos"));
                viewport.setClip(Handler.this.getAttributeAsBoolean(attributes, "clip", false));
                viewport.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(viewport);
                Handler.this.areaStack.push(viewport);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$inline$Viewport == null ? (class$org$apache$fop$area$inline$Viewport = AreaTreeParser.class$("org.apache.fop.area.inline.Viewport")) : class$org$apache$fop$area$inline$Viewport);
            }
        }

        private class LeaderMaker
        extends AbstractMaker {
            private LeaderMaker() {
            }

            public void startElement(Attributes attributes) {
                Leader leader = new Leader();
                Handler.this.transferForeignObjects(attributes, leader);
                Handler.this.setAreaAttributes(attributes, leader);
                Handler.this.setTraits(attributes, leader, SUBSET_COMMON);
                Handler.this.setTraits(attributes, leader, SUBSET_BOX);
                Handler.this.setTraits(attributes, leader, SUBSET_COLOR);
                Handler.this.setTraits(attributes, leader, SUBSET_FONT);
                leader.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                String ruleStyle = attributes.getValue("ruleStyle");
                if (ruleStyle != null) {
                    leader.setRuleStyle(ruleStyle);
                }
                leader.setRuleThickness(Handler.this.getAttributeAsInteger(attributes, "ruleThickness", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(leader);
            }

            public void endElement() {
            }
        }

        private class CharMaker
        extends AbstractMaker {
            private CharMaker() {
            }

            public void endElement() {
                String txt = Handler.this.content.toString();
                Character ch = new Character(txt.charAt(0));
                Handler.this.transferForeignObjects(Handler.this.lastAttributes, ch);
                Handler.this.setAreaAttributes(Handler.this.lastAttributes, ch);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_COMMON);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_BOX);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_COLOR);
                Handler.this.setTraits(Handler.this.lastAttributes, ch, SUBSET_FONT);
                ch.setOffset(Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "offset", 0));
                ch.setBaselineOffset(Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "baseline", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ch);
            }
        }

        private class SpaceMaker
        extends AbstractMaker {
            private SpaceMaker() {
            }

            public void endElement() {
                int offset = Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "offset", 0);
                String txt = Handler.this.content.toString();
                if (txt.length() > 0) {
                    boolean adjustable = Handler.this.getAttributeAsBoolean(Handler.this.lastAttributes, "adj", true);
                    SpaceArea space = new SpaceArea(txt.charAt(0), offset, adjustable);
                    AbstractTextArea text = Handler.this.getCurrentText();
                    space.setParentArea(text);
                    text.addChildArea(space);
                } else {
                    Space space = new Space();
                    Handler.this.setAreaAttributes(Handler.this.lastAttributes, space);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COMMON);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_BOX);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COLOR);
                    space.setOffset(offset);
                    Area parent = (Area)Handler.this.areaStack.peek();
                    parent.addChildArea(space);
                }
            }
        }

        private class WordMaker
        extends AbstractMaker {
            private WordMaker() {
            }

            private int[] toIntArray(String s2) {
                if (s2 == null || s2.length() == 0) {
                    return null;
                }
                StringTokenizer tokenizer = new StringTokenizer(s2, " ");
                ArrayList<Integer> values = new ArrayList<Integer>();
                while (tokenizer.hasMoreTokens()) {
                    values.add(new Integer(tokenizer.nextToken()));
                }
                int[] res = new int[values.size()];
                int c = res.length;
                for (int i = 0; i < c; ++i) {
                    res[i] = (Integer)values.get(i);
                }
                return res;
            }

            public void endElement() {
                int offset = Handler.this.getAttributeAsInteger(Handler.this.lastAttributes, "offset", 0);
                int[] letterAdjust = this.toIntArray(Handler.this.lastAttributes.getValue("letter-adjust"));
                String txt = Handler.this.content.toString();
                WordArea word = new WordArea(txt, offset, letterAdjust);
                AbstractTextArea text = Handler.this.getCurrentText();
                word.setParentArea(text);
                text.addChildArea(word);
            }
        }

        private class TextMaker
        extends AbstractMaker {
            private TextMaker() {
            }

            public void startElement(Attributes attributes) {
                if (Handler.this.getCurrentText() != null) {
                    throw new IllegalStateException("Current Text must be null");
                }
                TextArea text = new TextArea();
                Handler.this.setAreaAttributes(attributes, text);
                Handler.this.setTraits(attributes, text, SUBSET_COMMON);
                Handler.this.setTraits(attributes, text, SUBSET_BOX);
                Handler.this.setTraits(attributes, text, SUBSET_COLOR);
                Handler.this.setTraits(attributes, text, SUBSET_FONT);
                text.setBaselineOffset(Handler.this.getAttributeAsInteger(attributes, "baseline", 0));
                text.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                text.setTextLetterSpaceAdjust(Handler.this.getAttributeAsInteger(attributes, "tlsadjust", 0));
                text.setTextWordSpaceAdjust(Handler.this.getAttributeAsInteger(attributes, "twsadjust", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(text);
                Handler.this.areaStack.push(text);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$inline$TextArea == null ? (class$org$apache$fop$area$inline$TextArea = AreaTreeParser.class$("org.apache.fop.area.inline.TextArea")) : class$org$apache$fop$area$inline$TextArea);
            }
        }

        private class InlineBlockParentMaker
        extends AbstractMaker {
            private InlineBlockParentMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineBlockParent ibp = new InlineBlockParent();
                Handler.this.transferForeignObjects(attributes, ibp);
                ibp.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, ibp);
                Handler.this.setTraits(attributes, ibp, SUBSET_COMMON);
                Handler.this.setTraits(attributes, ibp, SUBSET_BOX);
                Handler.this.setTraits(attributes, ibp, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ibp);
                Handler.this.areaStack.push(ibp);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$inline$InlineBlockParent == null ? (class$org$apache$fop$area$inline$InlineBlockParent = AreaTreeParser.class$("org.apache.fop.area.inline.InlineBlockParent")) : class$org$apache$fop$area$inline$InlineBlockParent);
            }
        }

        private class InlineParentMaker
        extends AbstractMaker {
            private InlineParentMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineParent ip = new InlineParent();
                Handler.this.transferForeignObjects(attributes, ip);
                ip.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, ip);
                Handler.this.setTraits(attributes, ip, SUBSET_COMMON);
                Handler.this.setTraits(attributes, ip, SUBSET_BOX);
                Handler.this.setTraits(attributes, ip, SUBSET_COLOR);
                Handler.this.setTraits(attributes, ip, SUBSET_LINK);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ip);
                Handler.this.areaStack.push(ip);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$inline$InlineParent == null ? (class$org$apache$fop$area$inline$InlineParent = AreaTreeParser.class$("org.apache.fop.area.inline.InlineParent")) : class$org$apache$fop$area$inline$InlineParent);
            }
        }

        private class InlineMaker
        extends AbstractMaker {
            private InlineMaker() {
            }

            public void startElement(Attributes attributes) {
                InlineArea inl = new InlineArea();
                Handler.this.transferForeignObjects(attributes, inl);
                inl.setOffset(Handler.this.getAttributeAsInteger(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, inl);
                Handler.this.setTraits(attributes, inl, SUBSET_COMMON);
                Handler.this.setTraits(attributes, inl, SUBSET_BOX);
                Handler.this.setTraits(attributes, inl, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(inl);
                Handler.this.areaStack.push(inl);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$inline$InlineArea == null ? (class$org$apache$fop$area$inline$InlineArea = AreaTreeParser.class$("org.apache.fop.area.inline.InlineArea")) : class$org$apache$fop$area$inline$InlineArea);
            }
        }

        private class LineAreaMaker
        extends AbstractMaker {
            private LineAreaMaker() {
            }

            public void startElement(Attributes attributes) {
                LineArea line = new LineArea();
                Handler.this.setAreaAttributes(attributes, line);
                Handler.this.setTraits(attributes, line, SUBSET_COMMON);
                Handler.this.setTraits(attributes, line, SUBSET_BOX);
                Handler.this.setTraits(attributes, line, SUBSET_COLOR);
                BlockParent parent = Handler.this.getCurrentBlockParent();
                parent.addChildArea(line);
                Handler.this.areaStack.push(line);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$LineArea == null ? (class$org$apache$fop$area$LineArea = AreaTreeParser.class$("org.apache.fop.area.LineArea")) : class$org$apache$fop$area$LineArea);
            }
        }

        private class BlockMaker
        extends AbstractMaker {
            private BlockMaker() {
            }

            public void startElement(Attributes attributes) {
                Block block;
                boolean isViewport = Handler.this.getAttributeAsBoolean(attributes, "is-viewport-area", false);
                if (isViewport) {
                    BlockViewport bv = new BlockViewport();
                    bv.setClip(Handler.this.getAttributeAsBoolean(attributes, "clipped", false));
                    bv.setCTM(Handler.this.getAttributeAsCTM(attributes, "ctm"));
                    if (bv.getPositioning() != 1) {
                        bv.setXOffset(Handler.this.getAttributeAsInteger(attributes, "left-position", 0));
                        bv.setYOffset(Handler.this.getAttributeAsInteger(attributes, "top-position", 0));
                    }
                    block = bv;
                } else {
                    block = new Block();
                }
                String positioning = attributes.getValue("positioning");
                if ("absolute".equalsIgnoreCase(positioning)) {
                    block.setPositioning(2);
                } else if ("fixed".equalsIgnoreCase(positioning)) {
                    block.setPositioning(3);
                } else if ("relative".equalsIgnoreCase(positioning)) {
                    block.setPositioning(1);
                } else {
                    block.setPositioning(0);
                }
                if (attributes.getValue("left-offset") != null) {
                    block.setXOffset(Handler.this.getAttributeAsInteger(attributes, "left-offset", 0));
                }
                if (attributes.getValue("top-offset") != null) {
                    block.setYOffset(Handler.this.getAttributeAsInteger(attributes, "top-offset", 0));
                }
                Handler.this.transferForeignObjects(attributes, block);
                Handler.this.setAreaAttributes(attributes, block);
                Handler.this.setTraits(attributes, block, SUBSET_COMMON);
                Handler.this.setTraits(attributes, block, SUBSET_BOX);
                Handler.this.setTraits(attributes, block, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(block);
                Handler.this.areaStack.push(block);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$Block == null ? (class$org$apache$fop$area$Block = AreaTreeParser.class$("org.apache.fop.area.Block")) : class$org$apache$fop$area$Block);
            }
        }

        private class BeforeFloatMaker
        extends AbstractMaker {
            private BeforeFloatMaker() {
            }

            public void startElement(Attributes attributes) {
                BeforeFloat bf = Handler.this.getCurrentBodyRegion().getBeforeFloat();
                Handler.this.transferForeignObjects(attributes, bf);
                Handler.this.areaStack.push(bf);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$BeforeFloat == null ? (class$org$apache$fop$area$BeforeFloat = AreaTreeParser.class$("org.apache.fop.area.BeforeFloat")) : class$org$apache$fop$area$BeforeFloat);
            }
        }

        private class FootnoteMaker
        extends AbstractMaker {
            private FootnoteMaker() {
            }

            public void startElement(Attributes attributes) {
                Footnote fn = Handler.this.getCurrentBodyRegion().getFootnote();
                Handler.this.transferForeignObjects(attributes, fn);
                Handler.this.areaStack.push(fn);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$Footnote == null ? (class$org$apache$fop$area$Footnote = AreaTreeParser.class$("org.apache.fop.area.Footnote")) : class$org$apache$fop$area$Footnote);
            }
        }

        private class SpanMaker
        extends AbstractMaker {
            private SpanMaker() {
            }

            public void startElement(Attributes attributes) {
                int ipd = Handler.this.getAttributeAsInteger(attributes, "ipd", 0);
                int columnCount = Handler.this.getAttributeAsInteger(attributes, "columnCount", 1);
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                Span span = new Span(columnCount, body.getColumnGap(), ipd);
                Handler.this.transferForeignObjects(attributes, span);
                Handler.this.setAreaAttributes(attributes, span);
                body.getMainReference().getSpans().add(span);
                Handler.this.firstFlow = true;
            }
        }

        private class MainReferenceMaker
        extends AbstractMaker {
            private MainReferenceMaker() {
            }

            public void startElement(Attributes attributes) {
                MainReference mr = Handler.this.getCurrentBodyRegion().getMainReference();
                Handler.this.transferForeignObjects(attributes, mr);
                Handler.this.setAreaAttributes(attributes, mr);
            }
        }

        private class FlowMaker
        extends AbstractMaker {
            private FlowMaker() {
            }

            public void startElement(Attributes attributes) {
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                if (!Handler.this.firstFlow) {
                    body.getMainReference().getCurrentSpan().moveToNextFlow();
                } else {
                    Handler.this.firstFlow = false;
                }
                NormalFlow flow = body.getMainReference().getCurrentSpan().getCurrentFlow();
                Handler.this.transferForeignObjects(attributes, flow);
                Handler.this.setAreaAttributes(attributes, flow);
                Handler.this.areaStack.push(flow);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$NormalFlow == null ? (class$org$apache$fop$area$NormalFlow = AreaTreeParser.class$("org.apache.fop.area.NormalFlow")) : class$org$apache$fop$area$NormalFlow);
            }
        }

        private class RegionBodyMaker
        extends AbstractMaker {
            private RegionBodyMaker() {
            }

            public void startElement(Attributes attributes) {
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                if (body != null) {
                    throw new IllegalStateException("Current BodyRegion must be null");
                }
                String regionName = attributes.getValue("name");
                int columnCount = Handler.this.getAttributeAsInteger(attributes, "columnCount", 1);
                int columnGap = Handler.this.getAttributeAsInteger(attributes, "columnGap", 0);
                RegionViewport rv = Handler.this.getCurrentRegionViewport();
                body = new BodyRegion(36, regionName, rv, columnCount, columnGap);
                Handler.this.transferForeignObjects(attributes, body);
                body.setCTM(Handler.this.getAttributeAsCTM(attributes, "ctm"));
                Handler.this.setAreaAttributes(attributes, body);
                rv.setRegionReference(body);
                Handler.this.currentPageViewport.getPage().setRegionViewport(36, rv);
                Handler.this.areaStack.push(body);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$BodyRegion == null ? (class$org$apache$fop$area$BodyRegion = AreaTreeParser.class$("org.apache.fop.area.BodyRegion")) : class$org$apache$fop$area$BodyRegion);
            }
        }

        private class RegionEndMaker
        extends AbstractMaker {
            private RegionEndMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 37);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$RegionReference == null ? (class$org$apache$fop$area$RegionReference = AreaTreeParser.class$("org.apache.fop.area.RegionReference")) : class$org$apache$fop$area$RegionReference);
            }
        }

        private class RegionStartMaker
        extends AbstractMaker {
            private RegionStartMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 38);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$RegionReference == null ? (class$org$apache$fop$area$RegionReference = AreaTreeParser.class$("org.apache.fop.area.RegionReference")) : class$org$apache$fop$area$RegionReference);
            }
        }

        private class RegionAfterMaker
        extends AbstractMaker {
            private RegionAfterMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 34);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$RegionReference == null ? (class$org$apache$fop$area$RegionReference = AreaTreeParser.class$("org.apache.fop.area.RegionReference")) : class$org$apache$fop$area$RegionReference);
            }
        }

        private class RegionBeforeMaker
        extends AbstractMaker {
            private RegionBeforeMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 35);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$RegionReference == null ? (class$org$apache$fop$area$RegionReference = AreaTreeParser.class$("org.apache.fop.area.RegionReference")) : class$org$apache$fop$area$RegionReference);
            }
        }

        private class RegionViewportMaker
        extends AbstractMaker {
            private RegionViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                RegionViewport rv = Handler.this.getCurrentRegionViewport();
                if (rv != null) {
                    throw new IllegalStateException("Current RegionViewport must be null");
                }
                Rectangle2D viewArea = Handler.parseRect(attributes.getValue("rect"));
                rv = new RegionViewport(viewArea);
                Handler.this.transferForeignObjects(attributes, rv);
                rv.setClip(Handler.this.getAttributeAsBoolean(attributes, "clipped", false));
                Handler.this.setAreaAttributes(attributes, rv);
                Handler.this.setTraits(attributes, rv, SUBSET_COMMON);
                Handler.this.setTraits(attributes, rv, SUBSET_BOX);
                Handler.this.setTraits(attributes, rv, SUBSET_COLOR);
                Handler.this.areaStack.push(rv);
            }

            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), class$org$apache$fop$area$RegionViewport == null ? (class$org$apache$fop$area$RegionViewport = AreaTreeParser.class$("org.apache.fop.area.RegionViewport")) : class$org$apache$fop$area$RegionViewport);
            }
        }

        private class PageMaker
        extends AbstractMaker {
            private PageMaker() {
            }

            public void startElement(Attributes attributes) {
                Page p = new Page();
                Handler.this.currentPageViewport.setPage(p);
            }

            public void endElement() {
                Handler.this.treeModel.addPage(Handler.this.currentPageViewport);
                Handler.this.currentPageViewport = null;
            }
        }

        private class PageViewportMaker
        extends AbstractMaker {
            private PageViewportMaker() {
            }

            public void startElement(Attributes attributes) {
                if (!Handler.this.areaStack.isEmpty()) {
                    PageSequence pageSequence = (PageSequence)Handler.this.areaStack.peek();
                    Handler.this.treeModel.startPageSequence(pageSequence);
                    Handler.this.areaStack.pop();
                }
                if (Handler.this.currentPageViewport != null) {
                    throw new IllegalStateException("currentPageViewport must be null");
                }
                Rectangle2D viewArea = Handler.parseRect(attributes.getValue("bounds"));
                int pageNumber = Handler.this.getAttributeAsInteger(attributes, "nr", -1);
                String key = attributes.getValue("key");
                String pageNumberString = attributes.getValue("formatted-nr");
                String pageMaster = attributes.getValue("simple-page-master-name");
                boolean blank = Handler.this.getAttributeAsBoolean(attributes, "blank", false);
                Handler.this.currentPageViewport = new PageViewport(viewArea, pageNumber, pageNumberString, pageMaster, blank);
                Handler.this.transferForeignObjects(attributes, Handler.this.currentPageViewport);
                Handler.this.currentPageViewport.setKey(key);
                Handler.this.pageViewportsByKey.put(key, Handler.this.currentPageViewport);
            }
        }

        private class TitleMaker
        extends AbstractMaker {
            private TitleMaker() {
            }

            public void startElement(Attributes attributes) {
                LineArea line = new LineArea();
                Handler.this.transferForeignObjects(attributes, line);
                Handler.this.areaStack.push(line);
            }

            public void endElement() {
                LineArea line = (LineArea)Handler.this.areaStack.pop();
                PageSequence pageSequence = (PageSequence)Handler.this.areaStack.peek();
                pageSequence.setTitle(line);
            }
        }

        private class PageSequenceMaker
        extends AbstractMaker {
            private PageSequenceMaker() {
            }

            public void startElement(Attributes attributes) {
                PageSequence pageSequence = new PageSequence(null);
                String lang = attributes.getValue("language");
                pageSequence.setLanguage(lang);
                String country = attributes.getValue("country");
                pageSequence.setCountry(country);
                Handler.this.areaStack.push(pageSequence);
            }
        }

        private class AreaTreeMaker
        extends AbstractMaker {
            private AreaTreeMaker() {
            }

            public void startElement(Attributes attributes) {
                Handler.this.idFirstsAssigned.clear();
            }
        }

        private abstract class AbstractMaker
        implements Maker {
            private AbstractMaker() {
            }

            public void startElement(Attributes attributes) throws SAXException {
            }

            public void endElement() {
            }
        }

        private static interface Maker {
            public void startElement(Attributes var1) throws SAXException;

            public void endElement();
        }
    }
}

