/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class TableBody
extends TableCellContainer {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    protected boolean tableRowsFound = false;
    protected boolean tableCellsFound = false;
    private boolean firstRow = true;
    private boolean rowsStarted = false;
    private boolean lastCellEndsRow = true;
    private TableRow lastRow;
    private List rowGroups = new LinkedList();

    public TableBody(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        super.bind(pList);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList pList) throws FOPException {
        if (!this.inMarker()) {
            Table t = this.getTable();
            if (t.hasExplicitColumns()) {
                int size = t.getNumberOfColumns();
                this.pendingSpans = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    this.pendingSpans.add(null);
                }
            } else {
                this.pendingSpans = new ArrayList();
            }
            this.columnNumberManager = new ColumnNumberManager();
        }
        super.processNode(elementName, locator, attlist, pList);
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startBody(this);
    }

    public void endOfNode() throws FOPException {
        if (!this.inMarker()) {
            this.pendingSpans = null;
            this.columnNumberManager = null;
        }
        this.getFOEventHandler().endBody(this);
        if (!this.tableRowsFound && !this.tableCellsFound) {
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError("marker* (table-row+|table-cell+)");
            } else {
                log.error("fo:table-body must not be empty. Expected: marker* (table-row+|table-cell+)");
                this.getParent().removeChild(this);
            }
        } else {
            this.finishLastRowGroup();
        }
    }

    TableBody getTablePart() {
        return this;
    }

    protected void finishLastRowGroup() throws ValidationException {
        if (!this.inMarker()) {
            RowGroupBuilder rowGroupBuilder = this.getTable().getRowGroupBuilder();
            if (this.tableRowsFound) {
                rowGroupBuilder.endTableRow();
            } else if (!this.lastCellEndsRow) {
                rowGroupBuilder.endRow(this);
            }
            try {
                rowGroupBuilder.endTablePart();
            }
            catch (ValidationException e) {
                e.setLocator(this.locator);
                throw e;
            }
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.tableRowsFound || this.tableCellsFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(table-row+|table-cell+)");
                }
            } else if (localName.equals("table-row")) {
                this.tableRowsFound = true;
                if (this.tableCellsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else if (localName.equals("table-cell")) {
                this.tableCellsFound = true;
                if (this.tableRowsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (!this.inMarker()) {
            switch (child.getNameId()) {
                case 54: {
                    if (!this.rowsStarted) {
                        this.getTable().getRowGroupBuilder().startTablePart(this);
                    } else {
                        this.columnNumberManager.prepareForNextRow(this.pendingSpans);
                        this.getTable().getRowGroupBuilder().endTableRow();
                    }
                    this.rowsStarted = true;
                    this.lastRow = (TableRow)child;
                    this.getTable().getRowGroupBuilder().startTableRow(this.lastRow);
                    break;
                }
                case 50: {
                    if (!this.rowsStarted) {
                        this.getTable().getRowGroupBuilder().startTablePart(this);
                    }
                    this.rowsStarted = true;
                    TableCell cell = (TableCell)child;
                    this.addTableCellChild(cell, this.firstRow);
                    this.lastCellEndsRow = cell.endsRow();
                    if (!this.lastCellEndsRow) break;
                    this.firstRow = false;
                    this.columnNumberManager.prepareForNextRow(this.pendingSpans);
                    this.getTable().getRowGroupBuilder().endRow(this);
                    break;
                }
            }
        }
        super.addChildNode(child);
    }

    protected void setCollapsedBorders() {
        Table table = (Table)this.parent;
        this.createBorder(2, table);
        this.createBorder(3, table);
        this.createBorder(0);
        this.createBorder(1);
    }

    void addRowGroup(List rowGroup) {
        this.rowGroups.add(rowGroup);
    }

    public List getRowGroups() {
        return this.rowGroups;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-body";
    }

    public int getNameId() {
        return 48;
    }

    protected boolean isTableHeader() {
        return false;
    }

    protected boolean isTableFooter() {
        return false;
    }

    public boolean isFirst(TableRow obj) {
        return this.firstChild == null || this.firstChild == obj;
    }

    void signalNewRow() {
        if (this.rowsStarted) {
            this.firstRow = false;
            if (!this.lastCellEndsRow) {
                this.columnNumberManager.prepareForNextRow(this.pendingSpans);
                this.getTable().getRowGroupBuilder().endRow(this);
            }
        }
    }
}

