/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.itext;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.DocRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.itext.DefaultPdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.doxia.module.itext.ITextSink;
import org.apache.maven.doxia.module.itext.ITextSinkFactory;
import org.apache.maven.doxia.module.itext.ITextUtil;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.apache.maven.doxia.parser.module.ParserModuleManager;
import org.apache.xml.utils.DefaultErrorHandler;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractITextRender
extends AbstractLogEnabled
implements DocRenderer {
    private static final String XSLT_RESOURCE = "org/apache/maven/doxia/docrenderer/pdf/itext/TOC.xslt";
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    protected ParserModuleManager parserModuleManager;
    protected Doxia doxia;

    private List<String> getModuleFileNames(ParserModule module, File moduleBasedir) throws IOException {
        StringBuilder includes = new StringBuilder();
        for (String extension : module.getExtensions()) {
            if (includes.length() > 0) {
                includes.append(',');
            }
            includes.append("**/*.");
            includes.append(extension);
        }
        return FileUtils.getFileNames(moduleBasedir, includes.toString(), null, false);
    }

    @Override
    public void render(File siteDirectory, File outputDirectory) throws DocumentRendererException, IOException {
        Collection<ParserModule> modules = this.parserModuleManager.getParserModules();
        for (ParserModule module : modules) {
            File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List<String> docs = this.getModuleFileNames(module, moduleBasedir);
            for (String doc : docs) {
                String iTextOutputName;
                File iTextOutputFile;
                String fullPathDoc = new File(moduleBasedir, doc).getPath();
                String outputITextName = doc.substring(0, doc.indexOf(46) + 1) + "xml";
                File outputITextFile = new File(outputDirectory, outputITextName);
                if (!outputITextFile.getParentFile().exists()) {
                    outputITextFile.getParentFile().mkdirs();
                }
                if (!(iTextOutputFile = new File(outputDirectory, iTextOutputName = doc.substring(0, doc.indexOf(46) + 1) + this.getOutputExtension())).getParentFile().exists()) {
                    iTextOutputFile.getParentFile().mkdirs();
                }
                this.parse(fullPathDoc, module, outputITextFile);
                this.generateOutput(outputITextFile, iTextOutputFile);
            }
        }
    }

    @Override
    public void render(File siteDirectory, File outputDirectory, File documentDescriptor) throws DocumentRendererException, IOException {
        DocumentModel documentModel;
        if (documentDescriptor == null || !documentDescriptor.exists()) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No documentDescriptor is found. Generate all documents.");
            }
            this.render(siteDirectory, outputDirectory);
            return;
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(documentDescriptor);
            documentModel = new DocumentXpp3Reader().read(reader);
        }
        catch (XmlPullParserException e) {
            throw new DocumentRendererException("Error parsing document descriptor", e);
        }
        catch (IOException e) {
            throw new DocumentRendererException("Error reading document descriptor", e);
        }
        finally {
            IOUtil.close(reader);
        }
        if (documentModel.getOutputName() == null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No outputName is defined in the document descriptor. Using 'generated_itext'");
            }
            documentModel.setOutputName("generated_itext");
        }
        if ((documentModel.getToc() == null || documentModel.getToc().getItems() == null) && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("No TOC is defined in the document descriptor. Merging all documents.");
        }
        LinkedList<File> iTextFiles = new LinkedList<File>();
        Collection<ParserModule> modules = this.parserModuleManager.getParserModules();
        for (ParserModule module : modules) {
            File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List<String> docs = this.getModuleFileNames(module, moduleBasedir);
            for (String doc : docs) {
                String fullPathDoc = new File(moduleBasedir, doc).getPath();
                String outputITextName = doc.substring(0, doc.lastIndexOf(46) + 1) + "xml";
                File outputITextFile = new File(outputDirectory, outputITextName);
                if (documentModel.getToc() == null || documentModel.getToc().getItems() == null) {
                    iTextFiles.add(outputITextFile);
                    if (!outputITextFile.getParentFile().exists()) {
                        outputITextFile.getParentFile().mkdirs();
                    }
                    this.parse(fullPathDoc, module, outputITextFile);
                    continue;
                }
                for (DocumentTOCItem tocItem : documentModel.getToc().getItems()) {
                    String outRef;
                    if (tocItem.getRef() == null) {
                        if (!this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info("No ref defined for an tocItem in the document descriptor.");
                        continue;
                    }
                    String outTmp = StringUtils.replace(outputITextFile.getAbsolutePath(), "\\", "/");
                    if ((outTmp = outTmp.substring(0, outTmp.lastIndexOf(46))).indexOf(outRef = (outRef = StringUtils.replace(tocItem.getRef(), "\\", "/")).lastIndexOf(46) != -1 ? outRef.substring(0, outRef.lastIndexOf(46)) : outRef.substring(0, outRef.length())) == -1) continue;
                    iTextFiles.add(outputITextFile);
                    if (!outputITextFile.getParentFile().exists()) {
                        outputITextFile.getParentFile().mkdirs();
                    }
                    this.parse(fullPathDoc, module, outputITextFile);
                }
            }
        }
        File iTextFile = new File(outputDirectory, documentModel.getOutputName() + ".xml");
        File iTextOutput = new File(outputDirectory, documentModel.getOutputName() + "." + this.getOutputExtension());
        Document document = this.generateDocument(iTextFiles);
        this.transform(documentModel, document, iTextFile);
        this.generateOutput(iTextFile, iTextOutput);
    }

    public abstract void generateOutput(File var1, File var2) throws DocumentRendererException, IOException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(String fullPathDoc, ParserModule module, File outputITextFile) throws DocumentRendererException, IOException {
        XmlStreamWriter writer = WriterFactory.newXmlWriter(outputITextFile);
        ITextSink sink = (ITextSink)new ITextSinkFactory().createSink(writer);
        sink.setClassLoader(new URLClassLoader(new URL[]{outputITextFile.getParentFile().toURI().toURL()}));
        Reader reader = null;
        try {
            File f = new File(fullPathDoc);
            reader = XmlUtil.isXml(f) ? ReaderFactory.newXmlReader(f) : ReaderFactory.newPlatformReader(f);
            System.setProperty("itext.basedir", outputITextFile.getParentFile().getAbsolutePath());
            this.doxia.parse(reader, module.getParserId(), sink);
        }
        catch (ParserNotFoundException e) {
            try {
                throw new DocumentRendererException("Error getting a parser for '" + fullPathDoc + "': " + e.getMessage());
                catch (ParseException e2) {
                    throw new DocumentRendererException("Error parsing '" + fullPathDoc + "': line [" + e2.getLineNumber() + "] " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                sink.flush();
                sink.close();
                IOUtil.close(writer);
                System.getProperties().remove("itext.basedir");
                throw throwable;
            }
        }
        IOUtil.close(reader);
        sink.flush();
        sink.close();
        IOUtil.close(writer);
        System.getProperties().remove("itext.basedir");
    }

    private Document generateDocument(List<File> iTextFiles) throws DocumentRendererException, IOException {
        Document document;
        try {
            document = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new DocumentRendererException("Error building document :" + e.getMessage());
        }
        document.appendChild(document.createElement("itext"));
        for (File iTextFile : iTextFiles) {
            Document iTextDocument;
            try {
                iTextDocument = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(iTextFile);
            }
            catch (SAXException e) {
                throw new DocumentRendererException("SAX Error : " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new DocumentRendererException("Error parsing configuration : " + e.getMessage());
            }
            Node chapter = iTextDocument.getElementsByTagName("chapter").item(0);
            try {
                document.getDocumentElement().appendChild(document.importNode(chapter, true));
            }
            catch (DOMException e) {
                throw new DocumentRendererException("Error appending chapter for " + iTextFile + " : " + e.getMessage());
            }
        }
        return document;
    }

    private Transformer initTransformer() throws DocumentRendererException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(DefaultPdfRenderer.class.getResourceAsStream("/org/apache/maven/doxia/docrenderer/pdf/itext/TOC.xslt")));
            transformer.setErrorListener(TRANSFORMER_FACTORY.getErrorListener());
            transformer.setOutputProperty("omit-xml-declaration", "false");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new DocumentRendererException("Error configuring Transformer for org/apache/maven/doxia/docrenderer/pdf/itext/TOC.xslt: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new DocumentRendererException("Error configuring Transformer for org/apache/maven/doxia/docrenderer/pdf/itext/TOC.xslt: " + e.getMessage());
        }
    }

    private void addTransformerParameters(Transformer transformer, DocumentModel documentModel) {
        if (documentModel.getMeta().getTitle() != null) {
            transformer.setParameter("title", documentModel.getMeta().getTitle());
        }
        if (documentModel.getMeta().getAuthor() != null) {
            transformer.setParameter("author", documentModel.getMeta().getAuthor());
        }
        transformer.setParameter("creationdate", new Date().toString());
        if (documentModel.getMeta().getSubject() != null) {
            transformer.setParameter("subject", documentModel.getMeta().getSubject());
        }
        if (documentModel.getMeta().getKeywords() != null) {
            transformer.setParameter("keywords", documentModel.getMeta().getKeywords());
        }
        transformer.setParameter("producer", "Generated with Doxia by " + System.getProperty("user.name"));
        if (ITextUtil.isPageSizeSupported(documentModel.getMeta().getTitle())) {
            transformer.setParameter("pagesize", documentModel.getMeta().getPageSize());
        } else {
            transformer.setParameter("pagesize", "A4");
        }
        transformer.setParameter("frontPageHeader", "");
        if (documentModel.getMeta().getTitle() != null) {
            transformer.setParameter("frontPageTitle", documentModel.getMeta().getTitle());
        }
        transformer.setParameter("frontPageFooter", "Generated date " + new Date().toString());
    }

    private void transform(DocumentModel documentModel, Document document, File iTextFile) throws DocumentRendererException {
        Transformer transformer = this.initTransformer();
        this.addTransformerParameters(transformer, documentModel);
        try {
            transformer.transform(new DOMSource(document), new StreamResult(iTextFile));
        }
        catch (TransformerException e) {
            throw new DocumentRendererException("Error transformer Document from " + document + ": " + e.getMessage());
        }
    }

    static {
        TRANSFORMER_FACTORY.setErrorListener(new DefaultErrorHandler());
    }
}

