/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.maven.doxia.document.DocumentModel;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class FoUtils {
    private static final FopFactory FOP_FACTORY = FopFactory.newInstance();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    public static void convertFO2PDF(File fo, File pdf, String resourceDir, DocumentModel documentModel) throws TransformerException {
        FOUserAgent foUserAgent = FoUtils.getDefaultUserAgent(fo, resourceDir);
        if (documentModel != null && documentModel.getMeta() != null) {
            String keywords;
            String authors = documentModel.getMeta().getAllAuthorNames();
            if (StringUtils.isNotEmpty(authors)) {
                foUserAgent.setAuthor(authors);
            }
            if (StringUtils.isNotEmpty(documentModel.getMeta().getTitle())) {
                foUserAgent.setTitle(documentModel.getMeta().getTitle());
            }
            if (StringUtils.isNotEmpty(keywords = documentModel.getMeta().getAllKeyWords())) {
                foUserAgent.setKeywords(keywords);
            }
            if (StringUtils.isNotEmpty(documentModel.getMeta().getCreator())) {
                foUserAgent.setCreator(documentModel.getMeta().getCreator());
            }
            if (StringUtils.isNotEmpty(documentModel.getMeta().getGenerator())) {
                foUserAgent.setProducer(documentModel.getMeta().getGenerator());
            }
            if (documentModel.getMeta().getCreationDate() != null) {
                foUserAgent.setCreationDate(documentModel.getMeta().getCreationDate());
            }
        }
        if (foUserAgent.getCreator() == null) {
            foUserAgent.setCreator(System.getProperty("user.name"));
        }
        if (foUserAgent.getCreationDate() == null) {
            foUserAgent.setCreationDate(new Date());
        }
        FoUtils.convertFO2PDF(fo, pdf, resourceDir, foUserAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertFO2PDF(File fo, File pdf, String resourceDir, FOUserAgent foUserAgent) throws TransformerException {
        FOUserAgent userAgent = foUserAgent == null ? FoUtils.getDefaultUserAgent(fo, resourceDir) : foUserAgent;
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(pdf));
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            SAXResult res = null;
            try {
                Fop fop = FOP_FACTORY.newFop("application/pdf", userAgent, out);
                res = new SAXResult(fop.getDefaultHandler());
            }
            catch (FOPException e) {
                throw new TransformerException(e);
            }
            Transformer transformer = null;
            try {
                transformer = TRANSFORMER_FACTORY.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new TransformerException(e);
            }
            transformer.transform(new StreamSource(fo), res);
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(out);
    }

    public static void convertFO2PDF(File fo, File pdf, String resourceDir) throws TransformerException {
        FoUtils.convertFO2PDF(fo, pdf, resourceDir, (DocumentModel)null);
    }

    private static String getBaseURL(File fo, String resourceDir) {
        String url = null;
        url = resourceDir == null ? "file:///" + fo.getParent() + "/" : "file:///" + resourceDir + "/";
        return url;
    }

    private static FOUserAgent getDefaultUserAgent(File fo, String resourceDir) {
        FOUserAgent foUserAgent = FOP_FACTORY.newFOUserAgent();
        foUserAgent.setBaseURL(FoUtils.getBaseURL(fo, resourceDir));
        return foUserAgent;
    }

    private FoUtils() {
    }
}

