/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jrxtx;

import gnu.io.CommPortIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openmuc.jrxtx.DataBits;
import org.openmuc.jrxtx.FlowControl;
import org.openmuc.jrxtx.JRxTxPort;
import org.openmuc.jrxtx.Parity;
import org.openmuc.jrxtx.SerialPort;
import org.openmuc.jrxtx.StopBits;

public class SerialPortBuilder {
    private String portName;
    private int baudRate;
    private DataBits dataBits;
    private Parity parity;
    private StopBits stopBits;
    private FlowControl flowControl;

    public static String[] getSerialPortNames() {
        Enumeration<CommPortIdentifier> identifiers = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> result = new ArrayList<String>(20);
        while (identifiers.hasMoreElements()) {
            CommPortIdentifier identifier = identifiers.nextElement();
            if (identifier.getPortType() != 1) continue;
            result.add(identifier.getName());
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    private SerialPortBuilder(String portName) {
        this.portName = portName;
        this.baudRate = 9600;
        this.dataBits = DataBits.DATABITS_8;
        this.parity = Parity.EVEN;
        this.stopBits = StopBits.STOPBITS_1;
        this.flowControl = FlowControl.NONE;
    }

    public static SerialPortBuilder newBuilder(String portName) {
        return new SerialPortBuilder(portName);
    }

    public SerialPortBuilder setPortName(String portName) {
        this.portName = portName;
        return this;
    }

    public SerialPortBuilder setBaudRate(int baudRate) {
        this.baudRate = baudRate;
        return this;
    }

    public SerialPortBuilder setDataBits(DataBits dataBits) {
        this.dataBits = dataBits;
        return this;
    }

    public SerialPortBuilder setParity(Parity parity) {
        this.parity = parity;
        return this;
    }

    public SerialPortBuilder setStopBits(StopBits stopBits) {
        this.stopBits = stopBits;
        return this;
    }

    public SerialPortBuilder setFlowControl(FlowControl flowControl) {
        this.flowControl = flowControl;
        return this;
    }

    public SerialPort build() throws IOException {
        return JRxTxPort.openSerialPort(this.portName, this.baudRate, this.parity, this.dataBits, this.stopBits, this.flowControl);
    }
}

