/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;

abstract class IntegerGeneric
extends ASNObject {
    static final int BYTES = 8;
    int bytes = 8;
    long val;

    IntegerGeneric() {
    }

    IntegerGeneric(long i) {
        this.val = i;
        this.setSelected(true);
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional() && !this.isSelected()) {
            os.writeByte(1);
            return;
        }
        os.writeByte(89);
        os.writeLong(this.val);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte typeLengthField = is.readByte();
        if (this.isOptional() && typeLengthField == 1) {
            this.setSelected(false);
            return true;
        }
        if ((typeLengthField & 0x50) != 80) {
            return false;
        }
        int length = (typeLengthField & 0xF) - 1;
        this.val = 0L;
        for (int j = length - 1; j >= 0; --j) {
            this.val |= (long)is.readUnsignedByte() << 8 * j;
        }
        if ((this.val >> 8 * (length - 1) & 0x80L) == 128L) {
            for (int i = this.bytes; i > length; --i) {
                this.val |= (long)(255 << 8 * (i - 1));
            }
        }
        this.setSelected(true);
        return true;
    }

    public String toString() {
        return String.valueOf(this.val);
    }
}

