/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Choice;
import org.openmuc.jsml.structures.SmlListEntry;
import org.openmuc.jsml.structures.SmlPeriodEntry;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlTupelEntry;
import org.openmuc.jsml.structures.SmlValue;
import org.openmuc.jsml.structures.Unsigned8;

public class SmlProcParValue
extends Choice {
    public static final int SMLVALUE = 1;
    public static final int SMLPERIODENTRY = 2;
    public static final int SMLTUPELENTRY = 3;
    public static final int SMLTIME = 4;
    public static final int SMLLISTENTRY = 5;

    public SmlProcParValue() {
    }

    public SmlProcParValue(int tag, ASNObject choice) {
        if (tag != 1 && tag != 2 && tag != 3 && 4 != tag && 5 != tag) {
            throw new IllegalArgumentException("SML_ProcParValue: Wrong value for tag! " + tag + " is not allowed.");
        }
        this.setTag(new Unsigned8(tag));
        this.choice = choice;
        this.setSelected(true);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte tlField = is.readByte();
        if (this.isOptional() && tlField == 1) {
            this.setSelected(false);
            return true;
        }
        if ((tlField & 0xFF) != 114 || !this.getTag().decode(is)) {
            return false;
        }
        switch (this.getTag().getVal()) {
            case 1: {
                this.choice = new SmlValue();
                break;
            }
            case 2: {
                this.choice = new SmlPeriodEntry();
                break;
            }
            case 3: {
                this.choice = new SmlTupelEntry();
                break;
            }
            case 4: {
                this.choice = new SmlTime();
                break;
            }
            case 5: {
                this.choice = new SmlListEntry();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag number: " + this.getTag().getVal());
            }
        }
        if (!this.choice.decode(is)) {
            return false;
        }
        this.setSelected(true);
        return true;
    }

    public String toString() {
        String retValue = "not set";
        if (this.isSelected()) {
            String tagValue;
            switch (this.getTag().getVal()) {
                case 1: {
                    tagValue = "SML_VALUE";
                    break;
                }
                case 2: {
                    tagValue = "SML_PERIOD_ENTRY";
                    break;
                }
                case 3: {
                    tagValue = "SML_TUPEL_ENTRY";
                    break;
                }
                case 4: {
                    tagValue = "SML_TIME";
                    break;
                }
                case 5: {
                    tagValue = "SML_LIST_ENTRY";
                    break;
                }
                default: {
                    tagValue = "unknown - " + this.getTag().getVal();
                }
            }
            String value = "unknown";
            if (this.choice instanceof SmlTime) {
                SmlTime smlTime = (SmlTime)this.choice;
                value = smlTime.toString();
            } else if (this.choice instanceof SmlValue) {
                SmlValue smlvalue = (SmlValue)this.choice;
                value = smlvalue.toString();
            } else if (this.choice instanceof SmlPeriodEntry) {
                SmlPeriodEntry periodEntry = (SmlPeriodEntry)this.choice;
                value = periodEntry.toString();
            } else if (this.choice instanceof SmlTupelEntry) {
                SmlTupelEntry tupelEntry = (SmlTupelEntry)this.choice;
                value = tupelEntry.toString();
            } else if (this.choice instanceof SmlListEntry) {
                SmlListEntry listEntry = (SmlListEntry)this.choice;
                value = listEntry.toString();
            }
            retValue = "tag: " + tagValue + " value: " + value;
        }
        return retValue;
    }
}

