/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.gui.views;

import com.hastobe.transparenzsoftware.gui.views.MainView;
import com.hastobe.transparenzsoftware.i18n.Translator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AboutView
extends JFrame {
    private static final Logger LOGGER = LogManager.getLogger(AboutView.class);

    public AboutView(final MainView mainView) {
        this.setTitle(Translator.get("app.view.about"));
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel hastobe = new JLabel("Transparenzssoftware " + String.format("Version: %s", "1.2.0"));
        hastobe.setAlignmentX(0.5f);
        this.add(hastobe);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        JLabel creator = new JLabel("Hersteller: \u00a9 2021 S.A.F.E. e.V.");
        creator.setAlignmentX(0.5f);
        this.add(creator);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        JLabel checksumText = new JLabel(Translator.get("app.view.checksum") + " Transparenzssoftware (SHA-256):");
        checksumText.setAlignmentX(0.5f);
        this.add(checksumText);
        JLabel checksum = new JLabel(AboutView.getCheckSum());
        checksum.setAlignmentX(0.5f);
        this.add(checksum);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        JLabel text = new JLabel("Powered by:");
        text.setAlignmentX(0.5f);
        this.add(text);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        for (String openSourceName : this.openSourceNames()) {
            JLabel library = new JLabel(openSourceName);
            library.setAlignmentX(0.5f);
            this.add(library);
        }
        this.add(Box.createRigidArea(new Dimension(0, 200)));
        JButton close = new JButton(Translator.get("app.view.close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                mainView.onAboutClose();
            }
        });
        close.setAlignmentX(0.5f);
        this.add(close);
        this.setDefaultCloseOperation(2);
        this.setSize(300, 200);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                mainView.onAboutClose();
            }
        });
    }

    private ArrayList<String> openSourceNames() {
        ArrayList<String> libraryNames = new ArrayList<String>();
        libraryNames.add("Bouncy Castle Version 1.59 (https://www.bouncycastle.org) - MIT License");
        libraryNames.add("jSML Openmuc (https://www.openmuc.org/sml/) - MPL v2.0 License");
        libraryNames.add("Gson (https://github.com/google/gson) - Apache 2.0 License");
        libraryNames.add("Guava (https://github.com/google/guava) - Apache 2.0 License");
        libraryNames.add("Commons-Cli (https://commons.apache.org/proper/commons-cli/) - Apache 2.0 License");
        libraryNames.add("Log4j (https://logging.apache.org/log4j/2.x/) - Apache 2.0 License");
        return libraryNames;
    }

    private static String getCheckSum() {
        StringBuilder sb = new StringBuilder();
        try {
            URL u = AboutView.class.getProtectionDomain().getCodeSource().getLocation();
            String path = URLDecoder.decode(u.getPath(), Charset.forName("UTF-8"));
            File currentJavaJarFile = new File(path);
            String filepath = currentJavaJarFile.getAbsolutePath();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            FileInputStream fis = new FileInputStream(filepath);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not create checksum for jar file", (Throwable)e);
        }
        return sb.toString();
    }
}

