/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.output;

import com.hastobe.transparenzsoftware.Utils;
import com.hastobe.transparenzsoftware.verification.result.VerificationResult;
import com.hastobe.transparenzsoftware.verification.xml.Meter;
import com.hastobe.transparenzsoftware.verification.xml.Result;
import com.hastobe.transparenzsoftware.verification.xml.Results;
import com.hastobe.transparenzsoftware.verification.xml.Value;
import com.hastobe.transparenzsoftware.verification.xml.Values;
import java.io.StringWriter;
import java.time.Duration;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class Output {
    private final Marshaller marshaller;
    private final Values values;
    private List<VerificationResult> verificationResults;

    public Output(Class[] verifiedDataClasses, List<VerificationResult> verificationResults, Values values) throws JAXBException {
        this.values = values;
        Class[] classes = new Class[verifiedDataClasses.length + 1];
        classes[0] = Results.class;
        System.arraycopy(verifiedDataClasses, 0, classes, 1, verifiedDataClasses.length);
        JAXBContext jc = JAXBContext.newInstance(classes);
        this.marshaller = jc.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        this.verificationResults = verificationResults;
    }

    public String createXML() throws JAXBException {
        StringWriter sw = new StringWriter();
        this.marshaller.marshal((Object)this.createResults(), sw);
        return sw.toString();
    }

    protected Results createResults() {
        Results results = new Results();
        for (int i = 0; i < this.verificationResults.size(); ++i) {
            VerificationResult verificationResult = this.verificationResults.get(i);
            Result result = new Result();
            if (this.values.getValues().size() < i) {
                Value value = this.values.getValues().get(i);
                result.setPublicKey(value.getPublicKey());
                result.setSignedData(value.getSignedData());
            }
            List<Meter> meters = verificationResult.getMeters();
            String preci = meters.get(0).getScalingFormat();
            if (verificationResult.isTransactionResult() && verificationResult.getTransactionId() != null) {
                result.setTransactionId(verificationResult.getTransactionId());
                result.setMeterDiff(String.format(preci + " kWh", Meter.getDifference(meters)));
                Duration timeDiff = Meter.getTimeDiff(meters);
                result.setTimeDiff(Utils.formatDuration(timeDiff));
            }
            result.setMeters(meters);
            result.setStatus(verificationResult.isVerified() ? "Verified" : "Failed");
            result.setVerifiedData(verificationResult.getVerifiedData());
            if (!verificationResult.getErrorMessages().isEmpty()) {
                result.setErrorMessage(verificationResult.getErrorMessages().get(0).getLocalizedMessage());
            }
            results.getResults().add(result);
        }
        return results;
    }
}

