/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification;

import com.hastobe.transparenzsoftware.verification.VerificationParser;
import com.hastobe.transparenzsoftware.verification.VerificationType;
import com.hastobe.transparenzsoftware.verification.VerificationTypeNotImplementedException;
import com.hastobe.transparenzsoftware.verification.format.alfen.AlfenVerificationParser;
import com.hastobe.transparenzsoftware.verification.format.ocmf.OCMFVerificationParser;
import com.hastobe.transparenzsoftware.verification.format.pcdf.PcdfVerificationParser;
import com.hastobe.transparenzsoftware.verification.format.sml.EDL40.EDL40VerificationParser;
import com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes.EDLMennekesVerificationParser;
import com.hastobe.transparenzsoftware.verification.format.sml.IsaEDL40.IsaEDL40VerificationParser;
import com.hastobe.transparenzsoftware.verification.format.sml.SignatureOnly.SignatureOnlyVerificationParser;
import java.util.ArrayList;
import java.util.List;

public class VerificationParserFactory {
    List<VerificationParser> parser;

    public VerificationParserFactory(List<VerificationParser> parser) {
        this.parser = parser;
    }

    public VerificationParserFactory() {
        this.parser = new ArrayList<VerificationParser>();
        this.parser.add(new OCMFVerificationParser());
        this.parser.add(new PcdfVerificationParser());
        this.parser.add(new IsaEDL40VerificationParser());
        this.parser.add(new AlfenVerificationParser());
        this.parser.add(new EDL40VerificationParser());
        this.parser.add(new SignatureOnlyVerificationParser());
        this.parser.add(new EDLMennekesVerificationParser());
    }

    public VerificationParser getParser(VerificationType type) throws VerificationTypeNotImplementedException {
        if (type == null) {
            throw new VerificationTypeNotImplementedException(null);
        }
        for (VerificationParser verificationParser : this.parser) {
            if (!verificationParser.getVerificationType().equals((Object)type)) continue;
            return verificationParser;
        }
        throw new VerificationTypeNotImplementedException(type);
    }

    public List<VerificationParser> getParserWithData(String data) throws VerificationTypeNotImplementedException {
        if (data == null) {
            throw new VerificationTypeNotImplementedException(null);
        }
        ArrayList<VerificationParser> possibleParser = new ArrayList<VerificationParser>();
        for (VerificationParser verificationParser : this.parser) {
            if (!verificationParser.canParseData(data)) continue;
            possibleParser.add(verificationParser);
        }
        if (possibleParser.size() == 0) {
            throw new VerificationTypeNotImplementedException(null);
        }
        return possibleParser;
    }

    public Class[] getVerifiedDataClasses() {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (VerificationParser verificationParser : this.parser) {
            classList.add(verificationParser.getVerfiedDataClass());
        }
        return classList.toArray(new Class[0]);
    }
}

