/*
 * Decompiled with CFR 0.152.
 */
package com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes;

import com.hastobe.transparenzsoftware.verification.DecodingException;
import com.hastobe.transparenzsoftware.verification.EncodingType;
import com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.ChargingProcess;
import com.hastobe.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.Measurement;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLSignature;
import com.hastobe.transparenzsoftware.verification.format.sml.SMLValidationException;
import java.time.OffsetDateTime;
import org.bouncycastle.util.encoders.Hex;

public class EDLMennekesSignature
extends SMLSignature {
    private OffsetDateTime timestamp;
    private OffsetDateTime timestampContractId;
    private byte[] providedSignature;
    private long eventCounter;

    public EDLMennekesSignature(ChargingProcess chargingProcess, ReadingType readingType) throws SMLValidationException {
        Measurement measurement;
        Measurement measurement2 = measurement = readingType == ReadingType.MEASUREMENT_START ? chargingProcess.getMeasurementStart() : chargingProcess.getMeasurementEnd();
        if (measurement == null) {
            throw new SMLValidationException("No measurements provided", "error.sml.mennekes.no.measurement");
        }
        if (measurement.getTimestamp() == null) {
            throw new SMLValidationException("No timestamp in measurement provided", "error.sml.mennekes.no.timestamp");
        }
        this.timestamp = measurement.getTimestamp();
        this.timestampContractId = measurement.getTimestampCustomerIdent() == null ? chargingProcess.getTimestampCustomerIdent() : measurement.getTimestampCustomerIdent();
        if (this.timestampContractId == null) {
            throw new SMLValidationException("No timestamp for customer timestamp provided", "error.sml.mennekes.no.timestampCustomer");
        }
        this.setMeterPosition(measurement.getValue());
        this.setSecondsIndex(measurement.getSecondIndex());
        this.setPagination(measurement.getPagination());
        this.setStatus(measurement.getMeterStatus());
        this.setScaler((byte)measurement.getScaler());
        this.setEventCounter(measurement.getEventCounter());
        try {
            this.setServerId(EncodingType.hexDecode(chargingProcess.getServerId()));
        }
        catch (DecodingException e) {
            throw new SMLValidationException("Invalid serverid provided", "error.sml.mennekes.invalid.serverid");
        }
        this.setObisNr(new byte[]{1, 0, 1, 17, 0, -1});
        this.setUnit(30);
        byte[] signature = measurement.getSignatureAsBytes();
        if (signature.length > 48) {
            this.setBytesLog(signature[signature.length - 2], signature[signature.length - 1]);
        } else {
            this.setBytesLog((byte)(this.eventCounter >> 8 & 0xFFL), (byte)(this.eventCounter & 0xFFL));
        }
        this.setContractId(Hex.decode(chargingProcess.getCustomerIdent()), true);
        this.providedSignature = signature;
    }

    @Override
    public byte[] getTimestamp() {
        return EDLMennekesSignature.timeToBytes(this.timestamp);
    }

    @Override
    public OffsetDateTime getTimestampAsDate() {
        return this.timestamp;
    }

    @Override
    public byte[] getTimestampContractId() {
        return EDLMennekesSignature.timeToBytes(this.timestampContractId);
    }

    @Override
    public OffsetDateTime getTimestampContractIdAsDate() {
        return this.timestampContractId;
    }

    @Override
    public byte[] getProvidedSignature() {
        return this.providedSignature;
    }

    public long getEventCounter() {
        return this.eventCounter;
    }

    public void setEventCounter(long eventCounter) {
        this.eventCounter = eventCounter;
    }

    static enum ReadingType {
        MEASUREMENT_START,
        MEASUREMENT_END;

    }
}

