/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGFeatureStrings;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;

public class UserAgentAdapter
implements UserAgent {
    protected Set FEATURES = new HashSet();
    protected Set extensions = new HashSet();
    protected BridgeContext ctx;

    public void setBridgeContext(BridgeContext ctx) {
        this.ctx = ctx;
    }

    public void addStdFeatures() {
        SVGFeatureStrings.addSupportedFeatureStrings(this.FEATURES);
    }

    public Dimension2D getViewportSize() {
        return new Dimension(1, 1);
    }

    public void displayMessage(String message) {
    }

    public void displayError(String message) {
        this.displayMessage(message);
    }

    public void displayError(Exception e) {
        this.displayError(e.getMessage());
    }

    public void showAlert(String message) {
    }

    public String showPrompt(String message) {
        return null;
    }

    public String showPrompt(String message, String defaultValue) {
        return null;
    }

    public boolean showConfirm(String message) {
        return false;
    }

    public float getPixelUnitToMillimeter() {
        return 0.26458332f;
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public String getDefaultFontFamily() {
        return "Arial, Helvetica, sans-serif";
    }

    public float getMediumFontSize() {
        return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
    }

    public float getLighterFontWeight(float f) {
        return UserAgentAdapter.getStandardLighterFontWeight(f);
    }

    public float getBolderFontWeight(float f) {
        return UserAgentAdapter.getStandardBolderFontWeight(f);
    }

    public String getLanguages() {
        return "en";
    }

    public String getMedia() {
        return "all";
    }

    public String getAlternateStyleSheet() {
        return null;
    }

    public String getUserStyleSheetURI() {
        return null;
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public boolean isXMLParserValidating() {
        return false;
    }

    public EventDispatcher getEventDispatcher() {
        return null;
    }

    public void openLink(SVGAElement elt) {
    }

    public void setSVGCursor(Cursor cursor) {
    }

    public void setTextSelection(Mark start, Mark end) {
    }

    public void deselectAll() {
    }

    public void runThread(Thread t) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform at) {
    }

    public Point getClientAreaLocationOnScreen() {
        return new Point();
    }

    public boolean hasFeature(String s2) {
        return this.FEATURES.contains(s2);
    }

    public boolean supportExtension(String s2) {
        return this.extensions.contains(s2);
    }

    public void registerExtension(BridgeExtension ext) {
        Iterator i = ext.getImplementedExtensions();
        while (i.hasNext()) {
            this.extensions.add(i.next());
        }
    }

    public void handleElement(Element elt, Object data) {
    }

    public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
        return new DefaultScriptSecurity(scriptType, scriptURL, docURL);
    }

    public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
        ScriptSecurity s2 = this.getScriptSecurity(scriptType, scriptURL, docURL);
        if (s2 != null) {
            s2.checkLoadScript();
        }
    }

    public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
        return new RelaxedExternalResourceSecurity(resourceURL, docURL);
    }

    public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
        ExternalResourceSecurity s2 = this.getExternalResourceSecurity(resourceURL, docURL);
        if (s2 != null) {
            s2.checkLoadExternalResource();
        }
    }

    public static float getStandardLighterFontWeight(float f) {
        int weight = (int)((f + 50.0f) / 100.0f) * 100;
        switch (weight) {
            case 100: {
                return 100.0f;
            }
            case 200: {
                return 100.0f;
            }
            case 300: {
                return 200.0f;
            }
            case 400: {
                return 300.0f;
            }
            case 500: {
                return 400.0f;
            }
            case 600: {
                return 400.0f;
            }
            case 700: {
                return 400.0f;
            }
            case 800: {
                return 400.0f;
            }
            case 900: {
                return 400.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public static float getStandardBolderFontWeight(float f) {
        int weight = (int)((f + 50.0f) / 100.0f) * 100;
        switch (weight) {
            case 100: {
                return 600.0f;
            }
            case 200: {
                return 600.0f;
            }
            case 300: {
                return 600.0f;
            }
            case 400: {
                return 600.0f;
            }
            case 500: {
                return 600.0f;
            }
            case 600: {
                return 700.0f;
            }
            case 700: {
                return 800.0f;
            }
            case 800: {
                return 900.0f;
            }
            case 900: {
                return 900.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
        throw new BridgeException(this.ctx, e, "uri.image.broken", new Object[]{url, message});
    }
}

