/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.text.DecimalFormat;
import java.util.Map;
import org.apache.fop.fonts.BFEntry;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;

public class MultiByteFont
extends CIDFont {
    private static int uniqueCounter = -1;
    private String ttcName = null;
    private String encoding = "Identity-H";
    private int defaultWidth = 0;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    private String namePrefix = null;
    private BFEntry[] bfentries = null;
    public static final char INVALID_UNICODE_CHAR = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiByteFont() {
        this.usedGlyphs.put(new Integer(0), new Integer(0));
        this.usedGlyphsIndex.put(new Integer(0), new Integer(0));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(1), new Integer(1));
        this.usedGlyphsIndex.put(new Integer(1), new Integer(1));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(2), new Integer(2));
        this.usedGlyphsIndex.put(new Integer(2), new Integer(2));
        ++this.usedGlyphsCount;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (++uniqueCounter > 99999 || uniqueCounter < 0) {
                uniqueCounter = 0;
            }
        }
        DecimalFormat counterFormat = new DecimalFormat("00000");
        String cntString = counterFormat.format(uniqueCounter);
        StringBuffer sb = new StringBuffer("E");
        int c = cntString.length();
        for (int i = 0; i < c; ++i) {
            sb.append((char)(cntString.charAt(i) + 17));
        }
        sb.append("+");
        this.namePrefix = sb.toString();
        this.setFontType(FontType.TYPE0);
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public String getRegistry() {
        return "Adobe";
    }

    public String getOrdering() {
        return "UCS";
    }

    public int getSupplement() {
        return 0;
    }

    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public void setCIDType(CIDFontType cidType) {
        this.cidType = cidType;
    }

    private String getPrefixedFontName() {
        return this.namePrefix + FontUtil.stripWhiteSpace(super.getFontName());
    }

    public String getEmbedFontName() {
        if (this.isEmbeddable()) {
            return this.getPrefixedFontName();
        }
        return super.getFontName();
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getWidth(int i, int size) {
        if (this.isEmbeddable()) {
            Integer idx = (Integer)this.usedGlyphsIndex.get(new Integer(i));
            return size * this.width[idx];
        }
        return size * this.width[i];
    }

    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    private int findGlyphIndex(char c) {
        char idx = c;
        int retIdx = 0;
        for (int i = 0; i < this.bfentries.length && retIdx == 0; ++i) {
            if (this.bfentries[i].getUnicodeStart() > idx || this.bfentries[i].getUnicodeEnd() < idx) continue;
            retIdx = this.bfentries[i].getGlyphStartIndex() + idx - this.bfentries[i].getUnicodeStart();
        }
        return retIdx;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        int retIdx = this.findGlyphIndex(c);
        if (this.isEmbeddable()) {
            Integer newIdx = (Integer)this.usedGlyphs.get(new Integer(retIdx));
            if (newIdx == null) {
                this.usedGlyphs.put(new Integer(retIdx), new Integer(this.usedGlyphsCount));
                this.usedGlyphsIndex.put(new Integer(this.usedGlyphsCount), new Integer(retIdx));
                this.usedCharsIndex.put(new Integer(this.usedGlyphsCount), new Integer(c));
                retIdx = this.usedGlyphsCount++;
            } else {
                retIdx = newIdx;
            }
        }
        return (char)retIdx;
    }

    public boolean hasChar(char c) {
        return this.findGlyphIndex(c) > 0;
    }

    public void setBFEntries(BFEntry[] bfentries) {
        this.bfentries = bfentries;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public void setTTCName(String ttcName) {
        this.ttcName = ttcName;
    }

    public void setWidthArray(int[] wds) {
        this.width = wds;
    }

    public Map getUsedGlyphs() {
        return this.usedGlyphs;
    }

    public char[] getCharsUsed() {
        if (!this.isEmbeddable()) {
            return null;
        }
        char[] charArray = new char[this.usedGlyphsCount];
        for (int i = 0; i < this.usedGlyphsCount; ++i) {
            int arrayItem;
            Integer mapValue = (Integer)this.usedCharsIndex.get(new Integer(i));
            charArray[i] = mapValue != null ? (arrayItem = (int)mapValue) : 65535;
        }
        return charArray;
    }
}

