/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

public class PDFDestination
extends PDFObject {
    private String idRef;
    private Object goToReference;

    public PDFDestination(String idRef, Object goToRef) {
        this.goToReference = goToRef;
        this.idRef = idRef;
    }

    protected int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        Writer writer = PDFDocument.getWriterFor(cout);
        this.formatObject(this.getIDRef(), cout, writer);
        writer.write(32);
        this.formatObject(this.goToReference, cout, writer);
        writer.flush();
        return cout.getCount();
    }

    public void setGoToReference(String goToReference) {
        this.goToReference = goToReference;
    }

    public void setGoToReference(Object goToReference) {
        this.goToReference = goToReference;
    }

    public Object getGoToReference() {
        return this.goToReference;
    }

    public String getIDRef() {
        return this.idRef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFDestination)) {
            return false;
        }
        PDFDestination dest = (PDFDestination)obj;
        return dest.getIDRef().equals(this.getIDRef());
    }

    public int hashCode() {
        return this.getIDRef().hashCode();
    }
}

