/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class ImageSizeParameter
extends AbstractAFPObject {
    private int hRes = 0;
    private int vRes = 0;
    private int hSize = 0;
    private int vSize = 0;

    public ImageSizeParameter(int hresol, int vresol, int hsize, int vsize) {
        this.hRes = hresol;
        this.vRes = vresol;
        this.hSize = hsize;
        this.vSize = vsize;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[]{-108, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] x = BinaryUtils.convert(this.hRes, 2);
        data[3] = x[0];
        data[4] = x[1];
        byte[] y = BinaryUtils.convert(this.vRes, 2);
        data[5] = y[0];
        data[6] = y[1];
        byte[] w = BinaryUtils.convert(this.hSize, 2);
        data[7] = w[0];
        data[8] = w[1];
        byte[] h2 = BinaryUtils.convert(this.vSize, 2);
        data[9] = h2[0];
        data[10] = h2[1];
        os.write(data);
    }
}

