/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.maven.BuildFailureException;
import org.apache.maven.ConfigurationInterpolationException;
import org.apache.maven.ConfigurationInterpolator;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Phase;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycleExecutor
extends AbstractLogEnabled
implements LifecycleExecutor,
Initializable,
Contextualizable {
    private PluginManager pluginManager;
    private ExtensionManager extensionManager;
    private List lifecycles;
    private ArtifactHandlerManager artifactHandlerManager;
    private List defaultReports;
    private Map phaseToLifecycleMap;
    private MavenProjectBuilder mavenProjectBuilder;
    private ModelInterpolator modelInterpolator;
    private ConfigurationInterpolator configInterpolator;
    private PlexusContainer container;

    @Override
    public void execute(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException {
        String goal;
        MavenProject rootProject = rm.getTopLevelProject();
        List<String> goals = session.getGoals();
        if (goals.isEmpty() && rootProject != null && (goal = rootProject.getDefaultGoal()) != null) {
            goals = Collections.singletonList(goal);
        }
        if (goals.isEmpty()) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append("\n\n");
            buffer.append("You must specify at least one goal or lifecycle phase to perform build steps.\n");
            buffer.append("The following list illustrates some commonly used build commands:\n\n");
            buffer.append("  mvn clean\n");
            buffer.append("    Deletes any build output (e.g. class files or JARs).\n");
            buffer.append("  mvn test\n");
            buffer.append("    Runs the unit tests for the project.\n");
            buffer.append("  mvn install\n");
            buffer.append("    Copies the project artifacts into your local repository.\n");
            buffer.append("  mvn deploy\n");
            buffer.append("    Copies the project artifacts into the remote repository.\n");
            buffer.append("  mvn site\n");
            buffer.append("    Creates project documentation (e.g. reports or Javadoc).\n\n");
            buffer.append("Please see\n");
            buffer.append("http://maven.apache.org/guides/introduction/introduction-to-the-lifecycle.html\n");
            buffer.append("for a complete description of available lifecycle phases.\n\n");
            buffer.append("Use \"mvn --help\" to show general usage information about Maven's command line.\n\n");
            throw new BuildFailureException(buffer.toString());
        }
        List taskSegments = this.segmentTaskListByAggregationNeeds(goals, session, rootProject);
        this.findExtensions(session);
        this.executeTaskSegments(taskSegments, rm, session, rootProject, dispatcher);
    }

    private void findExtensions(MavenSession session) throws LifecycleExecutionException {
        HashMap<String, ArtifactHandler> handlers = new HashMap<String, ArtifactHandler>();
        for (MavenProject project : session.getSortedProjects()) {
            for (Extension extension : project.getBuildExtensions()) {
                try {
                    this.getLogger().debug("Adding extension: " + extension);
                    this.extensionManager.addExtension(extension, project, session.getLocalRepository());
                }
                catch (PlexusContainerException e) {
                    throw new LifecycleExecutionException("Unable to initialise extensions", e);
                }
                catch (ArtifactResolutionException e) {
                    throw new LifecycleExecutionException(e.getMessage(), e);
                }
                catch (ArtifactNotFoundException e) {
                    throw new LifecycleExecutionException(e.getMessage(), e);
                }
            }
        }
        this.extensionManager.registerWagons();
        handlers.putAll(this.extensionManager.getArtifactTypeHandlers());
        block8: for (MavenProject project : session.getSortedProjects()) {
            try {
                handlers.putAll(this.findArtifactTypeHandlersInPlugins(project, session));
                for (ArtifactHandler handler : handlers.values()) {
                    if (!project.getPackaging().equals(handler.getPackaging())) continue;
                    project.getArtifact().setArtifactHandler(handler);
                    continue block8;
                }
            }
            catch (PluginNotFoundException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
        }
        this.artifactHandlerManager.addHandlers(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTaskSegments(List taskSegments, ReactorManager rm, MavenSession session, MavenProject rootProject, EventDispatcher dispatcher) throws LifecycleExecutionException, BuildFailureException {
        for (TaskSegment segment : taskSegments) {
            if (segment.aggregate()) {
                if (!rm.isBlackListed(rootProject)) {
                    this.line();
                    this.getLogger().info("Building " + rootProject.getName());
                    this.getLogger().info("  " + segment);
                    this.line();
                    String event = "project-execute";
                    long buildStartTime = System.currentTimeMillis();
                    String target = rootProject.getId() + " ( " + segment + " )";
                    dispatcher.dispatchStart(event, target);
                    try {
                        session.setCurrentProject(rootProject);
                        for (String task : segment.getTasks()) {
                            this.executeGoalAndHandleFailures(task, session, rootProject, dispatcher, event, rm, buildStartTime, target);
                        }
                        rm.registerBuildSuccess(rootProject, System.currentTimeMillis() - buildStartTime);
                    }
                    finally {
                        session.setCurrentProject(null);
                    }
                    dispatcher.dispatchEnd(event, target);
                    continue;
                }
                this.line();
                this.getLogger().info("SKIPPING " + rootProject.getName());
                this.getLogger().info("  " + segment);
                this.getLogger().info("This project has been banned from further executions due to previous failures.");
                this.line();
                continue;
            }
            List<MavenProject> sortedProjects = session.getSortedProjects();
            for (MavenProject currentProject : sortedProjects) {
                if (!rm.isBlackListed(currentProject)) {
                    this.line();
                    this.getLogger().info("Building " + currentProject.getName());
                    this.getLogger().info("  " + segment);
                    this.line();
                    String event = "project-execute";
                    long buildStartTime = System.currentTimeMillis();
                    String target = currentProject.getId() + " ( " + segment + " )";
                    dispatcher.dispatchStart(event, target);
                    try {
                        session.setCurrentProject(currentProject);
                        for (String task : segment.getTasks()) {
                            this.executeGoalAndHandleFailures(task, session, currentProject, dispatcher, event, rm, buildStartTime, target);
                        }
                    }
                    finally {
                        session.setCurrentProject(null);
                    }
                    rm.registerBuildSuccess(currentProject, System.currentTimeMillis() - buildStartTime);
                    dispatcher.dispatchEnd(event, target);
                    continue;
                }
                this.line();
                this.getLogger().info("SKIPPING " + currentProject.getName());
                this.getLogger().info("  " + segment);
                this.getLogger().info("This project has been banned from further executions due to previous failures.");
                this.line();
            }
        }
    }

    private void executeGoalAndHandleFailures(String task, MavenSession session, MavenProject project, EventDispatcher dispatcher, String event, ReactorManager rm, long buildStartTime, String target) throws BuildFailureException, LifecycleExecutionException {
        block4: {
            try {
                this.executeGoal(task, session, project);
            }
            catch (LifecycleExecutionException e) {
                dispatcher.dispatchError(event, target, e);
                if (this.handleExecutionFailure(rm, project, e, task, buildStartTime)) {
                    throw e;
                }
            }
            catch (BuildFailureException e) {
                dispatcher.dispatchError(event, target, e);
                if (!this.handleExecutionFailure(rm, project, e, task, buildStartTime)) break block4;
                throw e;
            }
        }
    }

    private boolean handleExecutionFailure(ReactorManager rm, MavenProject project, Exception e, String task, long buildStartTime) {
        rm.registerBuildFailure(project, e, task, System.currentTimeMillis() - buildStartTime);
        if ("fail-fast".equals(rm.getFailureBehavior())) {
            return true;
        }
        if ("fail-at-end".equals(rm.getFailureBehavior())) {
            rm.blackList(project);
        }
        return false;
    }

    private List segmentTaskListByAggregationNeeds(List tasks, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException {
        ArrayList<TaskSegment> segments = new ArrayList<TaskSegment>();
        if (project != null) {
            TaskSegment currentSegment = null;
            for (String task : tasks) {
                if (this.getPhaseToLifecycleMap().containsKey(task)) {
                    if (currentSegment != null && currentSegment.aggregate()) {
                        segments.add(currentSegment);
                        currentSegment = null;
                    }
                    if (currentSegment == null) {
                        currentSegment = new TaskSegment();
                    }
                    currentSegment.add(task);
                    continue;
                }
                MojoDescriptor mojo = null;
                try {
                    mojo = this.getMojoDescriptor(task, session, project, task, true, false);
                }
                catch (PluginNotFoundException e) {
                    this.getLogger().info("Cannot find mojo descriptor for: '" + task + "' - Treating as non-aggregator.");
                    this.getLogger().debug("", e);
                }
                if (mojo != null && (mojo.isAggregator() || !mojo.isProjectRequired())) {
                    if (currentSegment != null && !currentSegment.aggregate()) {
                        segments.add(currentSegment);
                        currentSegment = null;
                    }
                    if (currentSegment == null) {
                        currentSegment = new TaskSegment(true);
                    }
                    currentSegment.add(task);
                    continue;
                }
                if (currentSegment != null && currentSegment.aggregate()) {
                    segments.add(currentSegment);
                    currentSegment = null;
                }
                if (currentSegment == null) {
                    currentSegment = new TaskSegment();
                }
                currentSegment.add(task);
            }
            segments.add(currentSegment);
        } else {
            TaskSegment segment = new TaskSegment(false);
            Iterator i = tasks.iterator();
            while (i.hasNext()) {
                segment.add((String)i.next());
            }
            segments.add(segment);
        }
        return segments;
    }

    private void executeGoal(String task, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException {
        try {
            Stack forkEntryPoints = new Stack();
            if (this.getPhaseToLifecycleMap().containsKey(task)) {
                Lifecycle lifecycle = this.getLifecycleForPhase(task);
                Map lifecycleMappings = this.constructLifecycleMappings(session, task, project, lifecycle);
                this.executeGoalWithLifecycle(task, forkEntryPoints, session, lifecycleMappings, project, lifecycle);
            } else {
                this.executeStandaloneGoal(task, forkEntryPoints, session, project);
            }
        }
        catch (PluginNotFoundException e) {
            throw new BuildFailureException("A required plugin was not found: " + e.getMessage(), e);
        }
    }

    private void executeGoalWithLifecycle(String task, Stack forkEntryPoints, MavenSession session, Map lifecycleMappings, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        List goals = this.processGoalChain(task, lifecycleMappings, lifecycle);
        if (!goals.isEmpty()) {
            this.executeGoals(goals, forkEntryPoints, session, project);
        } else {
            this.getLogger().info("No goals needed for project - skipping");
        }
    }

    private void executeStandaloneGoal(String task, Stack forkEntryPoints, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        MojoDescriptor mojoDescriptor = this.getMojoDescriptor(task, session, project, task, true, false);
        this.executeGoals(Collections.singletonList(new MojoExecution(mojoDescriptor, "default-cli")), forkEntryPoints, session, project);
    }

    private void executeGoals(List goals, Stack forkEntryPoints, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        for (MojoExecution mojoExecution : goals) {
            List<MavenProject> reactorProjects;
            boolean usesReactorProjects;
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            PlexusConfiguration configuration = mojoDescriptor.getMojoConfiguration();
            boolean bl = usesReactorProjects = mojoDescriptor.isAggregator() || this.usesSessionOrReactorProjects(configuration);
            if (usesReactorProjects) {
                this.calculateAllConcreteStates(session);
            } else {
                this.calculateConcreteState(project, session, true);
            }
            this.calculateConcreteConfiguration(mojoExecution, project, session);
            List reportExecutions = null;
            if (mojoDescriptor.isRequiresReports()) {
                reportExecutions = this.getReportExecutions(project, forkEntryPoints, mojoExecution, session);
            }
            boolean hasFork = false;
            if (mojoDescriptor.getExecutePhase() != null || mojoDescriptor.getExecuteGoal() != null) {
                hasFork = true;
            } else if (reportExecutions != null) {
                for (MojoExecution reportExecution : reportExecutions) {
                    MojoDescriptor reportDescriptor = reportExecution.getMojoDescriptor();
                    if (reportDescriptor.getExecutePhase() == null && reportDescriptor.getExecuteGoal() == null) continue;
                    hasFork = true;
                }
            }
            if (hasFork) {
                this.createExecutionProject(project, session, true);
                if (usesReactorProjects) {
                    reactorProjects = session.getSortedProjects();
                    for (MavenProject reactorProject : reactorProjects) {
                        this.createExecutionProject(reactorProject, session, false);
                    }
                }
            }
            if (mojoDescriptor.getExecutePhase() != null || mojoDescriptor.getExecuteGoal() != null) {
                forkEntryPoints.push(mojoDescriptor);
                this.forkLifecycle(mojoDescriptor, forkEntryPoints, session, project, mojoExecution.getExecutionId());
                forkEntryPoints.pop();
            }
            if (mojoDescriptor.isRequiresReports()) {
                List reports = this.getReports(reportExecutions, project, mojoExecution, session);
                mojoExecution.setReports(reports);
                for (MojoExecution forkedExecution : mojoExecution.getForkedExecutions()) {
                    MojoDescriptor descriptor = forkedExecution.getMojoDescriptor();
                    if (descriptor.getExecutePhase() == null) continue;
                    forkEntryPoints.push(descriptor);
                    this.forkLifecycle(descriptor, forkEntryPoints, session, project, forkedExecution.getExecutionId());
                    forkEntryPoints.pop();
                }
            }
            if (hasFork) {
                this.calculateConcreteState(project.getExecutionProject(), session, true);
                if (usesReactorProjects) {
                    this.calculateAllConcreteStates(session);
                    reactorProjects = session.getSortedProjects();
                    for (MavenProject reactorProject : reactorProjects) {
                        this.calculateConcreteState(reactorProject.getExecutionProject(), session, false);
                    }
                }
            }
            try {
                this.pluginManager.executeMojo(project, mojoExecution, session);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Internal error in the plugin manager executing goal '" + mojoDescriptor.getId() + "': " + e.getMessage(), e);
            }
            catch (ArtifactNotFoundException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
            catch (InvalidDependencyVersionException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
            catch (ArtifactResolutionException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
            catch (MojoFailureException e) {
                throw new BuildFailureException(e.getMessage(), e);
            }
            catch (MojoExecutionException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
            catch (PluginConfigurationException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
        }
    }

    private void createExecutionProject(MavenProject project, MavenSession session, boolean processProjectReferences) throws LifecycleExecutionException {
        MavenProject executionProject = new MavenProject(project);
        this.calculateConcreteState(executionProject, session, processProjectReferences);
        project.setExecutionProject(executionProject);
    }

    private boolean usesSessionOrReactorProjects(PlexusConfiguration configuration) {
        String value;
        String string = value = configuration != null ? String.valueOf(configuration) : null;
        return value != null && (value.indexOf("${session") > -1 || value.indexOf("${reactorProjects}") > -1);
    }

    private void calculateConcreteConfiguration(MojoExecution mojoExecution, MavenProject project, MavenSession session) throws LifecycleExecutionException {
        if (mojoExecution.getConfiguration() == null) {
            return;
        }
        try {
            mojoExecution.setConfiguration((Xpp3Dom)this.configInterpolator.interpolate(mojoExecution.getConfiguration(), project, session.getProjectBuilderConfiguration()));
        }
        catch (ConfigurationInterpolationException e) {
            throw new LifecycleExecutionException("Error interpolating configuration for: '" + mojoExecution.getMojoDescriptor().getRoleHint() + "' (execution: '" + mojoExecution.getExecutionId() + "')", e);
        }
    }

    private void calculateAllConcreteStates(MavenSession session) throws LifecycleExecutionException {
        List<MavenProject> projects = session.getSortedProjects();
        if (projects != null) {
            Iterator<MavenProject> it = projects.iterator();
            while (it.hasNext()) {
                this.calculateConcreteState(it.next(), session, false);
            }
        }
    }

    private void calculateConcreteState(MavenProject project, MavenSession session, boolean processReferences) throws LifecycleExecutionException {
        if (this.mavenProjectBuilder != null && project != null) {
            try {
                this.mavenProjectBuilder.calculateConcreteState(project, session.getProjectBuilderConfiguration(), processReferences);
            }
            catch (ModelInterpolationException e) {
                throw new LifecycleExecutionException("Failed to calculate concrete state for project: " + project, e);
            }
        }
    }

    private List getReportExecutions(MavenProject project, Stack forkEntryPoints, MojoExecution mojoExecution, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        ArrayList<ReportPlugin> reportPlugins = project.getReportPlugins();
        if (project.getModel().getReports() != null) {
            this.getLogger().error("Plugin contains a <reports/> section: this is IGNORED - please use <reporting/> instead.");
        }
        if (project.getReporting() == null || !project.getReporting().isExcludeDefaults()) {
            reportPlugins = reportPlugins == null ? new ArrayList<ReportPlugin>() : new ArrayList(reportPlugins);
            for (String report : this.defaultReports) {
                StringTokenizer tok = new StringTokenizer(report, ":");
                int count = tok.countTokens();
                if (count != 2 && count != 3) {
                    this.getLogger().warn("Invalid default report ignored: '" + report + "' (must be groupId:artifactId[:version])");
                    continue;
                }
                String groupId = tok.nextToken();
                String artifactId = tok.nextToken();
                String version = tok.hasMoreTokens() ? tok.nextToken() : null;
                boolean found = false;
                Iterator j = reportPlugins.iterator();
                while (j.hasNext() && !found) {
                    ReportPlugin reportPlugin = (ReportPlugin)j.next();
                    if (!reportPlugin.getGroupId().equals(groupId) || !reportPlugin.getArtifactId().equals(artifactId)) continue;
                    found = true;
                }
                if (found) continue;
                ReportPlugin reportPlugin = new ReportPlugin();
                reportPlugin.setGroupId(groupId);
                reportPlugin.setArtifactId(artifactId);
                reportPlugin.setVersion(version);
                reportPlugins.add(reportPlugin);
            }
        }
        ArrayList reports = new ArrayList();
        if (reportPlugins != null) {
            for (ReportPlugin reportPlugin : reportPlugins) {
                List<ReportSet> reportSets = reportPlugin.getReportSets();
                if (reportSets == null || reportSets.isEmpty()) {
                    reports.addAll(this.getReportExecutions(reportPlugin, forkEntryPoints, null, project, session, mojoExecution));
                    continue;
                }
                for (ReportSet reportSet : reportSets) {
                    reports.addAll(this.getReportExecutions(reportPlugin, forkEntryPoints, reportSet, project, session, mojoExecution));
                }
            }
        }
        return reports;
    }

    private List getReportExecutions(ReportPlugin reportPlugin, Stack forkEntryPoints, ReportSet reportSet, MavenProject project, MavenSession session, MojoExecution mojoExecution) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor = this.verifyReportPlugin(reportPlugin, project, session);
        ArrayList<MojoExecution> reports = new ArrayList<MojoExecution>();
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            if (forkEntryPoints.contains(mojoDescriptor)) {
                this.getLogger().debug("Omitting report: " + mojoDescriptor.getFullGoalName() + " from reports list. It initiated part of the fork currently executing.");
                continue;
            }
            if (reportSet != null && !reportSet.getReports().contains(mojoDescriptor.getGoal())) continue;
            String id = null;
            id = reportSet != null ? reportSet.getId() : mojoExecution.getExecutionId();
            MojoExecution reportExecution = id.startsWith("default-") ? new MojoExecution(mojoDescriptor) : new MojoExecution(mojoDescriptor, id);
            reports.add(reportExecution);
        }
        return reports;
    }

    private List getReports(List reportExecutions, MavenProject project, MojoExecution mojoExecution, MavenSession session) throws LifecycleExecutionException {
        ArrayList<MavenReport> reports = new ArrayList<MavenReport>();
        for (MojoExecution reportExecution : reportExecutions) {
            PluginDescriptor pluginDescriptor = reportExecution.getMojoDescriptor().getPluginDescriptor();
            try {
                MavenReport reportMojo = this.pluginManager.getReport(project, reportExecution, session);
                if (reportMojo == null) continue;
                reports.add(reportMojo);
                mojoExecution.addMojoExecution(reportExecution);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting reports from the plugin '" + pluginDescriptor.getId() + "': " + e.getMessage(), e);
            }
            catch (PluginConfigurationException e) {
                throw new LifecycleExecutionException("Error getting reports from the plugin '" + pluginDescriptor.getId() + "'", e);
            }
            catch (ArtifactNotFoundException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
            catch (ArtifactResolutionException e) {
                throw new LifecycleExecutionException(e.getMessage(), e);
            }
        }
        return reports;
    }

    private void forkLifecycle(MojoDescriptor mojoDescriptor, Stack ancestorLifecycleForkers, MavenSession session, MavenProject project, String executionId) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        this.getLogger().info("Preparing " + pluginDescriptor.getGoalPrefix() + ":" + mojoDescriptor.getGoal());
        if (mojoDescriptor.isAggregator()) {
            for (MavenProject reactorProject : session.getSortedProjects()) {
                this.line();
                this.getLogger().info("Building " + reactorProject.getName());
                this.line();
                this.forkProjectLifecycle(mojoDescriptor, ancestorLifecycleForkers, session, reactorProject, executionId);
            }
        } else {
            this.forkProjectLifecycle(mojoDescriptor, ancestorLifecycleForkers, session, project, executionId);
        }
    }

    private void forkProjectLifecycle(MojoDescriptor mojoDescriptor, Stack forkEntryPoints, MavenSession session, MavenProject project, String executionId) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        Lifecycle lifecycle;
        project = project.getExecutionProject();
        forkEntryPoints.push(mojoDescriptor);
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        String targetPhase = mojoDescriptor.getExecutePhase();
        Map lifecycleMappings = null;
        if (targetPhase != null) {
            lifecycle = this.getLifecycleForPhase(targetPhase);
            lifecycleMappings = this.constructLifecycleMappings(session, targetPhase, project, lifecycle);
            String executeLifecycle = mojoDescriptor.getExecuteLifecycle();
            if (executeLifecycle != null) {
                org.apache.maven.plugin.lifecycle.Lifecycle lifecycleOverlay;
                try {
                    lifecycleOverlay = pluginDescriptor.getLifecycleMapping(executeLifecycle);
                }
                catch (IOException e) {
                    throw new LifecycleExecutionException("Unable to read lifecycle mapping file: " + e.getMessage(), e);
                }
                catch (XmlPullParserException e) {
                    throw new LifecycleExecutionException("Unable to parse lifecycle mapping file: " + e.getMessage(), e);
                }
                if (lifecycleOverlay == null) {
                    throw new LifecycleExecutionException("Lifecycle '" + executeLifecycle + "' not found in plugin");
                }
                for (Phase phase : lifecycleOverlay.getPhases()) {
                    for (Execution exec : phase.getExecutions()) {
                        for (String goal : exec.getGoals()) {
                            PluginDescriptor lifecyclePluginDescriptor;
                            String lifecycleGoal;
                            if (goal.indexOf(":") > 0) {
                                String[] s2 = StringUtils.split(goal, ":");
                                String groupId = s2[0];
                                String artifactId = s2[1];
                                lifecycleGoal = s2[2];
                                Plugin plugin = new Plugin();
                                plugin.setGroupId(groupId);
                                plugin.setArtifactId(artifactId);
                                lifecyclePluginDescriptor = this.verifyPlugin(plugin, project, session);
                                if (lifecyclePluginDescriptor == null) {
                                    throw new LifecycleExecutionException("Unable to find plugin " + groupId + ":" + artifactId);
                                }
                            } else {
                                lifecyclePluginDescriptor = pluginDescriptor;
                                lifecycleGoal = goal;
                            }
                            Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
                            if (phase.getConfiguration() != null) {
                                configuration = Xpp3Dom.mergeXpp3Dom(new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), configuration);
                            }
                            MojoDescriptor desc = this.getMojoDescriptor(lifecyclePluginDescriptor, lifecycleGoal);
                            MojoExecution mojoExecution = executionId.startsWith("default-") ? new MojoExecution(desc, configuration) : new MojoExecution(desc, configuration, executionId);
                            this.addToLifecycleMappings(lifecycleMappings, phase.getId(), mojoExecution, session.getSettings());
                        }
                    }
                    if (phase.getConfiguration() == null) continue;
                    for (List tasks : lifecycleMappings.values()) {
                        for (MojoExecution exec : tasks) {
                            Xpp3Dom configuration = Xpp3Dom.mergeXpp3Dom(new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), exec.getConfiguration());
                            exec.setConfiguration(configuration);
                        }
                    }
                }
            }
            this.removeFromLifecycle(forkEntryPoints, lifecycleMappings);
        }
        if (targetPhase != null) {
            lifecycle = this.getLifecycleForPhase(targetPhase);
            this.executeGoalWithLifecycle(targetPhase, forkEntryPoints, session, lifecycleMappings, project, lifecycle);
        } else {
            String goal = mojoDescriptor.getExecuteGoal();
            MojoDescriptor desc = this.getMojoDescriptor(pluginDescriptor, goal);
            this.executeGoals(Collections.singletonList(new MojoExecution(desc, goal)), forkEntryPoints, session, project);
        }
    }

    private Lifecycle getLifecycleForPhase(String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = (Lifecycle)this.getPhaseToLifecycleMap().get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private MojoDescriptor getMojoDescriptor(PluginDescriptor pluginDescriptor, String goal) throws LifecycleExecutionException {
        MojoDescriptor desc = pluginDescriptor.getMojo(goal);
        if (desc == null) {
            String prefix;
            String message = "Required goal '" + goal + "' not found in plugin '" + pluginDescriptor.getGoalPrefix() + "'";
            int index = goal.indexOf(58);
            if (index >= 0 && (prefix = goal.substring(index + 1)).equals(pluginDescriptor.getGoalPrefix())) {
                message = message + " (goals should not be prefixed - try '" + prefix + "')";
            }
            throw new LifecycleExecutionException(message);
        }
        return desc;
    }

    private void removeFromLifecycle(Stack lifecycleForkers, Map lifecycleMappings) {
        for (List tasks : lifecycleMappings.values()) {
            Iterator taskIterator = tasks.iterator();
            while (taskIterator.hasNext()) {
                MojoExecution execution = (MojoExecution)taskIterator.next();
                if (!lifecycleForkers.contains(execution.getMojoDescriptor())) continue;
                taskIterator.remove();
                this.getLogger().warn("Removing: " + execution.getMojoDescriptor().getGoal() + " from forked lifecycle, to prevent recursive invocation.");
            }
        }
    }

    private Map constructLifecycleMappings(MavenSession session, String selectedPhase, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        Map lifecycleMappings = this.bindLifecycleForPackaging(session, selectedPhase, project, lifecycle);
        for (Plugin plugin : project.getBuildPlugins()) {
            this.bindPluginToLifecycle(plugin, session, lifecycleMappings, project);
        }
        return lifecycleMappings;
    }

    private Map bindLifecycleForPackaging(MavenSession session, String selectedPhase, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        Map mappings = this.findMappingsForLifecycle(session, project, lifecycle);
        List optionalMojos = this.findOptionalMojosForLifecycle(session, project, lifecycle);
        HashMap lifecycleMappings = new HashMap();
        for (String phase : lifecycle.getPhases()) {
            String phaseTasks = (String)mappings.get(phase);
            if (phaseTasks != null) {
                StringTokenizer tok = new StringTokenizer(phaseTasks, ",");
                while (tok.hasMoreTokens()) {
                    String goal = tok.nextToken().trim();
                    MojoDescriptor mojoDescriptor = this.getMojoDescriptor(goal, session, project, selectedPhase, false, optionalMojos.contains(goal));
                    if (mojoDescriptor == null) continue;
                    if (mojoDescriptor.isDirectInvocationOnly()) {
                        throw new LifecycleExecutionException("Mojo: '" + goal + "' requires direct invocation. It cannot be used as part of lifecycle: '" + project.getPackaging() + "'.");
                    }
                    this.addToLifecycleMappings(lifecycleMappings, phase, new MojoExecution(mojoDescriptor), session.getSettings());
                }
            }
            if (!phase.equals(selectedPhase)) continue;
            break;
        }
        return lifecycleMappings;
    }

    private Map findMappingsForLifecycle(MavenSession session, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m3 = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, session);
            if (m3 != null) {
                mappings = m3.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m3 = (LifecycleMapping)session.lookup(LifecycleMapping.ROLE, packaging);
                    mappings = m3.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List findOptionalMojosForLifecycle(MavenSession session, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m3 = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, session);
        if (m3 != null) {
            optionalMojos = m3.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m3 = (LifecycleMapping)session.lookup(LifecycleMapping.ROLE, packaging);
                optionalMojos = m3.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e.getMessage(), e);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.EMPTY_LIST;
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext() && pluginComponent == null) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.loadPluginFully(plugin, project, session);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Unable to find the lifecycle component in the extension", e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), e);
            }
        }
        return pluginComponent;
    }

    private Map<String, ArtifactHandler> findArtifactTypeHandlersInPlugins(MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        HashMap<String, ArtifactHandler> map = new HashMap<String, ArtifactHandler>();
        for (Plugin plugin : project.getBuildPlugins()) {
            if (!plugin.isExtensions()) continue;
            this.loadPluginFully(plugin, project, session);
            try {
                Map components = this.pluginManager.getPluginComponents(plugin, ArtifactHandler.ROLE);
                map.putAll(components);
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Unable to find the lifecycle component in the extension", e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error looking up available components from plugin '" + plugin.getKey() + "': " + e.getMessage(), e);
            }
        }
        return map;
    }

    private void bindPluginToLifecycle(Plugin plugin, MavenSession session, Map phaseMap, MavenProject project) throws LifecycleExecutionException, PluginNotFoundException {
        Settings settings = session.getSettings();
        PluginDescriptor pluginDescriptor = this.verifyPlugin(plugin, project, session);
        if (pluginDescriptor.getMojos() != null && !pluginDescriptor.getMojos().isEmpty() && (plugin.isInheritanceApplied() || pluginDescriptor.isInheritedByDefault())) {
            List<PluginExecution> executions;
            if (plugin.getGoals() != null) {
                this.getLogger().error("Plugin contains a <goals/> section: this is IGNORED - please use <executions/> instead.");
            }
            if ((executions = plugin.getExecutions()) != null) {
                for (PluginExecution execution : executions) {
                    this.bindExecutionToLifecycle(pluginDescriptor, phaseMap, execution, settings);
                }
            }
        }
    }

    private PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.loadPluginDescriptor(plugin, project, session);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        return pluginDescriptor;
    }

    private PluginDescriptor loadPluginFully(Plugin plugin, MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.loadPluginFully(plugin, project, session);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        return pluginDescriptor;
    }

    private PluginDescriptor verifyReportPlugin(ReportPlugin plugin, MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.verifyReportPlugin(plugin, project, session);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting report '" + plugin.getKey() + "': " + e.getMessage(), e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), e);
        }
        return pluginDescriptor;
    }

    private void bindExecutionToLifecycle(PluginDescriptor pluginDescriptor, Map phaseMap, PluginExecution execution, Settings settings) throws LifecycleExecutionException {
        for (String goal : execution.getGoals()) {
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                throw new LifecycleExecutionException("'" + goal + "' was specified in an execution, but not found in the plugin");
            }
            if (!execution.isInheritanceApplied() && !mojoDescriptor.isInheritedByDefault()) continue;
            MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, execution.getId());
            String phase = execution.getPhase();
            if (phase == null) {
                phase = mojoDescriptor.getPhase();
            }
            if (phase == null) continue;
            if (mojoDescriptor.isDirectInvocationOnly()) {
                throw new LifecycleExecutionException("Mojo: '" + goal + "' requires direct invocation. It cannot be used as part of the lifecycle (it was included via the POM).");
            }
            this.addToLifecycleMappings(phaseMap, phase, mojoExecution, settings);
        }
    }

    private void addToLifecycleMappings(Map lifecycleMappings, String phase, MojoExecution mojoExecution, Settings settings) {
        ArrayList<MojoExecution> goals = (ArrayList<MojoExecution>)lifecycleMappings.get(phase);
        if (goals == null) {
            goals = new ArrayList<MojoExecution>();
            lifecycleMappings.put(phase, goals);
        }
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (settings.isOffline() && mojoDescriptor.isOnlineRequired()) {
            String goal = mojoDescriptor.getGoal();
            this.getLogger().warn(goal + " requires online mode, but maven is currently offline. Disabling " + goal + ".");
        } else {
            goals.add(mojoExecution);
        }
    }

    private List processGoalChain(String task, Map phaseMap, Lifecycle lifecycle) {
        ArrayList goals = new ArrayList();
        int index = lifecycle.getPhases().indexOf(task);
        for (int i = 0; i <= index; ++i) {
            String p = (String)lifecycle.getPhases().get(i);
            List phaseGoals = (List)phaseMap.get(p);
            if (phaseGoals == null) continue;
            goals.addAll(phaseGoals);
        }
        return goals;
    }

    private MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project, String invokedVia, boolean canUsePrefix, boolean isOptionalMojo) throws BuildFailureException, LifecycleExecutionException, PluginNotFoundException {
        Plugin plugin = null;
        PluginDescriptor pluginDescriptor = null;
        try {
            String goal;
            StringTokenizer tok = new StringTokenizer(task, ":");
            int numTokens = tok.countTokens();
            if (numTokens == 2) {
                if (!canUsePrefix) {
                    String msg = "Mapped-prefix lookup of mojos are only supported from direct invocation. Please use specification of the form groupId:artifactId[:version]:goal instead. (Offending mojo: '" + task + "', invoked via: '" + invokedVia + "')";
                    throw new LifecycleExecutionException(msg);
                }
                String prefix = tok.nextToken();
                goal = tok.nextToken();
                pluginDescriptor = this.pluginManager.getPluginDescriptorForPrefix(prefix);
                if (pluginDescriptor != null) {
                    plugin = new Plugin();
                    plugin.setGroupId(pluginDescriptor.getGroupId());
                    plugin.setArtifactId(pluginDescriptor.getArtifactId());
                    plugin.setVersion(pluginDescriptor.getVersion());
                }
                if (plugin == null) {
                    for (Plugin buildPlugin : project.getBuildPlugins()) {
                        PluginDescriptor desc = this.verifyPlugin(buildPlugin, project, session);
                        if (!prefix.equals(desc.getGoalPrefix())) continue;
                        plugin = buildPlugin;
                        pluginDescriptor = desc;
                        break;
                    }
                }
                if (plugin == null) {
                    plugin = this.pluginManager.getPluginDefinitionForPrefix(prefix, session, project);
                }
                if (plugin == null) {
                    plugin = new Plugin();
                    plugin.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
                    plugin.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId(prefix));
                }
            } else if (numTokens == 3 || numTokens == 4) {
                plugin = new Plugin();
                plugin.setGroupId(tok.nextToken());
                plugin.setArtifactId(tok.nextToken());
                if (numTokens == 4) {
                    plugin.setVersion(tok.nextToken());
                }
                goal = tok.nextToken();
            } else {
                String message = "Invalid task '" + task + "': you must specify a valid lifecycle phase, or" + " a goal in the format plugin:goal or pluginGroupId:pluginArtifactId:pluginVersion:goal";
                throw new BuildFailureException(message);
            }
            if (plugin.getVersion() == null) {
                for (Plugin buildPlugin : project.getBuildPlugins()) {
                    if (!buildPlugin.getKey().equals(plugin.getKey())) continue;
                    plugin = buildPlugin;
                    break;
                }
                project.injectPluginManagementInfo(plugin);
            }
            if (pluginDescriptor == null) {
                pluginDescriptor = this.verifyPlugin(plugin, project, session);
            }
            project.addPlugin(plugin);
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                if (isOptionalMojo) {
                    this.getLogger().info("Skipping missing optional mojo: " + task);
                } else {
                    throw new BuildFailureException("Required goal not found: " + task + " in " + pluginDescriptor.getId());
                }
            }
            return mojoDescriptor;
        }
        catch (PluginNotFoundException e) {
            if (!isOptionalMojo) {
                throw e;
            }
            this.getLogger().info("Skipping missing optional mojo: " + task);
            this.getLogger().debug("Mojo: " + task + " could not be found. Reason: " + e.getMessage(), e);
            return null;
        }
    }

    protected void line() {
        this.getLogger().info("------------------------------------------------------------------------");
    }

    public Map getPhaseToLifecycleMap() throws LifecycleExecutionException {
        if (this.phaseToLifecycleMap == null) {
            this.phaseToLifecycleMap = new HashMap();
            for (Lifecycle lifecycle : this.lifecycles) {
                for (String phase : lifecycle.getPhases()) {
                    if (this.phaseToLifecycleMap.containsKey(phase)) {
                        Lifecycle prevLifecycle = (Lifecycle)this.phaseToLifecycleMap.get(phase);
                        throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                    }
                    this.phaseToLifecycleMap.put(phase, lifecycle);
                }
            }
        }
        return this.phaseToLifecycleMap;
    }

    @Override
    public List getLifecycles() {
        return this.lifecycles;
    }

    @Override
    public void initialize() throws InitializationException {
        if (this.mavenProjectBuilder == null) {
            this.warnOfIncompleteComponentConfiguration(MavenProjectBuilder.ROLE);
            try {
                this.mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(MavenProjectBuilder.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new InitializationException("Failed to lookup project builder after it was NOT injected via component requirement.");
            }
        }
        if (this.modelInterpolator == null) {
            this.warnOfIncompleteComponentConfiguration(ModelInterpolator.ROLE);
            try {
                this.modelInterpolator = (ModelInterpolator)this.container.lookup(ModelInterpolator.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new InitializationException("Failed to lookup model interpolator after it was NOT injected via component requirement.");
            }
        }
        if (this.configInterpolator == null) {
            this.warnOfIncompleteComponentConfiguration(ConfigurationInterpolator.ROLE);
            try {
                this.configInterpolator = (ConfigurationInterpolator)this.container.lookup(ConfigurationInterpolator.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new InitializationException("Failed to lookup plugin-configuration interpolator after it was NOT injected via component requirement.");
            }
        }
    }

    private void warnOfIncompleteComponentConfiguration(String role) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n************ WARNING ************");
        buffer.append("\n\nThis Maven runtime contains a LifecycleExecutor component with an incomplete configuration.");
        buffer.append("\n\nLifecycleExecutor class: ").append(this.getClass().getName());
        buffer.append("\nMissing component requirement: ").append(role);
        buffer.append("\n");
        buffer.append("\nNOTE: This seems to be a third-party Maven derivative you are using. If so, please");
        buffer.append("\nnotify the developers for this derivative project of the problem. The Apache Maven team is not");
        buffer.append("\nresponsible for maintaining the integrity of third-party component overrides.");
        buffer.append("\n\n");
        this.getLogger().warn(buffer.toString());
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    private static class TaskSegment {
        private boolean aggregate;
        private final List tasks = new ArrayList();

        TaskSegment() {
        }

        TaskSegment(boolean aggregate) {
            this.aggregate = aggregate;
        }

        public String toString() {
            StringBuffer message = new StringBuffer();
            message.append(" task-segment: [");
            Iterator it = this.tasks.iterator();
            while (it.hasNext()) {
                String task = (String)it.next();
                message.append(task);
                if (!it.hasNext()) continue;
                message.append(", ");
            }
            message.append("]");
            if (this.aggregate) {
                message.append(" (aggregator-style)");
            }
            return message.toString();
        }

        boolean aggregate() {
            return this.aggregate;
        }

        void add(String task) {
            this.tasks.add(task);
        }

        List getTasks() {
            return this.tasks;
        }
    }
}

