/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.AbstractDocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Writer;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.index.IndexingSink;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pdf.DocumentDescriptorReader;
import org.apache.maven.plugins.pdf.DocumentModelBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.settings.Settings;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="pdf", threadSafe=true)
public class PdfMojo
extends AbstractMojo
implements Contextualizable {
    private static final String EOL = System.getProperty("line.separator");
    @Component(hint="fo")
    private PdfRenderer foRenderer;
    @Component
    private I18N i18n;
    @Component(hint="itext")
    private PdfRenderer itextRenderer;
    @Parameter(property="locales")
    private String locales;
    @Component
    private Renderer siteRenderer;
    @Component
    private SiteTool siteTool;
    @Component(role=PluginManager.class)
    private PluginManager pluginManager;
    @Component
    private Doxia doxia;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${basedir}/src/site", required=true)
    private File siteDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-site", required=true)
    private File generatedSiteDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf", required=true)
    private File workingDirectory;
    @Parameter(defaultValue="src/site/pdf.xml")
    private File docDescriptor;
    @Parameter(property="implementation", defaultValue="fo", required=true)
    private String implementation;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="aggregate", defaultValue="true")
    private boolean aggregate;
    @Parameter(defaultValue="${plugin.version}", readonly=true)
    private String pluginVersion;
    @Parameter(property="includeReports", defaultValue="true")
    private boolean includeReports;
    @Parameter(property="generateTOC", defaultValue="start")
    private String generateTOC;
    @Parameter(property="validate", defaultValue="false")
    private boolean validate;
    @Parameter(defaultValue="${reports}", required=true, readonly=true)
    private MavenReport[] reports;
    @Parameter(defaultValue="${project.reporting.plugins}", readonly=true)
    private ReportPlugin[] reportingPlugins;
    private DocumentRenderer docRenderer;
    private Locale defaultLocale;
    private List<Locale> localesList;
    private DecorationModel defaultDecorationModel;
    private File siteDirectoryTmp;
    private File generatedSiteDirectoryTmp;
    private Map<Locale, List<MavenReport>> generatedMavenReports;
    private PlexusContainer container;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        try {
            this.generatePdf();
        }
        catch (IOException e) {
            this.debugLogGeneratedModel(this.getDocumentModel(Locale.ENGLISH));
            throw new MojoExecutionException("Error during document generation: " + e.getMessage(), e);
        }
        try {
            this.copyGeneratedPdf();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated PDF: " + e.getMessage(), e);
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    private void init() {
        if ("fo".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.foRenderer;
        } else if ("itext".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.itextRenderer;
        } else {
            this.getLog().warn("Invalid 'implementation' parameter: '" + this.implementation + "', using 'fo' as default.");
            this.docRenderer = this.foRenderer;
        }
        if (!("none".equalsIgnoreCase(this.generateTOC) || "start".equalsIgnoreCase(this.generateTOC) || "end".equalsIgnoreCase(this.generateTOC))) {
            this.getLog().warn("Invalid 'generateTOC' parameter: '" + this.generateTOC + "', using 'start' as default.");
            this.generateTOC = "start";
        }
    }

    private void copyGeneratedPdf() throws MojoExecutionException, IOException {
        boolean requireCopy = !this.outputDirectory.getCanonicalPath().equals(this.workingDirectory.getCanonicalPath());
        String outputName = this.getDocumentModel(this.getDefaultLocale()).getOutputName().trim();
        if (!outputName.endsWith(".pdf")) {
            outputName = outputName.concat(".pdf");
        }
        for (Locale locale : this.getAvailableLocales()) {
            File generatedPdfSource = new File(this.getLocaleDirectory(this.workingDirectory, locale), outputName);
            if (!generatedPdfSource.exists()) {
                this.getLog().warn("Unable to find the generated pdf: " + generatedPdfSource.getAbsolutePath());
                continue;
            }
            File generatedPdfDest = new File(this.getLocaleDirectory(this.outputDirectory, locale), outputName);
            if (requireCopy) {
                FileUtils.copyFile(generatedPdfSource, generatedPdfDest);
                generatedPdfSource.delete();
            }
            this.getLog().info("pdf generated: " + generatedPdfDest);
        }
    }

    private void generatePdf() throws MojoExecutionException, IOException {
        Locale.setDefault(this.getDefaultLocale());
        for (Locale locale : this.getAvailableLocales()) {
            File workingDir = this.getLocaleDirectory(this.workingDirectory, locale);
            File siteDirectoryFile = this.getLocaleDirectory(this.getSiteDirectoryTmp(), locale);
            this.copyResources(locale);
            this.generateMavenReports(locale);
            DocumentRendererContext context = new DocumentRendererContext();
            context.put("project", this.project);
            context.put("settings", this.settings);
            context.put("PathTool", new PathTool());
            context.put("FileUtils", new FileUtils());
            context.put("StringUtils", new StringUtils());
            context.put("i18n", this.i18n);
            context.put("generateTOC", this.generateTOC);
            context.put("validate", this.validate);
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
            DocumentModel model = this.aggregate ? this.getDocumentModel(locale) : null;
            try {
                ((AbstractDocumentRenderer)this.docRenderer).render(siteDirectoryFile, workingDir, model, context);
            }
            catch (DocumentRendererException e) {
                throw new MojoExecutionException("Error during document generation: " + e.getMessage(), e);
            }
        }
    }

    private File getSiteDirectoryTmp() throws IOException {
        if (this.siteDirectoryTmp == null) {
            File tmpSiteDir = new File(this.workingDirectory, "site.tmp");
            this.prepareTempSiteDirectory(tmpSiteDir);
            this.siteDirectoryTmp = tmpSiteDir;
        }
        return this.siteDirectoryTmp;
    }

    private File getGeneratedSiteDirectoryTmp() {
        if (this.generatedSiteDirectoryTmp == null) {
            this.generatedSiteDirectoryTmp = new File(this.workingDirectory, "generated-site.tmp");
        }
        return this.generatedSiteDirectoryTmp;
    }

    private void prepareTempSiteDirectory(File tmpSiteDir) throws IOException {
        tmpSiteDir.mkdirs();
        if (this.siteDirectory.exists()) {
            FileUtils.copyDirectoryStructure(this.siteDirectory, tmpSiteDir);
        }
        List<String> files = FileUtils.getFileAndDirectoryNames(tmpSiteDir, FileUtils.getDefaultExcludesAsString(), null, true, true, true, true);
        for (String fileName : files) {
            File file = new File(fileName);
            if (file.isDirectory()) {
                FileUtils.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        this.copySiteDir(this.generatedSiteDirectory, tmpSiteDir);
    }

    private void copySiteDir(File from, File to) throws IOException {
        if (from == null || !from.exists()) {
            return;
        }
        for (Locale locale : this.getAvailableLocales()) {
            String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
            List<String> siteFiles = FileUtils.getFileNames(this.siteDirectory, "**/*", excludes, false);
            File siteDirectoryLocale = new File(this.siteDirectory, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && siteDirectoryLocale.exists()) {
                siteFiles = FileUtils.getFileNames(siteDirectoryLocale, "**/*", excludes, false);
            }
            List<String> generatedSiteFiles = FileUtils.getFileNames(from, "**/*", excludes, false);
            File fromLocale = new File(from, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && fromLocale.exists()) {
                generatedSiteFiles = FileUtils.getFileNames(fromLocale, "**/*", excludes, false);
            }
            for (String generatedSiteFile : generatedSiteFiles) {
                File out;
                File in;
                if (siteFiles.contains(generatedSiteFile)) {
                    this.getLog().warn("Generated-site already contains a file in site: " + generatedSiteFile + ". Ignoring copying it!");
                    continue;
                }
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    if (!fromLocale.exists()) continue;
                    in = new File(fromLocale, generatedSiteFile);
                    out = new File(new File(to, locale.getLanguage()), generatedSiteFile);
                    out.getParentFile().mkdirs();
                    FileUtils.copyFile(in, out);
                    continue;
                }
                in = new File(from, generatedSiteFile);
                out = new File(to, generatedSiteFile);
                out.getParentFile().mkdirs();
                FileUtils.copyFile(in, out);
            }
        }
    }

    private DocumentModel getDocumentModel(Locale locale) throws MojoExecutionException {
        if (this.docDescriptor.exists()) {
            DocumentModel doc = this.getDocumentModelFromDescriptor(locale);
            this.appendGeneratedReports(doc, locale);
            return doc;
        }
        DocumentModel model = new DocumentModelBuilder(this.project, this.getDefaultDecorationModel()).getDocumentModel();
        model.getMeta().setGenerator(this.getDefaultGenerator());
        model.getMeta().setLanguage(locale.getLanguage());
        model.getCover().setCoverType(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.type"));
        model.getToc().setName(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.title"));
        this.appendGeneratedReports(model, locale);
        this.debugLogGeneratedModel(model);
        return model;
    }

    private DocumentModel getDocumentModelFromDescriptor(Locale locale) throws MojoExecutionException {
        DocumentModel model;
        try {
            model = new DocumentDescriptorReader(this.project, this.getLog(), locale).readAndFilterDocumentDescriptor(this.docDescriptor);
        }
        catch (XmlPullParserException ex) {
            throw new MojoExecutionException("Error reading DocumentDescriptor!", ex);
        }
        catch (IOException io) {
            throw new MojoExecutionException("Error opening DocumentDescriptor!", io);
        }
        if (model.getMeta() == null) {
            model.setMeta(new DocumentMeta());
        }
        if (StringUtils.isEmpty(model.getMeta().getLanguage())) {
            model.getMeta().setLanguage(locale.getLanguage());
        }
        if (StringUtils.isEmpty(model.getMeta().getGenerator())) {
            model.getMeta().setGenerator(this.getDefaultGenerator());
        }
        return model;
    }

    private File getLocaleDirectory(File basedir, Locale locale) {
        if (locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
            return basedir;
        }
        return new File(basedir, locale.getLanguage());
    }

    private Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = this.getAvailableLocales().get(0);
        }
        return this.defaultLocale;
    }

    private List<Locale> getAvailableLocales() {
        if (this.localesList == null) {
            this.localesList = this.siteTool.getSiteLocales(this.locales);
        }
        return this.localesList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DecorationModel getDefaultDecorationModel() throws MojoExecutionException {
        if (this.defaultDecorationModel == null) {
            Locale locale = this.getDefaultLocale();
            File descriptorFile = this.siteTool.getSiteDescriptor(this.siteDirectory, locale);
            DecorationModel decoration = null;
            if (descriptorFile.exists()) {
                org.apache.commons.io.input.XmlStreamReader reader = null;
                try {
                    reader = new org.apache.commons.io.input.XmlStreamReader(descriptorFile);
                    String siteDescriptorContent = IOUtil.toString(reader);
                    reader.close();
                    reader = null;
                    siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(new HashMap<String, String>(2), this.project, siteDescriptorContent);
                    decoration = new DecorationXpp3Reader().read(new StringReader(siteDescriptorContent));
                }
                catch (XmlPullParserException e) {
                    try {
                        throw new MojoExecutionException("Error parsing site descriptor", e);
                        catch (IOException e2) {
                            throw new MojoExecutionException("Error reading site descriptor", e2);
                        }
                        catch (SiteToolException e3) {
                            throw new MojoExecutionException("Error when interpoling site descriptor", e3);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(reader);
                        throw throwable;
                    }
                }
                IOUtil.close(reader);
            }
            this.defaultDecorationModel = decoration;
        }
        return this.defaultDecorationModel;
    }

    private void copyResources(Locale locale) throws MojoExecutionException {
        Artifact skinArtifact;
        DecorationModel decorationModel = this.getDefaultDecorationModel();
        if (decorationModel == null) {
            return;
        }
        try {
            skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.project.getRemoteArtifactRepositories(), decorationModel);
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), e);
        }
        if (skinArtifact == null) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Copy resources from skin artifact: '" + skinArtifact.getId() + "'...");
        }
        try {
            SiteRenderingContext context = this.siteRenderer.createContextForSkin(skinArtifact, new HashMap(2), decorationModel, this.project.getName(), locale);
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            this.siteRenderer.copyResources(context, this.workingDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), e);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("RendererException: " + e.getMessage(), e);
        }
    }

    private String getDefaultGenerator() {
        return "Maven PDF Plugin v. " + this.pluginVersion + ", '" + this.implementation + "' implementation.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugLogGeneratedModel(DocumentModel docModel) {
        if (this.getLog().isDebugEnabled() && this.project != null) {
            File outputDir = new File(this.project.getBuild().getDirectory(), "pdf");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File doc = FileUtils.createTempFile("pdf", ".xml", outputDir);
            DocumentXpp3Writer xpp3 = new DocumentXpp3Writer();
            XmlStreamWriter w = null;
            try {
                w = WriterFactory.newXmlWriter(doc);
                xpp3.write(w, docModel);
                ((Writer)w).close();
                w = null;
                this.getLog().debug("Generated a default document model: " + doc.getAbsolutePath());
            }
            catch (IOException e) {
                this.getLog().error("Failed to write document model: " + e.getMessage());
                this.getLog().debug(e);
            }
            finally {
                IOUtil.close(w);
            }
        }
    }

    private void generateMavenReports(Locale locale) throws MojoExecutionException, IOException {
        if (!this.includeReports) {
            this.getLog().info("Skipped report generation.");
            return;
        }
        if (this.project.getReporting() == null) {
            this.getLog().info("No report was specified.");
            return;
        }
        List<MavenReportExecution> reportExecutions = this.getReports();
        for (MavenReportExecution reportExecution : reportExecutions) {
            this.generateMavenReport(reportExecution, locale);
        }
        this.copySiteDir(this.getGeneratedSiteDirectoryTmp(), this.getSiteDirectoryTmp());
        this.copySiteDir(this.generatedSiteDirectory, this.getSiteDirectoryTmp());
    }

    private void generateMavenReport(MavenReportExecution reportExecution, Locale locale) throws IOException, MojoExecutionException {
        MavenReport report = reportExecution.getMavenReport();
        String localReportName = report.getName(locale);
        if (!reportExecution.canGenerateReport()) {
            this.getLog().info("Skipped \"" + localReportName + "\" report.");
            this.getLog().debug("canGenerateReport() was false.");
            return;
        }
        if (report.isExternalReport()) {
            this.getLog().info("Skipped external \"" + localReportName + "\" report (not supported by pdf plugin).");
            this.getLog().debug("isExternalReport() was false.");
            return;
        }
        for (MavenReport mavenReport : this.getGeneratedMavenReports(locale)) {
            if (!report.getName(locale).equals(mavenReport.getName(locale))) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(report.getName(locale) + " was already generated.");
            }
            return;
        }
        File outDir = new File(this.getGeneratedSiteDirectoryTmp(), "xdoc");
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            outDir = new File(new File(this.getGeneratedSiteDirectoryTmp(), locale.getLanguage()), "xdoc");
        }
        outDir.mkdirs();
        File file = new File(outDir, report.getOutputName() + ".xml");
        String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
        List<String> files = FileUtils.getFileNames(this.siteDirectory, "*/" + report.getOutputName() + ".*", excludes, false);
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            files = FileUtils.getFileNames(new File(this.siteDirectory, locale.getLanguage()), "*/" + report.getOutputName() + ".*", excludes, false);
        }
        if (files.size() != 0) {
            String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("Skipped \"" + report.getName(locale) + "\" report, file \"" + report.getOutputName() + "\" already exists for the " + displayLanguage + " version.");
            }
            return;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Generating \"" + localReportName + "\" report.");
        }
        StringWriter sw = new StringWriter();
        PdfXdocSink sink = null;
        try {
            sink = new PdfXdocSink(sw);
            this.renderReportToSink(reportExecution, locale, sink);
        }
        catch (MavenReportException e) {
            String goal = reportExecution.getPlugin().getArtifactId() + ':' + reportExecution.getPlugin().getVersion() + ':' + reportExecution.getGoal();
            throw new MojoExecutionException("Error generating " + goal + " report", e);
        }
        finally {
            if (sink != null) {
                sink.close();
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Writing generated xdoc to " + file);
        }
        PdfMojo.writeGeneratedReport(sw.toString(), file);
        if (this.isValidGeneratedReportXdoc(reportExecution.getPlugin().getId() + ':' + reportExecution.getGoal(), file, localReportName)) {
            this.getGeneratedMavenReports(locale).add(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderReportToSink(MavenReportExecution reportExec, Locale locale, PdfXdocSink sink) throws MavenReportException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (reportExec.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(reportExec.getClassLoader());
            }
            MavenReport report = reportExec.getMavenReport();
            report.generate(sink, locale);
        }
        finally {
            if (reportExec.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private List<MavenReport> getGeneratedMavenReports(Locale locale) {
        if (this.generatedMavenReports == null) {
            this.generatedMavenReports = new HashMap<Locale, List<MavenReport>>(2);
        }
        if (this.generatedMavenReports.get(locale) == null) {
            this.generatedMavenReports.put(locale, new ArrayList(2));
        }
        return this.generatedMavenReports.get(locale);
    }

    private void appendGeneratedReports(DocumentModel model, Locale locale) {
        if (!this.includeReports) {
            return;
        }
        if (this.getGeneratedMavenReports(locale).isEmpty()) {
            return;
        }
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        documentTOCItem.setName(this.i18n.getString("pdf-plugin", locale, "toc.project-info.item"));
        documentTOCItem.setRef("/project-info");
        ArrayList<String> addedRef = new ArrayList<String>(4);
        ArrayList<DocumentTOCItem> items = new ArrayList<DocumentTOCItem>(4);
        for (MavenReport report : this.getGeneratedMavenReports(locale)) {
            DocumentTOCItem reportItem = new DocumentTOCItem();
            reportItem.setName(report.getName(locale));
            reportItem.setRef("/" + report.getOutputName());
            items.add(reportItem);
            addedRef.add(report.getOutputName());
        }
        try {
            if (this.generatedSiteDirectory.exists()) {
                String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
                List<String> generatedDirs = FileUtils.getDirectoryNames(this.generatedSiteDirectory, "*", excludes, true);
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    generatedDirs = FileUtils.getFileNames(new File(this.generatedSiteDirectory, locale.getLanguage()), "*", excludes, true);
                }
                for (String generatedDir : generatedDirs) {
                    List<String> generatedFiles = FileUtils.getFileNames(new File(generatedDir), "**.*", excludes, false);
                    for (String generatedFile : generatedFiles) {
                        String title;
                        String ref = generatedFile.substring(0, generatedFile.lastIndexOf(46));
                        if (addedRef.contains(ref) || (title = this.getGeneratedDocumentTitle(new File(generatedDir, generatedFile))) == null) continue;
                        DocumentTOCItem reportItem = new DocumentTOCItem();
                        reportItem.setName(title);
                        reportItem.setRef("/" + ref);
                        items.add(reportItem);
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLog().error("IOException: " + e.getMessage());
            this.getLog().debug(e);
        }
        documentTOCItem.setItems(items);
        model.getToc().addItem(documentTOCItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGeneratedDocumentTitle(File f) throws IOException {
        IndexEntry entry = new IndexEntry("index");
        IndexingSink titleSink = new IndexingSink(entry);
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(f);
            this.doxia.parse(reader, f.getParentFile().getName(), titleSink);
            ((Reader)reader).close();
            reader = null;
        }
        catch (ParseException e) {
            this.getLog().error("ParseException: " + e.getMessage());
            this.getLog().debug(e);
            String string = null;
            return string;
        }
        catch (ParserNotFoundException e) {
            this.getLog().error("ParserNotFoundException: " + e.getMessage());
            this.getLog().debug(e);
            String string = null;
            return string;
        }
        finally {
            IOUtil.close(reader);
        }
        return titleSink.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidGeneratedReportXdoc(String fullGoal, File generatedReport, String localReportName) {
        SinkAdapter sinkAdapter = new SinkAdapter();
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(generatedReport);
            this.doxia.parse(reader, generatedReport.getParentFile().getName(), sinkAdapter);
            ((Reader)reader).close();
            reader = null;
        }
        catch (ParseException e) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append(EOL);
            sb.append("Error when parsing the generated report xdoc file: ");
            sb.append(generatedReport.getAbsolutePath());
            sb.append(EOL);
            sb.append(e.getMessage());
            sb.append(EOL);
            sb.append("You could:").append(EOL);
            sb.append("  * exclude all reports using -DincludeReports=false").append(EOL);
            sb.append("  * remove the ");
            sb.append(fullGoal);
            sb.append(" from the <reporting/> part. To not affect the site generation, ");
            sb.append("you could create a PDF profile.");
            sb.append(EOL).append("Ignoring the \"").append(localReportName).append("\" report in the PDF.").append(EOL);
            this.getLog().error(sb.toString());
            this.getLog().debug(e);
            boolean bl = false;
            return bl;
        }
        catch (ParserNotFoundException e) {
            this.getLog().error("ParserNotFoundException: " + e.getMessage());
            this.getLog().debug(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.getLog().error("IOException: " + e.getMessage());
            this.getLog().debug(e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtil.close(reader);
        }
        return true;
    }

    protected List<MavenReportExecution> getReports() throws MojoExecutionException {
        MavenReportExecutor mavenReportExecutor;
        if (!PdfMojo.isMaven3OrMore()) {
            this.getLog().error("Report generation is not supported with Maven <= 2.x");
        }
        MavenReportExecutorRequest mavenReportExecutorRequest = new MavenReportExecutorRequest();
        mavenReportExecutorRequest.setLocalRepository(this.localRepository);
        mavenReportExecutorRequest.setMavenSession(this.session);
        mavenReportExecutorRequest.setProject(this.project);
        mavenReportExecutorRequest.setReportPlugins(this.reportingPlugins);
        try {
            mavenReportExecutor = (MavenReportExecutor)this.container.lookup(MavenReportExecutor.class.getName());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("could not get MavenReportExecutor component", e);
        }
        return mavenReportExecutor.buildMavenReports(mavenReportExecutorRequest);
    }

    protected static boolean isMaven3OrMore() {
        try {
            DefaultArtifactVersion mavenVersion = new DefaultArtifactVersion(PdfMojo.getMavenVersion());
            return VersionRange.createFromVersionSpec("[3.0,)").containsVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getMavenVersion() {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
            properties.load(in);
            in.close();
            in = null;
        }
        catch (IOException ioe) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close(in);
            return string;
        }
        IOUtil.close(in);
        return properties.getProperty("version").trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeGeneratedReport(String content, File toFile) throws IOException {
        if (StringUtils.isEmpty(content)) {
            return;
        }
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter(toFile);
            writer.write(StringUtils.replace(content, "<table><table", "<table"));
            ((Writer)writer).close();
            writer = null;
        }
        finally {
            IOUtil.close(writer);
        }
    }

    private static String getDefaultExcludesWithLocales(List<Locale> locales, Locale defaultLocale) {
        String excludesLocales = FileUtils.getDefaultExcludesAsString();
        for (Locale locale : locales) {
            if (locale.getLanguage().equals(defaultLocale.getLanguage())) continue;
            excludesLocales = excludesLocales + ",**/" + locale.getLanguage() + "/*";
        }
        return excludesLocales;
    }

    private static class ProjectInfoRenderer
    extends AbstractMavenReportRenderer {
        private final List<MavenReport> generatedReports;
        private final I18N i18n;
        private final Locale locale;

        ProjectInfoRenderer(org.apache.maven.doxia.sink.Sink sink, List<MavenReport> generatedReports, I18N i18n, Locale locale) {
            super(sink);
            this.generatedReports = generatedReports;
            this.i18n = i18n;
            this.locale = locale;
        }

        @Override
        public String getTitle() {
            return this.i18n.getString("pdf-plugin", this.locale, "report.project-info.title");
        }

        @Override
        public void renderBody() {
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.title"));
            this.sink.sectionTitle1_();
            this.sink.paragraph();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.description1") + " ");
            this.sink.link("http://maven.apache.org");
            this.sink.text("Maven");
            this.sink.link_();
            this.sink.text(" " + this.i18n.getString("pdf-plugin", this.locale, "report.project-info.description2"));
            this.sink.paragraph_();
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.sectionTitle"));
            this.sink.sectionTitle2_();
            this.sink.table();
            this.sink.tableRows(new int[]{1, 1}, false);
            String name = this.i18n.getString("pdf-plugin", this.locale, "report.project-info.column.document");
            String description = this.i18n.getString("pdf-plugin", this.locale, "report.project-info.column.description");
            this.sink.tableRow();
            this.sink.tableHeaderCell(SinkEventAttributeSet.CENTER);
            this.sink.text(name);
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell(SinkEventAttributeSet.CENTER);
            this.sink.text(description);
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            if (this.generatedReports != null) {
                for (MavenReport report : this.generatedReports) {
                    this.sink.tableRow();
                    this.sink.tableCell();
                    this.sink.link(report.getOutputName() + ".html");
                    this.sink.text(report.getName(this.locale));
                    this.sink.link_();
                    this.sink.tableCell_();
                    this.sink.tableCell();
                    this.sink.text(report.getDescription(this.locale));
                    this.sink.tableCell_();
                    this.sink.tableRow_();
                }
            }
            this.sink.tableRows_();
            this.sink.table_();
            this.sink.section2_();
            this.sink.section1_();
        }
    }

    private static class PdfXdocSink
    extends XdocSink
    implements Sink {
        protected PdfXdocSink(Writer writer) {
            super(writer);
        }

        @Override
        public void text(String text) {
            super.text(StringUtils.replace(text, "\u0092", "'"));
        }

        @Override
        public void tableRow() {
            if (!this.tableRows) {
                this.tableRows(null, false);
            }
            super.tableRow(null);
        }
    }
}

