/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Integer32;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SmlBoolean;
import org.openmuc.jsml.structures.SmlListType;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned64;
import org.openmuc.jsml.structures.Unsigned8;

public abstract class ImplicitChoice
extends ASNObject {
    public static final int OCTETSTRING = 0;
    public static final int SML_BOOLEAN = 4;
    public static final int INTEGER = 5;
    public static final int UNSIGNED = 6;
    public static final int SML_LIST_TYPE = 7;
    public static final int TL_FIELD = 8;
    private ASNObject choice;

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional() && !this.isSelected()) {
            os.writeByte(1);
            return;
        }
        this.getChoice().encode(os);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        PushbackInputStream ispushback = new PushbackInputStream(is);
        DataInputStream is2 = new DataInputStream(ispushback);
        byte tlFieldChoice = (byte)ispushback.read();
        if (this.isOptional() && tlFieldChoice == 1) {
            this.setSelected(false);
            return true;
        }
        block0 : switch ((tlFieldChoice & 0xF0) >> 4) {
            case 0: {
                this.setChoice(new OctetString());
                break;
            }
            case 4: {
                this.setChoice(new SmlBoolean());
                break;
            }
            case 5: {
                switch (tlFieldChoice & 0xF) {
                    case 2: {
                        this.setChoice(new Integer8());
                        break block0;
                    }
                    case 3: {
                        this.setChoice(new Integer16());
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        this.setChoice(new Integer32());
                        break block0;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.setChoice(new Integer64());
                        break block0;
                    }
                }
                return false;
            }
            case 6: {
                switch (tlFieldChoice & 0xF) {
                    case 2: {
                        this.setChoice(new Unsigned8());
                        break block0;
                    }
                    case 3: {
                        this.setChoice(new Unsigned16());
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        this.setChoice(new Unsigned32());
                        break block0;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.setChoice(new Unsigned64());
                        break block0;
                    }
                }
                return false;
            }
            case 7: {
                this.setChoice(new SmlListType());
                break;
            }
            case 8: {
                this.setChoice(new OctetString());
                break;
            }
            default: {
                return false;
            }
        }
        ispushback.unread(tlFieldChoice);
        if (!this.getChoice().decode(is2)) {
            return false;
        }
        this.setSelected(true);
        return true;
    }

    public ASNObject getChoice() {
        return this.choice;
    }

    public String getDatatype() {
        return this.getChoice().getClass().getName();
    }

    protected void setChoice(ASNObject choice) {
        this.choice = choice;
    }
}

