/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlTimestamp;

public class SmlTimestampLocal
extends Sequence {
    private SmlTimestamp timestamp;
    private Integer16 localOffset;
    private Integer16 seasonTimeOffset;

    public SmlTimestampLocal() {
    }

    public SmlTimestampLocal(SmlTimestamp timestamp, Integer16 localOffset, Integer16 seasonTimeOffset) {
        if (timestamp == null) {
            throw new IllegalArgumentException("SML_TimestampLocal: timestamp is not optional and must not be null!");
        }
        if (localOffset == null) {
            throw new IllegalArgumentException("SML_TimestampLocal: localOffset is not optional and must not be null!");
        }
        if (seasonTimeOffset == null) {
            throw new IllegalArgumentException("SML_TimestampLocal: seasonTimeOffset is not optional and must not be null!");
        }
        this.timestamp = timestamp;
        this.localOffset = localOffset;
        this.seasonTimeOffset = seasonTimeOffset;
        this.setOptionalAndSeq();
        this.setSelected(true);
    }

    public SmlTimestamp getTimestamp() {
        return this.timestamp;
    }

    public Integer16 getLocalOffset() {
        return this.localOffset;
    }

    public Integer16 getSeasonTimeOffset() {
        return this.seasonTimeOffset;
    }

    public void setOptionalAndSeq() {
        this.seqArray(this.timestamp, this.localOffset, this.seasonTimeOffset);
    }

    @Override
    protected void createElements() {
        this.timestamp = new SmlTimestamp();
        this.localOffset = new Integer16();
        this.seasonTimeOffset = new Integer16();
        this.setOptionalAndSeq();
    }
}

