/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.openmuc.jsml.transport.ServerThread;
import org.openmuc.jsml.transport.TConnection;
import org.openmuc.jsml.transport.TConnectionListener;

public class TSAP {
    private Socket socket;
    private ServerThread serverThread;
    private int localPort = -1;
    private boolean started = false;
    private TConnectionListener conListener;
    private ServerSocketFactory serverSocketFactory = null;
    private SocketFactory socketFactory = null;
    private int maxConnections = 100;
    private int messageTimeout = 0;
    private int messageFragmentTimeout = 2000;

    public TSAP() {
        this.socketFactory = SocketFactory.getDefault();
    }

    public TSAP(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public TSAP(int port, TConnectionListener conListener) {
        this(port, conListener, ServerSocketFactory.getDefault());
    }

    public TSAP(int port, TConnectionListener conListener, ServerSocketFactory serverSocketFactory) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port number is out of bound");
        }
        this.localPort = port;
        this.conListener = conListener;
        this.serverSocketFactory = serverSocketFactory;
    }

    public void startListening() throws IOException {
        if (this.localPort == -1) {
            throw new IllegalStateException("TSAP was not constructed as Server TSAP");
        }
        this.started = true;
        this.serverThread = new ServerThread(this, this.serverSocketFactory.createServerSocket(this.localPort), this.maxConnections, this.messageTimeout, this.messageFragmentTimeout);
        this.serverThread.start();
    }

    public void stopListening() {
        if (this.serverThread != null) {
            this.serverThread.stopServer();
        }
        this.serverThread = null;
        this.started = false;
    }

    public void setMaxConnections(int maxConnections) {
        if (this.started) {
            throw new RuntimeException("Trying to set parameter although server has started.");
        }
        if (maxConnections < 0) {
            throw new IllegalArgumentException("maxConnections is out of bound");
        }
        this.maxConnections = maxConnections;
    }

    public void setMessageTimeout(int messageTimeout) {
        if (this.started) {
            throw new RuntimeException("Message timeout may not be set while the server SAP is listening.");
        }
        this.messageTimeout = messageTimeout;
    }

    public void setMessageFragmentTimeout(int messageFragmentTimeout) {
        if (this.started) {
            throw new RuntimeException("Message fragment timeout may not be set while the server SAP is listening.");
        }
        this.messageFragmentTimeout = messageFragmentTimeout;
    }

    protected TConnectionListener getConnectionListener() {
        return this.conListener;
    }

    public TConnection connectTo(InetAddress address, int port, int timeout) throws IOException {
        this.started = true;
        this.socket = this.socketFactory.createSocket();
        this.socket.connect(new InetSocketAddress(address, port), timeout);
        return new TConnection(this.socket, this.messageTimeout, this.messageFragmentTimeout);
    }
}

